/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.domain.IImprintable;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.Quantity;
import pyrosim.io.PyroSimObjectInputStream;

public class FEDMeasurer
extends GasPointMeasurer {
    static final long serialVersionUID = 1L;
    public static final int FEDACT_REST = 1;
    public static final int FEDACT_LIGHT = 2;
    public static final int FEDACT_HEAVY = 3;
    private int d_activityLevel = 2;

    public FEDMeasurer(String name, FreePointLoc loc) {
        this(name, 2, loc);
    }

    public FEDMeasurer(String name, int activity, FreePointLoc loc) {
        super(name, Quantity.FED.create(), loc);
        this.d_activityLevel = activity;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FEDMeasurer)) {
            return false;
        }
        FEDMeasurer fedm = (FEDMeasurer)obj;
        return super.equals(obj) && this.d_activityLevel == fedm.d_activityLevel;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (PyroSimObjectInputStream.getVersion(in) < 164) {
            this.d_activityLevel = 2;
        }
    }

    public void setActivityLevel(int level) {
        this.d_activityLevel = level;
        this.changedEvt(new Object[0]);
    }

    public int getActivityLevel() {
        return this.d_activityLevel;
    }

    @Override
    public IDevice getRestoreObject() {
        return IImprintable.imprintOn(new FEDMeasurer(this.getName(), null), this);
    }

    @Override
    public void imprint(IDevice refObject) {
        this.pauseUpdates();
        super.imprint(refObject);
        FEDMeasurer fmDev = (FEDMeasurer)refObject;
        this.setActivityLevel(fmDev.getActivityLevel());
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }
}

