/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.io.ObjectStreamException;
import pyrosim.Intl;
import pyrosim.domain.IImprintable;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;

public class Clock
extends GasPointMeasurer {
    static final long serialVersionUID = 1L;
    public static final Clock INSTANCE = new Clock();
    public static final IDoubleOutPin INSTANCE_PIN = INSTANCE.getMsrInfo().getPin();

    private Clock() {
        this(Intl.intl("TIME"));
    }

    private Clock(String name) {
        super(name, Quantity.TIME.create(), new FreePointLoc());
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || Clock.isClock(obj);
    }

    public static boolean isClock(Object obj) {
        return obj instanceof Clock;
    }

    public static boolean isClockSignal(IOutPin signal) {
        return Clock.isClock(signal.getAttachedSource());
    }

    @Override
    public IDevice getRestoreObject() {
        return IImprintable.imprintOn(new Clock(this.getName()), this);
    }
}

