/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.detectors;

import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.Intl;
import pyrosim.domain.IImprintable;
import pyrosim.domain.devices.ADevice;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.detectors.IDetector;
import pyrosim.domain.signals.DoubleOutPin;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.ILatchable;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.domain.signals.OneLogicInPin;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.units.UnitDouble;

public class Timer
extends ADevice
implements IDetector,
ILatchable,
Cloneable {
    static final long serialVersionUID = 1L;
    private LogicOutPin d_alarmPin = new LogicOutPin(this);
    private IDoubleOutPin d_quantPin;
    private AlarmInfo d_alarmInfo;
    private OneLogicInPin d_freezePin;

    public Timer(UnitDouble tripTime, boolean initiallyOn) {
        this(Intl.intl("TIMER"), tripTime, initiallyOn);
    }

    public Timer(String name, UnitDouble tripTime, boolean initiallyOn) {
        super(name);
        this.d_alarmInfo = new AlarmInfo(tripTime, TripFlags.toFlags(true, initiallyOn, false));
        this.d_quantPin = this.createQuantPin();
        this.d_freezePin = this.createFreezePin();
    }

    protected IDoubleOutPin createQuantPin() {
        return new DoubleOutPin(this, Intl.intl("TIME"), 2);
    }

    protected OneLogicInPin createFreezePin() {
        return new OneLogicInPin(this);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.d_quantPin == null) {
            this.d_quantPin = this.createQuantPin();
        }
        if (this.d_freezePin == null) {
            this.d_freezePin = this.createFreezePin();
        }
    }

    public int hashCode() {
        return 50330243 + this.getName().hashCode() + this.d_alarmInfo.hashCode() + this.d_freezePin.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Timer)) {
            return false;
        }
        Timer timer = (Timer)obj;
        return super.equals(obj) && this.d_alarmInfo.equals(timer.d_alarmInfo) && this.d_freezePin.equals(timer.d_freezePin);
    }

    @Override
    public Object clone() {
        Timer clone = (Timer)super.clone();
        clone.d_alarmPin = this.d_alarmPin.clone(clone);
        clone.d_quantPin = (IDoubleOutPin)this.d_quantPin.clone(clone);
        clone.d_freezePin = (OneLogicInPin)this.d_freezePin.clone(clone);
        return clone;
    }

    public AlarmInfo getAlarmInfo() {
        return this.d_alarmInfo;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return DisplayGeom.EMPTY;
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.EMPTY_NODE;
    }

    @Override
    public void setGeom(IGeomNode geom) {
    }

    @Override
    public OneLogicInPin getFreezePin() {
        return this.d_freezePin;
    }

    @Override
    public ILogicOutPin getAlarmPin() {
        return this.d_alarmPin;
    }

    @Override
    public IDoubleOutPin getQuantityPin() {
        return this.d_quantPin;
    }

    @Override
    public int getTripFlags() {
        return this.d_alarmInfo.tripFlags;
    }

    @Override
    public void setTripFlags(int tf) {
    }

    @Override
    public boolean latches(ILogicOutPin pin) {
        return TripFlags.latch(this.d_alarmInfo.tripFlags);
    }

    @Override
    public IDevice getRestoreObject() {
        return IImprintable.imprintOn(new Timer(this.getName(), this.d_alarmInfo.setpoint, (this.d_alarmInfo.tripFlags & 2) != 0), this);
    }

    @Override
    public void imprint(IDevice refObject) {
        this.pauseUpdates();
        super.imprint(refObject);
        Timer refTimer = (Timer)refObject;
        this.d_alarmPin = refTimer.d_alarmPin.clone(this);
        this.d_quantPin = (IDoubleOutPin)refTimer.d_quantPin.clone(this);
        this.d_alarmInfo = refTimer.d_alarmInfo;
        this.d_freezePin = (OneLogicInPin)refTimer.d_freezePin.clone(this);
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }
}

