/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.detectors;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public class SprinklerLinkModelMgr
extends Composite<SprinklerLinkModel>
implements Serializable {
    static final long serialVersionUID = 1L;

    public SprinklerLinkModelMgr() {
        this(Intl.intl("Sprinkler Links"));
    }

    public SprinklerLinkModelMgr(String name) {
        super(name, SprinklerLinkModel.class);
    }

    public void addDefaults() {
        List<Pair> defaults = Arrays.asList(new Pair<String, Double[]>(Intl.intl("Generic Commercial Link"), new Double[]{100.0, 68.33}), new Pair<String, Double[]>(Intl.intl("Generic Industrial Link"), new Double[]{100.0, 93.33}), new Pair<String, Double[]>(Intl.intl("Generic Residential Link"), new Double[]{50.0, 68.33}), new Pair<String, Double[]>(Intl.intl("Generic Storage Link"), new Double[]{50.0, 93.33}));
        defaults.forEach(p -> this.addDefault(new SprinklerLinkModel((String)p.v1, new UnitDouble(((Double[])p.v2)[0], SIUS.getInstance().getRtiUnit()), new UnitDouble(((Double[])p.v2)[1], SI.CELSIUS))));
    }
}

