/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.detectors;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import pyrosim.domain.IImprintable;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.detectors.APointDetector;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.util.Util;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.Task;

public class SmokeDetector
extends APointDetector
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    private SmokeLinkModel d_model;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(Color.GREEN, 10.0);

    public SmokeDetector(String name, SmokeLinkModel model) {
        this(name, model, new FreePointLoc());
    }

    public SmokeDetector(String name, SmokeLinkModel model, FreePointLoc loc) {
        super(name, loc);
        this.d_model = model;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SmokeDetector && super.equals(obj) && this.d_model.equals(((SmokeDetector)obj).d_model);
    }

    @Override
    protected IQuantity getQuantity() {
        return Quantity.CHAMBER_OBSCURATION.create();
    }

    public SmokeLinkModel getModel() {
        return this.d_model;
    }

    public void setModel(SmokeLinkModel model) {
        assert (model != null);
        this.d_model = model;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        deps.add(DLink.STRONG, (IPyroObject)this.d_model);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        super.removeInvalidReplacements(old, objs);
        if (old instanceof SmokeLinkModel) {
            Util.keepIfNullOr(objs, SmokeLinkModel.class);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old == this.d_model) {
            assert (replacement != null);
            return new AReplaceRefTask<SmokeLinkModel>((Object)old, (Object)replacement){

                @Override
                public void set(SmokeLinkModel obj) {
                    SmokeDetector.this.setModel(obj);
                }
            };
        }
        return super.taskReplaceDep(old, replacement);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return super.taskUpdateDep(dep, changes);
    }

    @Override
    protected IPrimProps getPrimProps() {
        return s_primProps;
    }

    @Override
    public IDevice getRestoreObject() {
        return IImprintable.imprintOn(new SmokeDetector(this.getName(), null), this);
    }

    @Override
    public void imprint(IDevice refObject) {
        this.pauseUpdates();
        super.imprint(refObject);
        SmokeDetector sDev = (SmokeDetector)refObject;
        this.setModel(sDev.getModel());
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }
}

