/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.detectors;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.jscience.physics.units.SI;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.IImprintable;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.devices.IDeviceModel;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class HeatLinkModel
extends NamedPyroObject
implements IDeviceModel,
IImprintable<HeatLinkModel> {
    static final long serialVersionUID = 1L;
    private String d_fyi;
    private UnitDouble d_rti;
    private UnitDouble d_activationTemp;
    private UnitDouble d_initTemp;
    private CustomFDSProps d_customProps;

    public HeatLinkModel(String name) {
        this(name, new UnitDouble(100.0, SIUS.getInstance().getRtiUnit()), null, new UnitDouble(74.0, SI.CELSIUS));
    }

    public HeatLinkModel(String name, UnitDouble rti, UnitDouble activationTemp) {
        this(name, rti, null, activationTemp);
    }

    public HeatLinkModel(String name, UnitDouble rti, UnitDouble initTemp, UnitDouble activationTemp) {
        super(name);
        this.d_rti = rti;
        this.d_activationTemp = activationTemp;
        this.d_initTemp = initTemp;
        this.d_customProps = CustomFDSProps.EMPTY;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_customProps == null) {
            this.d_customProps = CustomFDSProps.EMPTY;
        }
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String recType) {
        return this.d_customProps;
    }

    @Override
    public void setCustomFDSProps(String recType, CustomFDSProps props) {
        this.d_customProps = props;
        this.changedEvt(new Object[0]);
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return super.equals(obj) && this.propEquals(obj);
    }

    public boolean propEquals(Object obj) {
        if (!(obj instanceof HeatLinkModel)) {
            return false;
        }
        HeatLinkModel mod = (HeatLinkModel)obj;
        return this.d_rti.equals(mod.d_rti) && this.d_activationTemp.equals(mod.d_activationTemp) && theUtil.equal(this.d_initTemp, mod.d_initTemp) && this.d_customProps.equals(mod.d_customProps);
    }

    public int propHash() {
        return this.d_rti.hashCode() + this.d_activationTemp.hashCode() + theUtil.hashCode(this.d_initTemp) + this.d_customProps.hashCode();
    }

    public UnitDouble getRti() {
        return this.d_rti;
    }

    public void setRti(UnitDouble rti) {
        this.d_rti = rti;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getInitialTemp() {
        return this.d_initTemp;
    }

    public void setInitialTemp(UnitDouble initTemp) {
        this.d_initTemp = initTemp;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getActivationTemp() {
        return this.d_activationTemp;
    }

    public void setActivationTemp(UnitDouble actTemp) {
        this.d_activationTemp = actTemp;
        this.changedEvt(new Object[0]);
    }

    @Override
    public HeatLinkModel getRestoreObject() {
        return IImprintable.imprintOn(new HeatLinkModel(this.getName()), this);
    }

    @Override
    public void imprint(HeatLinkModel refObject) {
        this.pauseUpdates();
        this.setName(refObject.getName());
        this.setFYI(refObject.getFYI());
        this.setRti(refObject.getRti());
        this.setActivationTemp(refObject.getActivationTemp());
        this.setInitialTemp(refObject.getInitialTemp());
        this.setCustomFDSProps(refObject.getCustomFDSProps());
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }
}

