/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.detectors;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import pyrosim.Intl;
import pyrosim.domain.devices.APointSrcDevc;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.detectors.IDetector;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.signals.DoubleOutPin;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.ILatchable;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.io.PyroSimObjectInputStream;

public abstract class APointDetector
extends APointSrcDevc
implements IDetector,
Serializable,
ILatchable {
    static final long serialVersionUID = 1L;
    private LogicOutPin d_alarmPin = new LogicOutPin(this, Intl.intl("ALARM"));
    private int d_tripFlags = 1;
    private IDoubleOutPin d_quantPin = this.createQuantPin();
    private OneLogicInPin d_freezePin = this.createFreezePin();

    protected abstract IQuantity getQuantity();

    public APointDetector(String name, FreePointLoc loc) {
        super(name, loc);
    }

    protected IDoubleOutPin createQuantPin() {
        return new DoubleOutPin(this, Intl.intl("QUANTITY"), this.getQuantity().get().unitType);
    }

    protected OneLogicInPin createFreezePin() {
        return new OneLogicInPin(this);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (stream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)stream).getVersion() < 29) {
            this.d_tripFlags = 0;
        }
        if (this.d_quantPin == null) {
            this.d_quantPin = this.createQuantPin();
        }
        if (this.d_freezePin == null) {
            this.d_freezePin = this.createFreezePin();
        }
    }

    @Override
    public Object clone() {
        APointDetector clone = (APointDetector)super.clone();
        clone.d_alarmPin = this.d_alarmPin.clone(clone);
        clone.d_quantPin = (IDoubleOutPin)this.d_quantPin.clone(clone);
        clone.d_freezePin = (OneLogicInPin)this.d_freezePin.clone(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof APointDetector && super.equals(obj) && ((APointDetector)obj).d_tripFlags == this.d_tripFlags && ((APointDetector)obj).d_freezePin.equals(this.d_freezePin);
    }

    @Override
    public boolean latches(ILogicOutPin pin) {
        return TripFlags.latch(this.d_tripFlags);
    }

    @Override
    public ILogicOutPin getAlarmPin() {
        return this.d_alarmPin;
    }

    @Override
    public IDoubleOutPin getQuantityPin() {
        return this.d_quantPin;
    }

    @Override
    public OneLogicInPin getFreezePin() {
        return this.d_freezePin;
    }

    @Override
    public void setTripFlags(int tf) {
        this.d_tripFlags = tf;
        this.changedEvt(new Object[0]);
    }

    @Override
    public int getTripFlags() {
        return this.d_tripFlags;
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        recTypes.add("DEVC");
    }

    @Override
    public void imprint(IDevice refObject) {
        this.pauseUpdates();
        super.imprint(refObject);
        APointDetector pDev = (APointDetector)refObject;
        this.setTripFlags(pDev.getTripFlags());
        this.d_alarmPin = (LogicOutPin)pDev.getAlarmPin().clone(this);
        this.d_quantPin = (IDoubleOutPin)pDev.getQuantityPin().clone(this);
        this.d_freezePin = (OneLogicInPin)pDev.getFreezePin().clone(this);
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }
}

