/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.aspiration;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.Intl;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IImprintable;
import pyrosim.domain.devices.APointSrcDevc;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.measurers.IMeasurer;
import pyrosim.domain.devices.measurers.MeasureOutInfo;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.signals.DoubleOutPin;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.ILatchable;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.signals.SignalsUtil;
import pyrosim.io.PyroSimObjectInputStream;
import thunderheadeng.scene3d.geom.IPrimProps;

public class AspiratorSampler
extends APointSrcDevc
implements IMeasurer,
ILatchable {
    static final long serialVersionUID = 1L;
    private Object d_outPin = this.createOutInfo(new DoubleOutPin((ISignalSource)this, 40));
    private OneLogicInPin d_freezePin = new OneLogicInPin(this);
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(Color.LIGHT_GRAY, 10.0);

    public AspiratorSampler(String name, FreePointLoc loc) {
        super(name, loc);
    }

    @Override
    public boolean latches(ILogicOutPin pin) {
        return this.getMsrInfo().latches();
    }

    private MeasureOutInfo createOutInfo(IDoubleOutPin outPin) {
        return new MeasureOutInfo(this, true, outPin, Intl.intl("ALARM"));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (stream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)stream).getVersion() < 29) {
            assert (this.d_outPin instanceof IDoubleOutPin);
            this.d_outPin = this.createOutInfo((IDoubleOutPin)this.d_outPin);
        }
        if (this.d_freezePin == null) {
            this.d_freezePin = new OneLogicInPin(this);
        }
    }

    @Override
    public Object clone() {
        AspiratorSampler clone = (AspiratorSampler)super.clone();
        clone.d_outPin = ((MeasureOutInfo)this.d_outPin).clone(clone);
        clone.d_freezePin = (OneLogicInPin)this.d_freezePin.clone(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof AspiratorSampler && super.equals(obj) && this.d_outPin.equals(((AspiratorSampler)obj).d_outPin) && this.d_freezePin.equals(((AspiratorSampler)obj).d_freezePin);
    }

    @Override
    public OneLogicInPin getFreezePin() {
        return this.d_freezePin;
    }

    @Override
    public int getNumMeasurements() {
        return 1;
    }

    public IQuantity getQuantity() {
        return Quantity.SPEC_DENSITY.create(ExSpecList.getPredefinedSpecies("SOOT"));
    }

    @Override
    public IQuantity getQuantity(int ix) {
        return this.getQuantity();
    }

    public MeasureOutInfo getMsrInfo() {
        return (MeasureOutInfo)this.d_outPin;
    }

    @Override
    public MeasureOutInfo getMsrInfo(int ix) {
        return this.getMsrInfo();
    }

    @Override
    protected IPrimProps getPrimProps() {
        return s_primProps;
    }

    @Override
    public IDevice getRestoreObject() {
        return IImprintable.imprintOn(new AspiratorSampler(this.getName(), null), this);
    }

    @Override
    public void imprint(IDevice refObject) {
        this.pauseUpdates();
        super.imprint(refObject);
        AspiratorSampler asDev = (AspiratorSampler)refObject;
        this.getMsrInfo().restoreFrom(asDev.getMsrInfo());
        SignalsUtil.restoreInPin(this, this.getFreezePin(), asDev.getFreezePin());
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }
}

