/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import pyrosim.PyroMod;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.LogicOutPin;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class AlarmInfo
implements Serializable {
    static final long serialVersionUID = 1L;
    public final UnitDouble setpoint;
    public final int tripFlags;

    public AlarmInfo(UnitDouble setpoint) {
        this(setpoint, 1);
    }

    public AlarmInfo(UnitDouble setpoint, int tripFlags) {
        this.setpoint = setpoint;
        this.tripFlags = tripFlags;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AlarmInfo)) {
            return false;
        }
        AlarmInfo ai = (AlarmInfo)obj;
        return this.setpoint.equals(ai.setpoint) && this.tripFlags == ai.tripFlags;
    }

    public int hashCode() {
        return 10462195 + this.tripFlags + this.setpoint.hashCode();
    }

    public static boolean checkAlarmChange(ISignalSource src, AlarmInfo oldai, AlarmInfo newai, LogicOutPin alarmPin) {
        return AlarmInfo.checkAlarmChange(src, oldai, newai, List.of(alarmPin));
    }

    public static boolean checkAlarmChange(ISignalSource src, AlarmInfo oldai, AlarmInfo newai, Collection<? extends LogicOutPin> alarmPins) {
        if (theUtil.equal(oldai, newai)) {
            return false;
        }
        PyroMod domain = (PyroMod)src.getDomain();
        if (newai == null && domain != null) {
            DepSnapshot dss = domain.getDependencies(src);
            Set<Dependency> deps = dss.getDependents(src);
            for (Dependency dep : deps) {
                IDirectDependent iDirectDependent = dep.source;
                if (!(iDirectDependent instanceof IInPin)) continue;
                IInPin inPin = (IInPin)iDirectDependent;
                alarmPins.stream().forEach(alarmPin -> inPin.disconnect((IOutPin)alarmPin));
            }
        }
        return true;
    }
}

