/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices;

import pyrosim.domain.devices.ASourceDevice;
import pyrosim.domain.devices.FreePointGeom;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreePointDevice;
import pyrosim.domain.geom.FreePointLoc;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;

public abstract class APointSrcDevc
extends ASourceDevice
implements IFreePointDevice {
    static final long serialVersionUID = 1L;
    private FreePointLoc d_location;

    public APointSrcDevc(String name, FreePointLoc loc) {
        super(name);
        this.d_location = loc;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof APointSrcDevc && super.equals(obj) && this.d_location.equals(((APointSrcDevc)obj).d_location);
    }

    @Override
    public FreePointLoc getLocation() {
        return this.d_location;
    }

    @Override
    public void setLocation(FreePointLoc loc) {
        this.d_location = loc;
        this.changedEvt(new Object[0]);
    }

    protected abstract IPrimProps getPrimProps();

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), this.getPrimProps());
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getPointGeom());
    }

    public IGeom getPointGeom() {
        return new FreePointGeom(this.d_location);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof FreePointGeom) {
            FreePointGeom p = (FreePointGeom)geom;
            this.setLocation(p.loc);
        } else if (geom instanceof Point || geom instanceof LineSeg || geom instanceof BlockGeom) {
            this.setLocation(this.d_location.setGeom(geom));
        }
    }

    @Override
    public void imprint(IDevice refObject) {
        this.pauseUpdates();
        super.imprint(refObject);
        APointSrcDevc psDev = (APointSrcDevc)refObject;
        this.setLocation(psDev.getLocation());
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }
}

