/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import pyrosim.PyroMod;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tags.Tag;
import pyrosim.util.Util;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public abstract class ADevice
extends NamedPyroObject
implements IDevice {
    static final long serialVersionUID = 1L;
    private boolean d_visible = true;
    private final Map<String, CustomFDSProps> d_customProps = new ListMap<String, CustomFDSProps>();
    private Set<Tag> d_tags = Collections.emptySet();

    public ADevice(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_customProps == null) {
            try {
                theUtil.assignFinalField(this, ADevice.class, "d_customProps", new ListMap());
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
        }
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!super.equals(obj)) return false;
        if (!(obj instanceof ADevice)) return false;
        ADevice objAsDevc = (ADevice)obj;
        if (!objAsDevc.d_customProps.equals(this.d_customProps)) return false;
        if (!Util.identitySetsEqual(this.getTags(), objAsDevc.getTags())) return false;
        return true;
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String recType) {
        return this.d_customProps.getOrDefault(recType, CustomFDSProps.EMPTY);
    }

    @Override
    public void setCustomFDSProps(String recType, CustomFDSProps props) {
        boolean modified = false;
        modified = props == CustomFDSProps.EMPTY ? (modified |= this.d_customProps.remove(recType) != null) : (modified |= this.d_customProps.put(recType, props) != props);
        if (modified) {
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public Set<Tag> getTags() {
        return this.d_tags;
    }

    @Override
    public void setTags(Set<Tag> tags) {
        this.d_tags = tags;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Icon[] getIcons() {
        return new Icon[]{null, null};
    }

    public TexOrigin getTextureOrigin() {
        return TexOrigin.DEF_WORLD;
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.d_visible = visible;
        this.changedEvt(PyroMod.EVT_VISIBILITY_CHANGED);
    }

    @Override
    public Object clone() {
        ADevice device = (ADevice)super.clone();
        try {
            ListMap newProps = new ListMap();
            this.d_customProps.forEach((key, val) -> newProps.put(key, val));
            theUtil.assignFinalField(device, ADevice.class, "d_customProps", newProps);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return device;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        ITaggable.addTagsToDepSnapshot(this, deps);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        ITaggable.removeInvalidTagReplacements(old, objs);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        return ITaggable.taskReplaceTagDep(old, replacement, this);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    @Override
    public void imprint(IDevice refObject) {
        this.pauseUpdates();
        ADevice device = (ADevice)refObject;
        this.setName(device.getName());
        this.setVisible(device.d_visible);
        this.setTags(device.getTags());
        this.d_customProps.clear();
        for (String key : device.d_customProps.keySet()) {
            this.setCustomFDSProps(key, device.getCustomFDSProps(key));
        }
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }
}

