/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.controls;

import java.util.Arrays;
import java.util.List;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.signals.AOneDoubleInPin;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.LogicOutPin;
import thunderheadeng.units.UnitDouble;

public class DeadbandCtrl
extends AControl {
    static final long serialVersionUID = 1L;
    public static final int TRIP_LOWER = 0;
    public static final int TRIP_UPPER = 1;
    private IInPin d_inPin;
    private IOutPin d_outPin;
    private int d_tripDir;
    private UnitDouble d_lowerBound;
    private UnitDouble d_upperBound;

    public DeadbandCtrl() {
        this(0, null, null);
    }

    public DeadbandCtrl(int tripDir, UnitDouble lowerBound, UnitDouble upperBound) {
        this.d_tripDir = tripDir;
        this.d_lowerBound = lowerBound;
        this.d_upperBound = upperBound;
        this.d_inPin = new AOneDoubleInPin(this){
            static final long serialVersionUID = -8988340789408151109L;

            @Override
            public void updateInputUnit(Unit newUnit) {
                DeadbandCtrl.this.d_lowerBound = DeadbandCtrl.this.d_lowerBound.reinterpret(newUnit);
                DeadbandCtrl.this.d_upperBound = DeadbandCtrl.this.d_upperBound.reinterpret(newUnit);
                DeadbandCtrl.this.changedEvt(new Object[0]);
            }

            @Override
            protected void changeInputUnit(Unit unit) {
                DeadbandCtrl.this.d_lowerBound = new UnitDouble(DeadbandCtrl.this.d_lowerBound.getValueNoUnit(), unit);
                DeadbandCtrl.this.d_upperBound = new UnitDouble(DeadbandCtrl.this.d_upperBound.getValueNoUnit(), unit);
                DeadbandCtrl.this.changedEvt(new Object[0]);
            }
        };
        this.d_outPin = new LogicOutPin(this);
    }

    @Override
    protected String getDefaultName() {
        return Intl.intl("deadband");
    }

    @Override
    public Object clone() {
        DeadbandCtrl clone = (DeadbandCtrl)super.clone();
        clone.d_inPin = (IInPin)this.d_inPin.clone(clone);
        clone.d_outPin = (IOutPin)this.d_outPin.clone(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DeadbandCtrl)) {
            return false;
        }
        DeadbandCtrl ctrl = (DeadbandCtrl)obj;
        return super.equals(obj) && this.d_tripDir == ctrl.d_tripDir && this.d_lowerBound.equals(ctrl.d_lowerBound) && this.d_upperBound.equals(ctrl.d_upperBound) && this.d_inPin.equals(ctrl.d_inPin);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 215774 + this.d_inPin.hashCode() + this.d_tripDir + this.d_lowerBound.hashCode() + this.d_upperBound.hashCode();
    }

    @Override
    public boolean isEquiv(Object obj) {
        return this.equals(obj);
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_outPin);
    }

    @Override
    public boolean isWire() {
        return false;
    }

    public int getTripDirection() {
        return this.d_tripDir;
    }

    public UnitDouble getLowerBound() {
        return this.d_lowerBound;
    }

    public UnitDouble getUpperBound() {
        return this.d_upperBound;
    }
}

