/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.variant.ConstProfile;
import pyrosim.domain.variant.DefRampProfile;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.variant.VariantProfile;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class SurfComposition
implements Serializable {
    static final long serialVersionUID = 1L;
    public final Variant d_innerTempVariant;
    public final List<SurfLayer> d_layers;
    public final Backing d_backing;
    public final Double d_layerDivide;
    @Deprecated
    public final UnitDouble d_initInnerTemp;
    @Deprecated
    public final TimeFunction d_tempRamp;
    public static final VariantProfile TEMP_RAMP_INTERNAL = new VariantProfile(new ConstProfile(Intl.intl("Constant"), 1, new UnitDouble(20.0, SI.CELSIUS)), new DefRampProfile(Intl.intl("Custom"), 1, DefRampProfile.Input.DEPTH));

    public SurfComposition() {
        this(TEMP_RAMP_INTERNAL.getDefault(), Backing.newDefault(), null, new ArrayList<SurfLayer>(0));
    }

    public SurfComposition(Variant innerTempVariant, Backing backing, Double layerDivide, List<SurfLayer> layers) {
        this.d_innerTempVariant = innerTempVariant;
        this.d_backing = backing;
        this.d_layerDivide = layerDivide;
        this.d_layers = Collections.unmodifiableList(layers);
        assert (this.d_layerDivide == null || this.d_layerDivide <= (double)this.d_layers.size() && this.d_layerDivide >= 0.0);
        this.d_initInnerTemp = null;
        this.d_tempRamp = null;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + theUtil.hashCode(this.d_backing);
        hash = 31 * hash + theUtil.hashCode(this.d_layerDivide);
        hash = 31 * hash + theUtil.hashCode(this.d_innerTempVariant);
        hash = 31 * hash + theUtil.hashCode(this.d_layers);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SurfComposition)) {
            return false;
        }
        SurfComposition comp = (SurfComposition)obj;
        return this.d_backing.equals(comp.d_backing) && theUtil.equal(this.d_layerDivide, comp.d_layerDivide) && this.d_innerTempVariant.equals(comp.d_innerTempVariant) && this.d_layers.equals(comp.d_layers);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_innerTempVariant == null) {
            try {
                Util.assignFinalField(this, "d_innerTempVariant", TEMP_RAMP_INTERNAL.getDefault());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public static class SurfLayer
    implements IDirectDependent,
    Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_thickness;
        private final Map<Material, SurfComponent> d_components;

        public SurfLayer(UnitDouble thickness, Collection<SurfComponent> comps) {
            this.d_thickness = thickness;
            this.d_components = new LinkedIdentityHashMap<Material, SurfComponent>();
            for (SurfComponent comp : comps) {
                this.d_components.put(comp.d_material, comp);
            }
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + theUtil.hashCode(this.d_thickness);
            hash = 31 * hash + theUtil.hashCode(this.d_components);
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SurfLayer)) {
                return false;
            }
            SurfLayer layer = (SurfLayer)obj;
            return theUtil.equal(this.d_thickness, layer.d_thickness) && Util.identityMapsEqual(this.d_components, layer.d_components);
        }

        public Collection<SurfComponent> getComponents() {
            return this.d_components.values();
        }

        @Override
        public void takeDepSnapshot(DepList deps) {
            deps.add(DLink.REQUIRED, this.d_components.keySet());
        }

        @Override
        public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
            Util.keepIfNullOr(objs, Material.class);
        }

        @Override
        public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
            if (!this.d_components.containsKey(old)) {
                return null;
            }
            return new AUndoableTask(){
                private Map<Material, SurfComponent> d_oldComp;

                @Override
                public void undo() {
                    d_components.clear();
                    d_components.putAll(this.d_oldComp);
                    this.d_oldComp = null;
                }

                @Override
                public void run() {
                    this.d_oldComp = new LinkedIdentityHashMap<Material, SurfComponent>(d_components);
                    SurfComponent oldComp = d_components.remove(old);
                    SurfComponent existingComp = d_components.get(replacement);
                    if (existingComp == null) {
                        SurfComponent newComp = new SurfComponent(oldComp.d_massFraction, (Material)replacement);
                        d_components.put((Material)replacement, newComp);
                    } else {
                        SurfComponent combinedComp = new SurfComponent(oldComp.d_massFraction + existingComp.d_massFraction, (Material)replacement);
                        d_components.put((Material)replacement, combinedComp);
                    }
                }
            };
        }

        @Override
        public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
            return EmptyTask.INSTANCE;
        }

        public static class SurfComponent
        implements Serializable {
            static final long serialVersionUID = 1L;
            public final double d_massFraction;
            public final Material d_material;

            public SurfComponent(double massFraction, Material mat) {
                this.d_massFraction = massFraction;
                this.d_material = mat;
            }

            public int hashCode() {
                int hash = 7;
                hash = 31 * hash + theUtil.hashCode(this.d_massFraction);
                hash = 31 * hash + theUtil.hashCode(this.d_material);
                return hash;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof SurfComponent)) {
                    return false;
                }
                SurfComponent comp = (SurfComponent)obj;
                return this.d_massFraction == comp.d_massFraction && this.d_material.equals(comp.d_material);
            }
        }
    }
}

