/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.surf.AOutFlowSurfDesc;
import pyrosim.domain.boundcond.surf.HeatRelease;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.domain.variant.Variant;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;

public class BurnerSurfDesc
extends AOutFlowSurfDesc {
    static final long serialVersionUID = 1L;
    public TempRegulation d_temperature;
    public final HeatRelease d_heatRelease;
    public final SpecInjList d_fuelComps;

    public BurnerSurfDesc() {
        this(new HeatRelease(), null, new SpecInjList(), TempRegulation.newFixedTempTR(SIUS.newud(300.0, 1), TimeFunction.newDefault(), TempRegulation.getDefaultEmissivity(), Variant.def(), TempRegulation.getDefaultLog()), IGeometry.DEFAULT);
    }

    public BurnerSurfDesc(HeatRelease hr, ParticleInjection partInj, SpecInjList fuelComps, TempRegulation tr, IGeometry geom) {
        super(partInj, geom);
        this.d_fuelComps = fuelComps;
        this.d_temperature = TempRegulation.newDefault();
        this.d_heatRelease = hr;
        this.d_temperature = tr;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_temperature == null) {
            this.d_temperature = TempRegulation.newDefault();
        }
        if (this.d_geometry == null) {
            try {
                Util.assignFinalField(this, "d_geometry", IGeometry.DEFAULT);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (this.d_fuelComps == null) {
            try {
                Util.assignFinalField(this, "d_fuelComps", new SpecInjList());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BurnerSurfDesc)) {
            return false;
        }
        BurnerSurfDesc sd = (BurnerSurfDesc)obj;
        return super.equals(obj) && this.d_temperature.equals(sd.d_temperature) && this.d_heatRelease.equals(sd.d_heatRelease);
    }

    public void setVestigialTempRegData(TempRegulation tempReg) {
        this.d_temperature = tempReg;
    }

    public TempRegulation getVestigialTempRegData() {
        return this.d_temperature;
    }
}

