/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.auditing;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.auditing.ICheckDesc;
import pyrosim.domain.auditing.ModelCheck;
import pyrosim.domain.auditing.ModelWarning;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.HeatRelease;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.rasterization.FDSObjectRasterization;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class SurfaceCheckDesc
implements ICheckDesc {
    private static final long serialVersionUID = 1L;
    private Type d_type = Type.HRR;
    public boolean d_maxHrr = true;
    public boolean d_maxVol = true;
    public boolean d_maxVel = true;

    public SurfaceCheckDesc() {
    }

    public SurfaceCheckDesc(Type type) {
        this.d_type = type;
    }

    @Override
    public Collection<ModelWarning> getModelWarnings(PyroMod pyroMod, ModelCheck check) {
        ArrayList<ModelWarning> warnings = new ArrayList<ModelWarning>();
        IFilteredCollection<IPyroObject> surfObjs = theUtil.filter(pyroMod.getObstructions().getDeepMembers(), o -> o instanceof ISurfObj && o.isEnabled());
        HashMap<Surface, UnitDouble> surfHRRMap = new HashMap<Surface, UnitDouble>();
        HashMap<Surface, UnitDouble> surfSupplyVolMap = new HashMap<Surface, UnitDouble>();
        HashMap<Surface, UnitDouble> surfExhaustVolMap = new HashMap<Surface, UnitDouble>();
        HashMap<Surface, UnitDouble> surfSupplyVelMap = new HashMap<Surface, UnitDouble>();
        HashMap<Surface, UnitDouble> surfExhaustVelMap = new HashMap<Surface, UnitDouble>();
        for (IPyroObject pyroObject : surfObjs) {
            boolean isGeom;
            ISurfObj surfObj = (ISurfObj)pyroObject;
            FDSRasterization rasterization = pyroMod.getRasterizations();
            FDSObjectRasterization surfRaster = rasterization.rasterize((FDSObject)surfObj);
            boolean noRaster = surfRaster == null || surfRaster.geoms.length == 0;
            boolean bl = isGeom = surfObj instanceof IObstruction && ((IObstruction)surfObj).getOptions(128);
            if (noRaster || isGeom) {
                List prims = GeomUtil.explode(surfObj.getGeom().getLocalGeom(), IFace.class);
                Surface[] surfaces = surfObj.getSurfaces();
                assert (surfaces.length == prims.size() || surfaces.length == 1);
                for (int i = 0; i < prims.size(); ++i) {
                    Surface surface = surfaces.length == 1 ? surfaces[0] : surfaces[i];
                    this.updateSurfMaps((IFace)prims.get(i), surface, surfHRRMap, surfSupplyVolMap, surfExhaustVolMap, surfSupplyVelMap, surfExhaustVelMap);
                }
                continue;
            }
            for (Pair<IGeom, FaceProps[]> rasterPair : surfRaster.geoms) {
                List prims = GeomUtil.explode((IGeom)rasterPair.v1, IFace.class);
                FaceProps[] rasterProps = (FaceProps[])rasterPair.v2;
                assert (rasterProps.length == 1 || rasterProps.length == prims.size());
                for (int i = 0; i < prims.size(); ++i) {
                    FaceProps rp = rasterProps.length == 1 ? rasterProps[0] : rasterProps[i];
                    this.updateSurfMaps((IFace)prims.get(i), rp.surface, surfHRRMap, surfSupplyVolMap, surfExhaustVolMap, surfSupplyVelMap, surfExhaustVelMap);
                }
            }
        }
        if (this.d_maxHrr) {
            this.addWarnings(warnings, Intl.intl("Max HRR"), surfHRRMap, check.getName());
        }
        if (this.d_maxVol) {
            this.addWarnings(warnings, Intl.intl("Max Supply Volume"), surfSupplyVolMap, check.getName());
            this.addWarnings(warnings, Intl.intl("Max Exhaust Volume"), surfExhaustVolMap, check.getName());
        }
        if (this.d_maxVel) {
            this.addWarnings(warnings, Intl.intl("Max Supply Velocity"), surfSupplyVelMap, check.getName());
            this.addWarnings(warnings, Intl.intl("Max Exhaust Velocity"), surfExhaustVelMap, check.getName());
        }
        return warnings;
    }

    private void addWarnings(Collection<ModelWarning> warnings, String description, Map<Surface, UnitDouble> map, String checkName) {
        for (Map.Entry<Surface, UnitDouble> entry : map.entrySet()) {
            warnings.add(new ModelWarning(checkName, description, entry.getValue().format(new DecimalFormat("0.000")), entry.getKey()));
        }
    }

    private void updateSurfMaps(IFace primitive, Surface surface, Map<Surface, UnitDouble> surfaceHRRMap, Map<Surface, UnitDouble> surfaceSupplyVolMap, Map<Surface, UnitDouble> surfaceExhaustVolMap, Map<Surface, UnitDouble> surfaceSupplyVelMap, Map<Surface, UnitDouble> surfaceExhaustVelMap) {
        Unit hrrUnit = UnitSystem.getSource(22).getUnit().multiply(UnitSystem.getSource(79).getUnit());
        Unit flowVelUnit = UnitSystem.getSource(8).getUnit();
        Unit flowVolUnit = UnitSystem.getSource(56).getUnit().divide(SI.SECOND);
        if (surface.getSurfDesc() instanceof BurnerSurfDesc && this.d_type.equals((Object)Type.HRR) && this.d_maxHrr) {
            BurnerSurfDesc burnerSurfDesc = (BurnerSurfDesc)surface.getSurfDesc();
            if (burnerSurfDesc.d_heatRelease.d_type instanceof HeatRelease.HRRType) {
                UnitDouble rate = this.getMaxRate((UnitDouble)burnerSurfDesc.d_heatRelease.d_type.val, burnerSurfDesc.d_heatRelease.d_type.func);
                UnitDouble val = rate.multiply(this.getArea(primitive));
                surfaceHRRMap.computeIfAbsent(surface, s -> new UnitDouble(0.0, hrrUnit));
                surfaceHRRMap.put(surface, surfaceHRRMap.get(surface).add(val));
            }
        } else if (surface.getSurfDesc() instanceof BlowerSurfDesc && this.d_type.equals((Object)Type.SUPPLY)) {
            BlowerSurfDesc surfDesc = (BlowerSurfDesc)surface.getSurfDesc();
            if (surfDesc.d_airFlow.d_rate instanceof AirFlow.VolumeFlux) {
                AirFlow.VolumeFlux volFlux = (AirFlow.VolumeFlux)surfDesc.d_airFlow.d_rate;
                if (this.d_maxVel) {
                    this.mapPrimaryFlow(primitive, surface, volFlux, surfaceSupplyVelMap, flowVelUnit, false);
                }
                if (this.d_maxVol) {
                    this.mapSecondaryFlow(surface, volFlux, surfaceSupplyVolMap, flowVolUnit, true);
                }
            } else if (surfDesc.d_airFlow.d_rate instanceof AirFlow.NormalVel) {
                AirFlow.NormalVel normalVel = (AirFlow.NormalVel)surfDesc.d_airFlow.d_rate;
                if (this.d_maxVol) {
                    this.mapPrimaryFlow(primitive, surface, normalVel, surfaceSupplyVolMap, flowVolUnit, true);
                }
                if (this.d_maxVel) {
                    this.mapSecondaryFlow(surface, normalVel, surfaceSupplyVelMap, flowVelUnit, false);
                }
            }
        } else if (surface.getSurfDesc() instanceof InFlowSurfDesc && this.d_type.equals((Object)Type.EXHAUST)) {
            InFlowSurfDesc surfDesc = (InFlowSurfDesc)surface.getSurfDesc();
            if (surfDesc.d_airFlow.d_rate instanceof AirFlow.VolumeFlux) {
                AirFlow.VolumeFlux volFlux = (AirFlow.VolumeFlux)surfDesc.d_airFlow.d_rate;
                if (this.d_maxVel) {
                    this.mapPrimaryFlow(primitive, surface, volFlux, surfaceExhaustVelMap, flowVelUnit, false);
                }
                if (this.d_maxVol) {
                    this.mapSecondaryFlow(surface, volFlux, surfaceExhaustVolMap, flowVolUnit, true);
                }
            } else if (surfDesc.d_airFlow.d_rate instanceof AirFlow.NormalVel) {
                AirFlow.NormalVel normalVel = (AirFlow.NormalVel)surfDesc.d_airFlow.d_rate;
                if (this.d_maxVol) {
                    this.mapPrimaryFlow(primitive, surface, normalVel, surfaceExhaustVolMap, flowVolUnit, true);
                }
                if (this.d_maxVel) {
                    this.mapSecondaryFlow(surface, normalVel, surfaceExhaustVelMap, flowVelUnit, false);
                }
            }
        }
    }

    private void mapPrimaryFlow(IFace primitive, Surface surface, AirFlow.ValRate flow, Map<Surface, UnitDouble> surfaceMap, Unit unit, boolean isVol) {
        UnitDouble rate = this.getMaxRate(flow.val, flow.func);
        UnitDouble val = isVol ? rate.multiply(this.getArea(primitive)) : rate.divide(this.getArea(primitive));
        surfaceMap.computeIfAbsent(surface, s -> new UnitDouble(0.0, unit));
        val = isVol ? surfaceMap.get(surface).add(val) : val;
        surfaceMap.put(surface, UnitDouble.max(surfaceMap.get(surface), val));
    }

    private void mapSecondaryFlow(Surface surface, AirFlow.ValRate flow, Map<Surface, UnitDouble> surfaceMap, Unit unit, boolean isVol) {
        UnitDouble rate = this.getMaxRate(flow.val, flow.func);
        surfaceMap.computeIfAbsent(surface, s -> new UnitDouble(0.0, unit));
        UnitDouble newRate = isVol ? surfaceMap.get(surface).add(rate) : rate;
        surfaceMap.put(surface, newRate);
    }

    @Override
    public SurfaceCheckDesc clone() {
        SurfaceCheckDesc clone = new SurfaceCheckDesc(this.d_type);
        clone.setOptions(this.d_maxHrr, this.d_maxVol, this.d_maxVel);
        return clone;
    }

    private UnitDouble getArea(IFace prim) {
        Unit areaUnit = UnitSystem.getSource(79).getUnit();
        if (prim instanceof IPolygon) {
            IPolygon polyFace = (IPolygon)prim;
            return new UnitDouble(polyFace.getArea(), areaUnit);
        }
        Mesh mesh = prim.triangulate(0.1);
        int j = 0;
        if (j < mesh.indices.length) {
            ArrayList<Point3d> vertices = new ArrayList<Point3d>();
            vertices.add(mesh.vertices[mesh.indices[j++]]);
            vertices.add(mesh.vertices[mesh.indices[j++]]);
            vertices.add(mesh.vertices[mesh.indices[j++]]);
            return new UnitDouble(Util3D.simplePolygonArea(vertices), areaUnit);
        }
        return new UnitDouble(0.0, areaUnit);
    }

    private UnitDouble getMaxRate(UnitDouble rate, TimeFunction func) {
        UnitDouble max = new UnitDouble(1.0, Unit.ONE);
        if (func instanceof TimeFunction.Custom) {
            TimeFunction.Custom customFunc = (TimeFunction.Custom)func;
            for (Ramp.Entry entry : ((Ramp)customFunc.val).getRecords()) {
                max = UnitDouble.max(max, entry.f);
            }
        }
        return rate.multiply(max);
    }

    public void setType(Type type) {
        this.d_type = type;
    }

    public void setOptions(boolean maxHrr, boolean maxVol, boolean maxVel) {
        this.d_maxHrr = maxHrr;
        this.d_maxVol = maxVol;
        this.d_maxVel = maxVel;
    }

    public Type getType() {
        return this.d_type;
    }

    public static enum Type {
        HRR,
        SUPPLY,
        EXHAUST;

    }
}

