/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.appearance;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.NamedPyroObject;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.scene3d.geom.IAdvancedMaterial;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.MatUtil;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;

public class Material
extends NamedPyroObject
implements IAdvancedMaterial {
    private static final long serialVersionUID = 1L;
    private static final TypedProp<Integer> PROP_VERSION = TypedProps.newProp((Object)"version", 0, new Object[0]);
    private static final TypedProp<String> PROP_MAT_NAME = TypedProps.newProp((Object)"name", String.class, new Object[0]);
    private static final TypedProp<UnitDouble> PROP_WIDTH = TypedProps.newProp((Object)"width", UnitDouble.class, new UnitDouble(1.0, SI.METER), new Object[0]);
    private static final TypedProp<UnitDouble> PROP_HEIGHT = TypedProps.newProp((Object)"height", UnitDouble.class, new UnitDouble(1.0, SI.METER), new Object[0]);
    @Deprecated
    private static final TypedProp<String> PROP_UNITS = TypedProps.newProp((Object)"length_unit", SI.METER.toString(), new Object[0]);
    private UnitDouble d_width;
    private UnitDouble d_height;
    private IMatAttrs d_material;

    public Material(String name, IMatAttrs mat) {
        this(name, mat, (UnitDouble)Material.PROP_WIDTH.defVal, (UnitDouble)Material.PROP_HEIGHT.defVal);
    }

    public Material(String name, IMatAttrs mat, UnitDouble width, UnitDouble height) {
        super(name);
        this.d_material = mat;
        this.d_width = width;
        this.d_height = height;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public Material clone() {
        Material clone = (Material)super.clone();
        return clone;
    }

    public boolean pseudoEquals(Material mat) {
        return mat == this || mat != null && this.getName().equals(mat.getName()) && this.d_width.epsilonEquals(mat.d_width, 1.0E-12) && this.d_height.epsilonEquals(mat.d_height, 1.0E-12) && MatUtil.makeImagesHashable(this.d_material).equals(mat.d_material);
    }

    public int pseudoHashCode() {
        return this.getName().hashCode() + this.d_width.hashCode() + this.d_height.hashCode() + MatUtil.makeImagesHashable(this.d_material).hashCode();
    }

    public List<IImage> getImages() {
        ArrayList<IImage> images = new ArrayList<IImage>();
        for (MatChannel chnl : MatChannel.values()) {
            Texture tex = this.d_material.getTexture(chnl);
            if (tex == null) continue;
            images.add(tex.image);
        }
        return images;
    }

    public void setImages(List<? extends IImage> images) throws IOException {
        if (images.isEmpty() || !(this.d_material instanceof MatAttrs)) {
            return;
        }
        MatAttrs dmat = (MatAttrs)this.d_material;
        int ix = 0;
        for (MatChannel chnl : MatChannel.values()) {
            Texture tex = this.d_material.getTexture(chnl);
            if (tex == null) continue;
            IImage newImg = images.get(ix++);
            tex = tex.apply(newImg);
            dmat = dmat.applyTexture(chnl, tex);
        }
        this.d_material = dmat;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void setAttributes(IMatAttrs mat) {
        this.d_material = mat;
        this.changedEvt(new Object[0]);
    }

    @Override
    public IMatAttrs getAttributes() {
        return this.d_material;
    }

    @Override
    public UnitDouble getWidth() {
        return this.d_width;
    }

    protected void setWidth(UnitDouble width) {
        this.d_width = width;
        this.changedEvt(new Object[0]);
    }

    @Override
    public UnitDouble getHeight() {
        return this.d_height;
    }

    protected void setHeight(UnitDouble height) {
        this.d_height = height;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void setSize(UnitDouble width, UnitDouble height) {
        if (this.d_width.equals(width) && this.d_height.equals(height)) {
            return;
        }
        this.d_width = width;
        this.d_height = height;
        this.changedEvt(new Object[0]);
    }

    public boolean isValid() {
        for (MatChannel chnl : MatChannel.values()) {
            Texture tex = this.d_material.getTexture(chnl);
            if (tex == null || tex.image.isValid()) continue;
            return false;
        }
        return true;
    }

    public static BufferedImage makeSafe(BufferedImage img) {
        if (img == null) {
            return null;
        }
        BufferedImage compat = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        Graphics2D g2d = compat.createGraphics();
        g2d.drawImage(img, null, 0, 0);
        g2d.dispose();
        return compat;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[[Texture]");
        for (MatChannel chnl : MatChannel.values()) {
            if (!MatUtil.isSupported(this.d_material, chnl)) continue;
            Color c = this.d_material.getColor(chnl);
            Texture tex = this.d_material.getTexture(chnl);
            sb.append(chnl.name());
            sb.append(": ");
            if (c != null) {
                sb.append("color=");
                sb.append(c.toString());
                sb.append(" ");
            }
            if (tex == null) continue;
            sb.append("tex=");
            sb.append(new File(tex.image.getFilename()).getName());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        boolean version = true;
        oos.writeInt(1);
        if (oos instanceof IPropertySet) {
            ((IPropertySet)((Object)oos)).set(Texture.PROP_CACHE_IN_STREAM, true);
        } else {
            System.err.println("Texture not saved with material: ObjectOutputStream was not an IPropertySet.");
        }
        oos.writeObject(this.d_material);
        oos.writeObject(this.d_width);
        oos.writeObject(this.d_height);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.readInt();
        this.d_material = (IMatAttrs)ois.readObject();
        this.d_width = (UnitDouble)ois.readObject();
        this.d_height = (UnitDouble)ois.readObject();
    }

    public void save(File dir, String filename) throws IOException {
        TeciProps tp = new TeciProps();
        tp.set(PROP_MAT_NAME, this.getName());
        tp.set(PROP_VERSION, Integer.valueOf(PropVersion.curr().ordinal()));
        tp.set(PROP_WIDTH, this.getWidth());
        tp.set(PROP_HEIGHT, this.getHeight());
        this.getAttributes().save(tp, (IImage img) -> {
            File file = new File(img.getFilename());
            return FilenameManager.getRelativeFilename(dir, file, false);
        });
        File f = new File(dir, filename);
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(f);
            tp.storeToXML(fos, null);
        }
    }

    public static Material load(File dir, String filename) throws IOException {
        File propsFile = new File(dir, filename);
        TeciProps tp = Material.loadProps(propsFile);
        String name = tp.getString(PROP_MAT_NAME);
        if (name == null) {
            name = FilenameManager.splitFilename(filename)[0];
        }
        UnitDouble width = tp.getUnitDouble(PROP_WIDTH);
        UnitDouble height = tp.getUnitDouble(PROP_HEIGHT);
        IMatAttrs matAttrs = IMatAttrs.load(tp, (String fn) -> {
            File file = FilenameManager.resolveFile(dir, fn, false);
            return ImageManager.getImage(file.getAbsolutePath(), 3, 0);
        });
        return new Material(name, matAttrs, width, height);
    }

    private static TeciProps loadProps(File infoFile) throws IOException {
        try (FileInputStream is = new FileInputStream(infoFile);){
            TeciProps tp = new TeciProps();
            tp.loadFromXML(is);
            int version = tp.getInt(PROP_VERSION);
            if (version < PropVersion.VERSION_0001.ordinal()) {
                String name = FilenameManager.splitFilename(infoFile.getName())[0];
                tp.set(PROP_MAT_NAME, name);
                Unit lenUnit = Material.getLenUnit(tp);
                double width = tp.getDouble((String)Material.PROP_WIDTH.key, ((UnitDouble)Material.PROP_WIDTH.defVal).getValue(lenUnit));
                double height = tp.getDouble((String)Material.PROP_HEIGHT.key, ((UnitDouble)Material.PROP_HEIGHT.defVal).getValue(lenUnit));
                tp.set(PROP_WIDTH, new UnitDouble(width, lenUnit));
                tp.set(PROP_HEIGHT, new UnitDouble(height, lenUnit));
                tp.remove(PROP_UNITS);
                tp.set(PROP_VERSION, Integer.valueOf(PropVersion.curr().ordinal()));
                String imgName = infoFile.getName();
                imgName = FilenameManager.splitFilename(imgName)[0];
                tp.set("diffuse.tex", imgName);
                IMatAttrs.DIFFUSE_COLOR.save(tp, i -> "", Color.WHITE);
            }
            if (version < PropVersion.VERSION_0002.ordinal()) {
                IMatAttrs.SPECULAR_COLOR.save(tp, i -> "", (Color)IMatAttrs.SPECULAR_COLOR.defVal);
            }
            TeciProps teciProps = tp;
            return teciProps;
        }
    }

    private static Unit getLenUnit(TeciProps props) {
        String prop = props.getString(PROP_UNITS);
        if (prop == null) {
            return SI.METER;
        }
        boolean UNIT_METERS = false;
        boolean UNIT_FEET = true;
        if (prop.equals(Integer.toString(0))) {
            return SI.METER;
        }
        if (prop.equals(Integer.toString(1))) {
            return NonSI.FOOT;
        }
        try {
            Unit u = Unit.valueOf(prop);
            if (UnitDouble.areCompatible(u, SI.METER)) {
                return u;
            }
            String msg = String.format(Intl.intl("Incompatible unit: %s"), prop);
            System.err.println(msg);
        }
        catch (IllegalArgumentException e) {
            String txt = String.format(Intl.intl("Unrecognized unit: %s"), prop);
            System.err.println(txt);
        }
        return SI.METER;
    }

    private static enum PropVersion {
        VERSION_0000,
        VERSION_0001,
        VERSION_0002;


        public static PropVersion curr() {
            return PropVersion.values()[PropVersion.values().length - 1];
        }
    }
}

