/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.vecmath.Point3i;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.APyroObject;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.Grid;
import pyrosim.domain.GridRefinement;
import pyrosim.domain.IGridObj;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimError;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxi;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.RTreei;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;

public class RefinementZoneUtil {
    private static final int FDS_MESH_MIN_DIMENSION = 3;

    public static RefinementResults refineMeshesNoInterrupt(PyroMod mod, Consumer<SimError> addWarning) {
        return RefinementZoneUtil.refineMeshesNoInterrupt(((APyroObject)mod.getGridManager()).flatten(IGridObj.class), addWarning);
    }

    public static RefinementResults refineMeshesNoInterrupt(Collection<? extends IGridObj> gridObjs, Consumer<SimError> addWarning) {
        try {
            ArrayList<Grid> grids = new ArrayList<Grid>(theUtil.filter(gridObjs, Grid.class, APyroObject::isEnabled));
            ArrayList<GridRefinement> refinements = new ArrayList<GridRefinement>(theUtil.filter(gridObjs, GridRefinement.class, APyroObject::isEnabled));
            return RefinementZoneUtil.refineMeshes(grids, refinements, addWarning);
        }
        catch (InterruptedException e) {
            assert (false);
            return new RefinementResults(Collections.emptyList(), Collections.emptyList(), Collections.emptyMap());
        }
    }

    public static RefinementResults refineMeshes(Collection<Grid> grids, Collection<GridRefinement> refinements, Consumer<SimError> addWarning) throws InterruptedException {
        RTree<GridRefinement> refinementTree = new RTree<GridRefinement>();
        for (GridRefinement gridRefinement : refinements) {
            theUtil.throwIfInterrupted();
            refinementTree.insert(gridRefinement.getBounds(), gridRefinement);
        }
        RTree<Grid> gridTree = new RTree<Grid>();
        for (Grid grid2 : grids) {
            theUtil.throwIfInterrupted();
            gridTree.insert(grid2.getBounds(), grid2);
        }
        LinkedIdentityHashSet<GridRefinement> linkedIdentityHashSet = new LinkedIdentityHashSet<GridRefinement>();
        for (GridRefinement refinement3 : refinements) {
            LinkedIdentityHashSet overlaps = new LinkedIdentityHashSet();
            gridTree.find(refinement3.getBounds(), (grid, ctmt) -> overlaps.add(grid));
            if (overlaps.size() <= 1) continue;
            overlaps.add(refinement3);
            addWarning.accept(new SimError(SimError.Level.MODERATE, String.format(Intl.intl("Refinement Zone %1$s intersects or borders on multiple meshes."), refinement3.getName()), String.format(Intl.intl("Skipped applying Refinement Zone %1$s and any embedded Refinement Zones."), refinement3.getName()), overlaps));
            linkedIdentityHashSet.add(refinement3);
        }
        LinkedIdentityHashMap<IGridObj, RefinementTree> linkedIdentityHashMap = new LinkedIdentityHashMap<IGridObj, RefinementTree>();
        for (Grid grid3 : grids) {
            theUtil.throwIfInterrupted();
            ArrayList<GridRefinement> intersectingRefinements = new ArrayList<GridRefinement>();
            refinementTree.find(grid3.getBounds(), (refinement, ctmt) -> intersectingRefinements.add((GridRefinement)refinement));
            if (!intersectingRefinements.isEmpty()) {
                SnapPositions alignedPositions = RefinementZoneUtil.mergeBorderingMeshes(grid3, gridTree);
                Map<IGridObj, RefinementTree> meshResults = RefinementZoneUtil.refineMesh(grid3, alignedPositions, intersectingRefinements, linkedIdentityHashSet, gridTree, true, (warning, actionTaken, objs) -> {
                    LinkedIdentityHashSet affectedObjs = new LinkedIdentityHashSet(objs);
                    affectedObjs.add(grid3);
                    addWarning.accept(new SimError(SimError.Level.MODERATE, (String)warning, (String)actionTaken, affectedObjs));
                });
                linkedIdentityHashMap.putAll(meshResults);
                continue;
            }
            linkedIdentityHashMap.put(grid3, new RefinementTree(grid3));
        }
        return new RefinementResults(new LinkedIdentityHashSet<Grid>(grids), new LinkedIdentityHashSet<GridRefinement>(refinements), linkedIdentityHashMap);
    }

    private static Map<IGridObj, RefinementTree> refineMesh(Grid targetGrid, SnapPositions parentPositions, Collection<GridRefinement> refinements, Set<GridRefinement> prevInvalidRefinements, RTree<Grid> borderingGrids, boolean rootLevel, TriConsumer<String, String, Collection<IPyroObject>> addWarning) throws InterruptedException {
        Object snappedRefinement;
        SnapPositions targetPositions = new SnapPositions(targetGrid.getXLinePositions(), targetGrid.getYLinePositions(), targetGrid.getZLinePositions());
        RTreei<Object> snappedRefinements = new RTreei<Object>();
        LinkedIdentityHashSet invalidRefinements = new LinkedIdentityHashSet();
        for (GridRefinement refinement2 : refinements) {
            theUtil.throwIfInterrupted();
            Point3i snappedMin = RefinementZoneUtil.snapGridPosition(parentPositions, refinement2.getMinPoint());
            Iterator<Object> snappedMax = RefinementZoneUtil.snapGridPosition(parentPositions, refinement2.getMaxPoint());
            AABoxi aABoxi = new AABoxi(snappedMin, (Point3i)((Object)snappedMax));
            SnappedRefinementFace[] refinementFaces = new SnappedRefinementFace[]{new SnappedRefinementFace(Geometry.Axis.X, aABoxi.getMinX(), aABoxi.getDepth() * aABoxi.getHeight(), new AABoxi(aABoxi.getMinX(), aABoxi.getMinY(), aABoxi.getMinZ(), aABoxi.getMinX(), aABoxi.getMaxY(), aABoxi.getMaxZ())), new SnappedRefinementFace(Geometry.Axis.X, aABoxi.getMaxX(), aABoxi.getDepth() * aABoxi.getHeight(), new AABoxi(aABoxi.getMaxX(), aABoxi.getMinY(), aABoxi.getMinZ(), aABoxi.getMaxX(), aABoxi.getMaxY(), aABoxi.getMaxZ())), new SnappedRefinementFace(Geometry.Axis.Y, aABoxi.getMinY(), aABoxi.getWidth() * aABoxi.getHeight(), new AABoxi(aABoxi.getMinX(), aABoxi.getMinY(), aABoxi.getMinZ(), aABoxi.getMaxX(), aABoxi.getMinY(), aABoxi.getMaxZ())), new SnappedRefinementFace(Geometry.Axis.Y, aABoxi.getMaxY(), aABoxi.getWidth() * aABoxi.getHeight(), new AABoxi(aABoxi.getMinX(), aABoxi.getMaxY(), aABoxi.getMinZ(), aABoxi.getMaxX(), aABoxi.getMaxY(), aABoxi.getMaxZ())), new SnappedRefinementFace(Geometry.Axis.Z, aABoxi.getMinZ(), aABoxi.getWidth() * aABoxi.getDepth(), new AABoxi(aABoxi.getMinX(), aABoxi.getMinY(), aABoxi.getMinZ(), aABoxi.getMaxX(), aABoxi.getMaxY(), aABoxi.getMinZ())), new SnappedRefinementFace(Geometry.Axis.Z, aABoxi.getMaxZ(), aABoxi.getWidth() * aABoxi.getDepth(), new AABoxi(aABoxi.getMinX(), aABoxi.getMinY(), aABoxi.getMaxZ(), aABoxi.getMaxX(), aABoxi.getMaxY(), aABoxi.getMaxZ()))};
            snappedRefinement = new SnappedRefinement(refinement2, aABoxi, refinementFaces);
            snappedRefinements.insert(aABoxi, snappedRefinement);
            int minDim = Math.ceilDiv(3, refinement2.getRefinementAmount().getCellMultiplier());
            Point3i targetSnappedMin = RefinementZoneUtil.retargetSnapPosition(parentPositions, targetPositions, snappedMin);
            Point3i targetSnappedMax = RefinementZoneUtil.retargetSnapPosition(parentPositions, targetPositions, snappedMax);
            AABoxi targetSnappedBounds = new AABoxi(targetSnappedMin, targetSnappedMax);
            int[] targetEdgeDists = new int[]{targetSnappedMin.x, targetSnappedMin.y, targetSnappedMin.z, targetPositions.x.length - 1 - targetSnappedMax.x, targetPositions.y.length - 1 - targetSnappedMax.y, targetPositions.z.length - 1 - targetSnappedMax.z};
            if (prevInvalidRefinements.contains(((SnappedRefinement)snappedRefinement).original)) {
                invalidRefinements.add(snappedRefinement);
                continue;
            }
            if (targetSnappedBounds.getWidth() < minDim || targetSnappedBounds.getHeight() < minDim || targetSnappedBounds.getDepth() < minDim) {
                addWarning.accept(String.format(Intl.intl("Refinement Zone %1$s must enclose at least %2$d cell(s) in each dimension in Mesh %3$s."), refinement2.getName(), minDim, targetGrid.getName()), String.format(Intl.intl("Skipped applying Refinement Zone %1$s and any embedded Refinement Zones to Mesh %2$s."), refinement2.getName(), targetGrid.getName()), List.of(refinement2));
                invalidRefinements.add(snappedRefinement);
                continue;
            }
            if (rootLevel && !Arrays.stream(targetEdgeDists).allMatch(dist -> dist == 0 || dist >= 3)) {
                addWarning.accept(String.format(Intl.intl("There must be either 0 or at least %1$d mesh cell(s) between Refinement Zone %2$s and the border of Mesh %3$s."), 3, refinement2.getName(), targetGrid.getName()), String.format(Intl.intl("Skipped applying Refinement Zone %1$s and any embedded Refinement Zones to Mesh %2$s."), refinement2.getName(), targetGrid.getName()), List.of(refinement2));
                invalidRefinements.add(snappedRefinement);
                continue;
            }
            if (!rootLevel && !Arrays.stream(targetEdgeDists).allMatch(dist -> dist >= 3)) {
                addWarning.accept(String.format(Intl.intl("There must be at least %1$d mesh cell(s) between Refinement Zone %2$s and the border of it's surrounding Refinement Zone."), 3, refinement2.getName()), String.format(Intl.intl("Skipped applying Refinement Zone %1$s and any embedded Refinement Zones."), refinement2.getName()), List.of(refinement2));
                invalidRefinements.add(snappedRefinement);
                continue;
            }
            if (!RefinementZoneUtil.bordersOtherMesh(targetSnappedBounds, targetPositions, targetGrid, borderingGrids)) continue;
            addWarning.accept(String.format(Intl.intl("There must be at least %1$d mesh cell(s) between Refinement Zone %2$s in Mesh %3$s and any other meshes."), 3, refinement2.getName(), targetGrid.getName()), String.format(Intl.intl("Skipped applying Refinement Zone %1$s and any embedded Refinement Zones to Mesh %2$s."), refinement2.getName(), targetGrid.getName()), List.of(refinement2));
            invalidRefinements.add(snappedRefinement);
        }
        LinkedIdentityHashMap refinementParents = new LinkedIdentityHashMap();
        LinkedIdentityHashMap refinementChildren = new LinkedIdentityHashMap();
        snappedRefinements.getAll((IResult<Object>)((IResult<SnappedRefinement>)(a, ignored) -> {
            AABoxi expandedBounds = new AABoxi(a.snappedBounds);
            expandedBounds.expandEq(3);
            snappedRefinements.find(expandedBounds, (b, ctmt) -> {
                if (a != b && !invalidRefinements.containsAll(List.of(a, b))) {
                    if (a.snappedBounds.equals(b.snappedBounds)) {
                        addWarning.accept(String.format(Intl.intl("Refinement Zone %1$s has identical bounds to Refinement Zone %2$s."), a.original.getName(), b.original.getName()), String.format(Intl.intl("Skipped applying Refinement Zones %1$s and %2$s and any embedded Refinement Zones ."), a.original.getName(), b.original.getName()), List.of(a.original, b.original));
                        invalidRefinements.add(a);
                        invalidRefinements.add(b);
                    } else if (a.snappedBounds.intersectsInner(b.snappedBounds)) {
                        if (a.snappedBounds.test(b.snappedBounds) != Containment.INSIDE && b.snappedBounds.test(a.snappedBounds) != Containment.INSIDE) {
                            addWarning.accept(String.format(Intl.intl("Refinement Zone %1$s intersects Refinement Zone %2$s, but neither fully contains the other."), a.original.getName(), b.original.getName()), String.format(Intl.intl("Skipped applying Refinement Zones %1$s and %2$s and any embedded Refinement Zones."), a.original.getName(), b.original.getName()), List.of(a.original, b.original));
                            invalidRefinements.add(a);
                            invalidRefinements.add(b);
                        } else if (a.snappedBounds.test(b.snappedBounds) == Containment.INSIDE) {
                            RefinementZoneUtil.addMultiMap(refinementParents, b, a, LinkedIdentityHashSet::new);
                            RefinementZoneUtil.addMultiMap(refinementChildren, a, b, LinkedIdentityHashSet::new);
                        }
                    } else if (!a.snappedBounds.intersects(b.snappedBounds)) {
                        AABoxi targetSnappedA = new AABoxi(RefinementZoneUtil.retargetSnapPosition(parentPositions, targetPositions, a.snappedBounds.getMin()), RefinementZoneUtil.retargetSnapPosition(parentPositions, targetPositions, a.snappedBounds.getMax()));
                        targetSnappedA.expandEq(2);
                        AABoxi targetSnappedB = new AABoxi(RefinementZoneUtil.retargetSnapPosition(parentPositions, targetPositions, b.snappedBounds.getMin()), RefinementZoneUtil.retargetSnapPosition(parentPositions, targetPositions, b.snappedBounds.getMax()));
                        if (targetSnappedA.intersects(targetSnappedB)) {
                            addWarning.accept(String.format(Intl.intl("Refinement Zone %1$s must be either embedded in or at least %3$s cells from Refinement Zone %2$s."), a.original.getName(), b.original.getName(), 3), String.format(Intl.intl("Skipped applying Refinement Zones %1$s and %2$s and any embedded Refinement Zones."), a.original.getName(), b.original.getName()), List.of(a.original, b.original));
                            invalidRefinements.add(a);
                            invalidRefinements.add(b);
                        }
                    }
                }
            });
        }));
        LinkedIdentityHashSet invalidChildren = new LinkedIdentityHashSet();
        for (SnappedRefinement snappedRefinement2 : invalidRefinements) {
            Set children = (Set)refinementChildren.get(snappedRefinement2);
            if (children == null) continue;
            invalidChildren.addAll(children);
            snappedRefinement = children.iterator();
            while (snappedRefinement.hasNext()) {
                SnappedRefinement child = (SnappedRefinement)snappedRefinement.next();
                addWarning.accept(String.format(Intl.intl("Refinement Zone %1$s is embedded in invalid Refinement Zone %2$s."), child.original.getName(), snappedRefinement2.original.getName()), String.format(Intl.intl("Skipped applying Refinement Zone %1$s and any embedded Refinement Zones."), child.original.getName()), List.of(child.original));
            }
        }
        invalidRefinements.addAll(invalidChildren);
        for (SnappedRefinement snappedRefinement3 : invalidRefinements) {
            snappedRefinements.remove(snappedRefinement3);
            refinementChildren.remove(snappedRefinement3);
            refinementParents.remove(snappedRefinement3);
            for (Map.Entry entry : refinementParents.entrySet()) {
                ((Set)entry.getValue()).remove(snappedRefinement3);
            }
            for (Map.Entry entry : refinementChildren.entrySet()) {
                ((Set)entry.getValue()).remove(snappedRefinement3);
            }
        }
        for (Map.Entry entry : refinementParents.entrySet()) {
            if (((Set)entry.getValue()).isEmpty()) continue;
            snappedRefinements.remove((SnappedRefinement)entry.getKey());
        }
        if (snappedRefinements.isEmpty()) {
            return Map.of(targetGrid, new RefinementTree(targetGrid));
        }
        ArrayList<SnappedGrid> finalSplits = new ArrayList<SnappedGrid>();
        SnappedGrid snappedGrid = new SnappedGrid(new AABoxi(0, 0, 0, parentPositions.x.length - 1, parentPositions.y.length - 1, parentPositions.z.length - 1));
        ArrayDeque<SnappedGrid> overlappingSplits = new ArrayDeque<SnappedGrid>(List.of(snappedGrid));
        while (!overlappingSplits.isEmpty()) {
            theUtil.throwIfInterrupted();
            SnappedGrid splitGrid = (SnappedGrid)overlappingSplits.pop();
            SnappedRefinementFace[] bestSplit = new SnappedRefinementFace[]{null};
            snappedRefinements.find(splitGrid.box, (IResult<Object>)((IResult<SnappedRefinement>)(refinement, ctmt) -> {
                for (SnappedRefinementFace face : refinement.faces) {
                    if (!splitGrid.box.intersectsInner(face.box) || bestSplit[0] != null && face.area <= bestSplit[0].area) continue;
                    bestSplit[0] = face;
                }
            }));
            if (bestSplit[0] == null) {
                finalSplits.add(splitGrid);
                continue;
            }
            overlappingSplits.addAll(RefinementZoneUtil.splitMesh(splitGrid, bestSplit[0]));
        }
        ArrayList toRemove = new ArrayList();
        for (SnappedGrid candidate : finalSplits) {
            theUtil.throwIfInterrupted();
            snappedRefinements.getAll((IResult<Object>)((IResult<SnappedRefinement>)(refinement, ctmt) -> {
                if (refinement.snappedBounds.test(candidate.box) == Containment.INSIDE) {
                    toRemove.add(candidate);
                }
            }));
        }
        finalSplits.removeAll(toRemove);
        LinkedIdentityHashMap<IGridObj, RefinementTree> results = new LinkedIdentityHashMap<IGridObj, RefinementTree>();
        RefinementTree gridSplits = new RefinementTree(targetGrid);
        results.put(targetGrid, gridSplits);
        for (int i = 0; i < finalSplits.size(); ++i) {
            theUtil.throwIfInterrupted();
            SnappedGrid split = (SnappedGrid)finalSplits.get(i);
            if (split == snappedGrid) {
                gridSplits.branches.add(new RefinementTree(targetGrid));
                continue;
            }
            Point3i minTarget = RefinementZoneUtil.retargetSnapPosition(parentPositions, targetPositions, split.box.getMin());
            Point3i maxTarget = RefinementZoneUtil.retargetSnapPosition(parentPositions, targetPositions, split.box.getMax());
            UnitPoint3D min = RefinementZoneUtil.unsnapGridPosition(targetPositions, minTarget);
            UnitPoint3D max = RefinementZoneUtil.unsnapGridPosition(targetPositions, maxTarget);
            Grid splitGrid = (Grid)targetGrid.clone();
            splitGrid.setName(String.format("%s-%02d", targetGrid.getName(), i + 1));
            splitGrid.setGeom(new Grid.GridGeom(min, max, RefinementZoneUtil.getRefinedCellWidths(targetPositions.x, minTarget.getX(), maxTarget.getX(), 1), RefinementZoneUtil.getRefinedCellWidths(targetPositions.y, minTarget.getY(), maxTarget.getY(), 1), RefinementZoneUtil.getRefinedCellWidths(targetPositions.z, minTarget.getZ(), maxTarget.getZ(), 1)));
            gridSplits.branches.add(new RefinementTree(splitGrid));
        }
        CollResult validRefinements = new CollResult(SnappedRefinement.class);
        snappedRefinements.getAll(validRefinements);
        for (SnappedRefinement refinement3 : validRefinements.coll) {
            theUtil.throwIfInterrupted();
            AABoxi snappedBounds = refinement3.snappedBounds;
            int cellMult = refinement3.original.getRefinementAmount().getCellMultiplier();
            Point3i minTarget = RefinementZoneUtil.retargetSnapPosition(parentPositions, targetPositions, snappedBounds.getMin());
            Point3i maxTarget = RefinementZoneUtil.retargetSnapPosition(parentPositions, targetPositions, snappedBounds.getMax());
            UnitPoint3D min = RefinementZoneUtil.unsnapGridPosition(targetPositions, minTarget);
            UnitPoint3D max = RefinementZoneUtil.unsnapGridPosition(targetPositions, maxTarget);
            Grid refinedGrid = new Grid(refinement3.original.getName(), min, max, RefinementZoneUtil.getRefinedCellWidths(targetPositions.x, minTarget.getX(), maxTarget.getX(), cellMult), RefinementZoneUtil.getRefinedCellWidths(targetPositions.y, minTarget.getY(), maxTarget.getY(), cellMult), RefinementZoneUtil.getRefinedCellWidths(targetPositions.z, minTarget.getZ(), maxTarget.getZ(), cellMult));
            Color color = refinement3.original.getColor();
            if (color == null) {
                color = GridRefinement.DEF_COLOR;
            }
            refinedGrid.setColor(new Color(color.getRGB()));
            refinedGrid.setFYI(refinement3.original.getFYI());
            refinedGrid.setTags(refinement3.original.getTags());
            LinkedHashMap<String, String> mergedProps = new LinkedHashMap<String, String>();
            mergedProps.putAll(targetGrid.getCustomFDSProps().getProps());
            mergedProps.putAll(refinement3.original.getCustomFDSProps().getProps());
            refinedGrid.setCustomFDSProps(CustomFDSProps.get(mergedProps));
            Set childRefinements = (Set)refinementChildren.get(refinement3);
            if (childRefinements != null && !childRefinements.isEmpty()) {
                List<GridRefinement> unsnappedChildren = childRefinements.stream().map(snapped -> snapped.original).toList();
                Map<IGridObj, RefinementTree> embeddedRefinements = RefinementZoneUtil.refineMesh(refinedGrid, targetPositions, unsnappedChildren, Collections.emptySet(), null, false, addWarning);
                for (Map.Entry<IGridObj, RefinementTree> entry : embeddedRefinements.entrySet()) {
                    if (entry.getKey() == refinedGrid) {
                        if (entry.getValue().isLeaf()) {
                            results.put(refinement3.original, new RefinementTree(refinedGrid));
                            continue;
                        }
                        results.put(refinement3.original, new RefinementTree(refinement3.original, entry.getValue().branches));
                        continue;
                    }
                    results.put(entry.getKey(), entry.getValue());
                }
            } else {
                results.put(refinement3.original, new RefinementTree(refinement3.original, List.of(new RefinementTree(refinedGrid))));
            }
            gridSplits.branches.add(results.getOrDefault(refinement3.original, new RefinementTree(refinement3.original)));
        }
        return results;
    }

    private static UnitDouble[] getRefinedCellWidths(UnitDouble[] positions, int minPos, int maxPos, int cellMult) {
        assert (minPos >= 0);
        assert (maxPos < positions.length);
        int cellDim = maxPos - minPos;
        Object[] widths = new UnitDouble[cellDim * cellMult];
        for (int i = 0; i < cellDim; ++i) {
            UnitDouble start = positions[minPos + i];
            UnitDouble end = positions[minPos + i + 1];
            UnitDouble width = end.sub(start);
            UnitDouble refinedWidth = new UnitDouble(width.getRawValue() / (double)cellMult, width.getUnit());
            Arrays.fill(widths, i * cellMult, i * cellMult + cellMult, refinedWidth);
        }
        return widths;
    }

    private static List<SnappedGrid> splitMesh(SnappedGrid grid, SnappedRefinementFace face) {
        ArrayList<SnappedGrid> splits = new ArrayList<SnappedGrid>();
        switch (face.axis) {
            case X: {
                splits.add(new SnappedGrid(new AABoxi(grid.box.getMinX(), grid.box.getMinY(), grid.box.getMinZ(), face.coord, grid.box.getMaxY(), grid.box.getMaxZ())));
                splits.add(new SnappedGrid(new AABoxi(face.coord, grid.box.getMinY(), grid.box.getMinZ(), grid.box.getMaxX(), grid.box.getMaxY(), grid.box.getMaxZ())));
                break;
            }
            case Y: {
                splits.add(new SnappedGrid(new AABoxi(grid.box.getMinX(), grid.box.getMinY(), grid.box.getMinZ(), grid.box.getMaxX(), face.coord, grid.box.getMaxZ())));
                splits.add(new SnappedGrid(new AABoxi(grid.box.getMinX(), face.coord, grid.box.getMinZ(), grid.box.getMaxX(), grid.box.getMaxY(), grid.box.getMaxZ())));
                break;
            }
            case Z: {
                splits.add(new SnappedGrid(new AABoxi(grid.box.getMinX(), grid.box.getMinY(), grid.box.getMinZ(), grid.box.getMaxX(), grid.box.getMaxY(), face.coord)));
                splits.add(new SnappedGrid(new AABoxi(grid.box.getMinX(), grid.box.getMinY(), face.coord, grid.box.getMaxX(), grid.box.getMaxY(), grid.box.getMaxZ())));
            }
        }
        return splits;
    }

    private static boolean bordersOtherMesh(AABoxi refinementBounds, SnapPositions positions, Grid targetGrid, RTree<Grid> borderingGrids) {
        if (borderingGrids == null || borderingGrids.isEmpty()) {
            return false;
        }
        UnitPoint3D globalMin = RefinementZoneUtil.unsnapGridPosition(positions, refinementBounds.getMin());
        globalMin = globalMin.sub(new UnitPoint3D(1.0E-6, 1.0E-6, 1.0E-6, Geometry.LU));
        UnitPoint3D globalMax = RefinementZoneUtil.unsnapGridPosition(positions, refinementBounds.getMax());
        globalMax = globalMax.add(new UnitPoint3D(1.0E-6, 1.0E-6, 1.0E-6, Geometry.LU));
        AABox globalBounds = new AABox(globalMin.getPoint3dValue(Geometry.LU), globalMax.getPoint3dValue(Geometry.LU));
        boolean[] hasBordering = new boolean[]{false};
        borderingGrids.find(globalBounds, (borderingGrid, ctmt) -> {
            if (borderingGrid != targetGrid) {
                hasBordering[0] = true;
            }
        });
        return hasBordering[0];
    }

    private static SnapPositions mergeBorderingMeshes(Grid targetMesh, RTree<Grid> borderingMeshes) {
        UnitDouble[][] targetPositions = new UnitDouble[][]{targetMesh.getXLinePositions(), targetMesh.getYLinePositions(), targetMesh.getZLinePositions()};
        UnitPoint3D targetMin = targetMesh.getMinPoint();
        UnitPoint3D targetMax = targetMesh.getMaxPoint();
        UnitPoint3D expandedMin = targetMin;
        expandedMin = expandedMin.sub(new UnitPoint3D(1.0E-6, 1.0E-6, 1.0E-6, Geometry.LU));
        UnitPoint3D expandedMax = targetMax;
        expandedMax = expandedMax.add(new UnitPoint3D(1.0E-6, 1.0E-6, 1.0E-6, Geometry.LU));
        AABox expandedBounds = new AABox(expandedMin.getPoint3dValue(Geometry.LU), expandedMax.getPoint3dValue(Geometry.LU));
        borderingMeshes.find(expandedBounds, (borderingMesh, ctmt) -> {
            if (borderingMesh == targetMesh) {
                return;
            }
            UnitPoint3D borderingMin = borderingMesh.getMinPoint();
            UnitPoint3D borderingMax = borderingMesh.getMaxPoint();
            if (borderingMin.xu().ge(targetMin.xu(), 1.0E-6) || borderingMax.xu().le(targetMax.xu(), 1.0E-6)) {
                targetPositions[0] = RefinementZoneUtil.mergeAxisPositions(targetPositions[0], borderingMesh.getXLinePositions());
            }
            if (borderingMin.yu().ge(targetMin.yu(), 1.0E-6) || borderingMax.yu().le(targetMax.yu(), 1.0E-6)) {
                targetPositions[1] = RefinementZoneUtil.mergeAxisPositions(targetPositions[1], borderingMesh.getYLinePositions());
            }
            if (borderingMin.zu().ge(targetMin.zu(), 1.0E-6) || borderingMax.zu().le(targetMax.zu(), 1.0E-6)) {
                targetPositions[2] = RefinementZoneUtil.mergeAxisPositions(targetPositions[2], borderingMesh.getZLinePositions());
            }
        });
        return new SnapPositions(targetPositions[0], targetPositions[1], targetPositions[2]);
    }

    private static UnitDouble[] mergeAxisPositions(UnitDouble[] targetPositions, UnitDouble[] borderingPositions) {
        int targetIndex;
        ArrayList<UnitDouble> results = new ArrayList<UnitDouble>(targetPositions.length);
        int borderingIndex = 0;
        for (targetIndex = 0; targetIndex < targetPositions.length && targetPositions[targetIndex].lt(borderingPositions[0], 1.0E-6); ++targetIndex) {
            results.add(targetPositions[targetIndex]);
        }
        while (targetIndex < targetPositions.length && borderingIndex < borderingPositions.length) {
            UnitDouble targetPos = targetPositions[targetIndex];
            UnitDouble borderingPos = borderingPositions[borderingIndex];
            if (targetPos.eq(borderingPos, 1.0E-6)) {
                results.add(targetPos);
                ++targetIndex;
                continue;
            }
            if (targetPos.lt(borderingPos, 1.0E-6)) {
                ++targetIndex;
                continue;
            }
            ++borderingIndex;
        }
        while (targetIndex < targetPositions.length) {
            results.add(targetPositions[targetIndex]);
            ++targetIndex;
        }
        return results.toArray(new UnitDouble[0]);
    }

    private static Point3i retargetSnapPosition(SnapPositions currPositions, SnapPositions newPositions, Point3i point) {
        UnitPoint3D unsnapped = RefinementZoneUtil.unsnapGridPosition(currPositions, point);
        return RefinementZoneUtil.snapGridPosition(newPositions, unsnapped);
    }

    private static UnitPoint3D unsnapGridPosition(SnapPositions positions, Point3i point) {
        int x = Math.clamp((long)point.x, 0, positions.x.length - 1);
        int y = Math.clamp((long)point.y, 0, positions.y.length - 1);
        int z = Math.clamp((long)point.z, 0, positions.z.length - 1);
        return new UnitPoint3D(positions.x[x], positions.y[y], positions.z[z]);
    }

    private static Point3i snapGridPosition(SnapPositions positions, UnitPoint3D point) {
        return new Point3i(RefinementZoneUtil.snapAxisPosition(positions.x, point.xu()), RefinementZoneUtil.snapAxisPosition(positions.y, point.yu()), RefinementZoneUtil.snapAxisPosition(positions.z, point.zu()));
    }

    private static int snapAxisPosition(UnitDouble[] positions, UnitDouble point) {
        UnitDouble nextDist;
        int index = Arrays.binarySearch(positions, point);
        if (index >= 0) {
            return index;
        }
        index = -(index + 1);
        int prevIx = Math.clamp((long)(index - 1), 0, positions.length - 1);
        int nextIx = Math.clamp((long)index, 0, positions.length - 1);
        UnitDouble prev = positions[Math.clamp((long)(index - 1), 0, positions.length - 1)];
        UnitDouble next = positions[Math.clamp((long)index, 0, positions.length - 1)];
        UnitDouble prevDist = prev.sub(point).abs();
        if (prevDist.lt(nextDist = next.sub(point).abs(), 1.0E-6)) {
            return prevIx;
        }
        return nextIx;
    }

    private static <K, V> void addMultiMap(Map<K, Set<V>> multiMap, K key, V value, Supplier<Set<V>> emptySet) {
        multiMap.compute(key, (newKey, set) -> {
            if (set == null) {
                set = (Set)emptySet.get();
            }
            set.add(value);
            return set;
        });
    }

    public static long countCells(RefinementResults refinementResults, IGridObj source) {
        RefinementTree sourceTree = refinementResults.results.get(source);
        if (sourceTree == null) {
            return 0L;
        }
        if (sourceTree.isLeaf()) {
            long l;
            IGridObj iGridObj = sourceTree.grid();
            if (iGridObj instanceof Grid) {
                Grid grid2 = (Grid)iGridObj;
                l = grid2.getCellCount();
            } else {
                l = 0L;
            }
            return l;
        }
        return sourceTree.streamLeaves().mapMulti((grid, consumer) -> {
            if (grid instanceof Grid) {
                Grid finalGrid = (Grid)grid;
                consumer.accept(finalGrid);
            }
        }).mapToLong(Grid::getCellCount).sum();
    }

    public static long countUnrefinedCells(RefinementResults refinementResults, IGridObj source) {
        RefinementTree sourceTree = refinementResults.results.get(source);
        if (sourceTree == null) {
            return 0L;
        }
        if (sourceTree.isLeaf()) {
            long l;
            IGridObj iGridObj = sourceTree.grid();
            if (iGridObj instanceof Grid) {
                Grid grid2 = (Grid)iGridObj;
                l = grid2.getCellCount();
            } else {
                l = 0L;
            }
            return l;
        }
        return sourceTree.branches().stream().filter(RefinementTree::isLeaf).map(RefinementTree::grid).mapMulti((grid, consumer) -> {
            if (grid instanceof Grid) {
                Grid finalGrid = (Grid)grid;
                consumer.accept(finalGrid);
            }
        }).mapToLong(Grid::getCellCount).sum();
    }

    public static long countAllCells(RefinementResults refinementResults) {
        return refinementResults.rootGrids.stream().mapToLong(root -> RefinementZoneUtil.countCells(refinementResults, root)).sum();
    }

    public record RefinementResults(Collection<Grid> rootGrids, Collection<GridRefinement> rootRefinements, Map<IGridObj, RefinementTree> results) {
        public RefinementTree getTree(IGridObj root) {
            return this.results.getOrDefault(root, new RefinementTree(root));
        }

        public Stream<Grid> streamLeaves() {
            return this.rootGrids.stream().flatMap(root -> this.results.getOrDefault(root, new RefinementTree((IGridObj)root)).streamLeaves());
        }

        public Stream<RefinementTree> streamParents() {
            return this.rootGrids.stream().flatMap(root -> this.results.getOrDefault(root, new RefinementTree((IGridObj)root)).streamParents());
        }
    }

    private record SnapPositions(UnitDouble[] x, UnitDouble[] y, UnitDouble[] z) {
    }

    public record RefinementTree(IGridObj grid, List<RefinementTree> branches) {
        public RefinementTree(IGridObj grid) {
            this(grid, new ArrayList<RefinementTree>());
        }

        public boolean isLeaf() {
            return this.branches.isEmpty();
        }

        public Stream<Grid> streamLeaves() {
            if (this.isLeaf()) {
                IGridObj iGridObj = this.grid;
                if (iGridObj instanceof Grid) {
                    Grid finalGrid = (Grid)iGridObj;
                    return Stream.of(finalGrid);
                }
                assert (false);
                return Stream.empty();
            }
            return this.branches.stream().flatMap(RefinementTree::streamLeaves);
        }

        public Stream<RefinementTree> streamParents() {
            if (this.isLeaf()) {
                return Stream.empty();
            }
            return Stream.concat(this.branches.stream().flatMap(RefinementTree::streamParents), Stream.of(this));
        }
    }

    private record SnappedRefinementFace(Geometry.Axis axis, int coord, int area, AABoxi box) {
    }

    private record SnappedRefinement(GridRefinement original, AABoxi snappedBounds, SnappedRefinementFace[] faces) {
    }

    private record SnappedGrid(AABoxi box) {
    }
}

