/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import pyrosim.domain.Composite;

public class Property<T> {
    private static final Property N_SUPPORTED = new Property(Composite.NOT_SUPPORTED);
    private static final Property N_UNIFORM = new Property(Composite.NON_UNIFORM);
    private final Object d_val;

    private Property(Object val) {
        this.d_val = val;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Property)) {
            return false;
        }
        Property other = (Property)obj;
        return Objects.equals(this.d_val, other.d_val);
    }

    public int hashCode() {
        return Objects.hashCode(this.d_val);
    }

    public boolean isUniform() {
        return this.d_val != Composite.NOT_SUPPORTED && this.d_val != Composite.NON_UNIFORM;
    }

    public boolean isSupported() {
        return this.d_val != Composite.NOT_SUPPORTED;
    }

    public T get() {
        if (this.d_val == Composite.NOT_SUPPORTED || this.d_val == Composite.NON_UNIFORM) {
            throw new NoSuchElementException("No value present");
        }
        return (T)this.d_val;
    }

    public T orElse(T other) {
        if (this.d_val == Composite.NOT_SUPPORTED || this.d_val == Composite.NON_UNIFORM) {
            return other;
        }
        return (T)this.d_val;
    }

    public T orElseGet(Supplier<T> otherSupplier) {
        if (this.d_val == Composite.NOT_SUPPORTED || this.d_val == Composite.NON_UNIFORM) {
            return otherSupplier.get();
        }
        return (T)this.d_val;
    }

    public <X extends Throwable> T orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.d_val == Composite.NOT_SUPPORTED || this.d_val == Composite.NON_UNIFORM) {
            throw (Throwable)exceptionSupplier.get();
        }
        return (T)this.d_val;
    }

    public void ifUniform(Consumer<T> consumer) {
        if (this.isUniform()) {
            consumer.accept(this.d_val);
        }
    }

    public <U> Property<U> map(Function<? super T, ? extends U> mapper) {
        if (this.d_val == Composite.NON_UNIFORM) {
            return Property.nonUniform();
        }
        if (this.d_val == Composite.NOT_SUPPORTED) {
            return Property.notSupported();
        }
        return Property.of(mapper.apply(this.d_val));
    }

    public <U> Property<U> flatMap(Function<? super T, Property<U>> mapper) {
        if (this.d_val == Composite.NON_UNIFORM) {
            return Property.nonUniform();
        }
        if (this.d_val == Composite.NOT_SUPPORTED) {
            return Property.notSupported();
        }
        return mapper.apply(this.d_val);
    }

    public static <T> Property<T> of(T val) {
        return new Property<T>(val);
    }

    public static <T> Property<T> ofNullable(T val) {
        if (val == null) {
            return Property.nonUniform();
        }
        return Property.of(val);
    }

    public static <T> Property<T> nonUniform() {
        return N_UNIFORM;
    }

    public static <T> Property<T> notSupported() {
        return N_SUPPORTED;
    }
}

