/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IGridObj;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tags.Tag;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Task;

public class GridRefinement
extends NamedPyroObject
implements IGridObj,
IPyroGeomSrc,
ICustomFDSPropsContainer,
ITaggable,
IDirectDependent {
    private static final long serialVersionUID = 1L;
    private UnitPoint3D d_minPoint = new UnitPoint3D(0.0, 0.0, 0.0, Geometry.LU);
    private UnitPoint3D d_maxPoint = new UnitPoint3D(0.0, 0.0, 0.0, Geometry.LU);
    private RefinementAmount d_refinementAmount = RefinementAmount.X2;
    private boolean d_visible = true;
    private Color d_color = null;
    private String d_description = "";
    private Set<Tag> d_tags = Collections.emptySet();
    private CustomFDSProps d_customProps = CustomFDSProps.EMPTY;
    public static final Color DEF_COLOR = new Color(0.7f, 0.2f, 0.9f, 0.2f);

    public GridRefinement(String name, AABoxGeom geom) {
        super(name);
        this.setGeom(geom);
    }

    public GridRefinement(String name, UnitPoint3D minPt, UnitPoint3D maxPt, RefinementAmount refinementAmount) {
        super(name);
        this.d_minPoint = minPt;
        this.d_maxPoint = maxPt;
        this.d_refinementAmount = refinementAmount;
    }

    @Override
    public Set<Tag> getTags() {
        return this.d_tags;
    }

    @Override
    public void setTags(Set<Tag> tags) {
        if (!this.d_tags.equals(tags)) {
            this.d_tags = tags;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        ITaggable.addTagsToDepSnapshot(this, deps);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        ITaggable.removeInvalidTagReplacements(old, objs);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        return ITaggable.taskReplaceTagDep(old, replacement, this);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return ITaggable.getTagUpdateDep();
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(new AABoxGeom(this.d_minPoint.getPoint3dValue(Geometry.LU), this.d_maxPoint.getPoint3dValue(Geometry.LU)));
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof AABoxGeom) {
            AABoxGeom aaBoxGeom = (AABoxGeom)geom;
            this.setGeom(aaBoxGeom.min, aaBoxGeom.max);
        }
    }

    private void setGeom(Point3d minPoint, Point3d maxPoint) {
        UnitPoint3D minPointUnit = new UnitPoint3D(minPoint, Geometry.LU);
        UnitPoint3D maxPointUnit = new UnitPoint3D(maxPoint, Geometry.LU);
        if (!this.d_minPoint.equals(minPointUnit) || !this.d_maxPoint.equals(maxPointUnit)) {
            this.d_minPoint = minPointUnit;
            this.d_maxPoint = maxPointUnit;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), (IPrimProps)new IPrimProps.Face(this.d_color != null ? this.d_color : DEF_COLOR, null, 2));
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible != visible) {
            this.d_visible = visible;
            this.changedEvt(PyroMod.EVT_VISIBILITY_CHANGED);
        }
    }

    @Override
    public UnitPoint3D getMinPoint() {
        return this.d_minPoint;
    }

    @Override
    public UnitPoint3D getMaxPoint() {
        return this.d_maxPoint;
    }

    public RefinementAmount getRefinementAmount() {
        return this.d_refinementAmount;
    }

    public void setRefinementAmount(RefinementAmount refinementAmount) {
        if (this.d_refinementAmount != refinementAmount) {
            this.d_refinementAmount = refinementAmount;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public String getFYI() {
        return this.d_description;
    }

    @Override
    public void setFYI(String fyi) {
        if (!this.d_description.equals(fyi)) {
            this.d_description = fyi;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public Color getColor() {
        return this.d_color;
    }

    @Override
    public void setColor(Color color) {
        Color newColor;
        Color color2 = newColor = color != null ? new Color(color.getRed(), color.getGreen(), color.getBlue(), DEF_COLOR.getAlpha()) : null;
        if (!Objects.equals(this.d_color, newColor)) {
            this.d_color = newColor;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        recTypes.add("MESH");
    }

    @Override
    public void setCustomFDSProps(String recType, CustomFDSProps props) {
        if (!this.d_customProps.equals(props)) {
            this.d_customProps = props;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String recType) {
        return this.d_customProps;
    }

    @Override
    public Object clone() {
        GridRefinement clone = (GridRefinement)super.clone();
        clone.imprint(this);
        return clone;
    }

    @Override
    public GridRefinement getRestoreObject() {
        return (GridRefinement)this.clone();
    }

    @Override
    public void imprint(IGridObj refObject) {
        if (!(refObject instanceof GridRefinement)) {
            assert (false);
        } else {
            GridRefinement refRefinement = (GridRefinement)refObject;
            this.pauseUpdates(false);
            this.d_description = refRefinement.d_description;
            this.setName(refRefinement.getName());
            this.d_minPoint = refRefinement.d_minPoint;
            this.d_maxPoint = refRefinement.d_maxPoint;
            this.d_refinementAmount = refRefinement.d_refinementAmount;
            this.d_color = refRefinement.d_color;
            this.d_customProps = refRefinement.d_customProps;
            this.d_tags = refRefinement.d_tags;
            this.resumeUpdates();
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public String toString() {
        return String.format("GridRefinement[name=%s]", this.getName());
    }

    public static enum RefinementAmount {
        X2(Intl.intl("2x"), "", 2),
        X4(Intl.intl("4x"), "", 4);

        private String d_name;
        private String d_desc;
        private int d_cellMult;

        private RefinementAmount(String name, String desc, int multiplier) {
            this.d_name = name;
            this.d_desc = desc;
            this.d_cellMult = multiplier;
        }

        public String getName() {
            return this.d_name;
        }

        public String getDesc() {
            return this.d_desc;
        }

        public int getCellMultiplier() {
            return this.d_cellMult;
        }
    }
}

