/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import pyrosim.domain.Grid;
import pyrosim.io.fds.FDSRenderer;

public class GridProcessUtil {
    private Collection<Grid> d_grids;
    private final PREF d_optimizationLevel;
    private final PROC_COUNT d_processCount;
    private Map<Grid, Integer> d_gridToProcMap;
    private final FDSRenderer.RENDER_ORIGIN d_writeOrigin;

    public static PREF getPrefForString(String name) {
        for (PREF p : PREF.values()) {
            if (!name.equalsIgnoreCase(p.getPropName())) continue;
            return p;
        }
        return PREF.BASIC;
    }

    public static PROC_COUNT getProcCountForString(String name) {
        for (PROC_COUNT p : PROC_COUNT.values()) {
            if (!name.equals(p.getPropName())) continue;
            return p;
        }
        return PROC_COUNT.PER_CORE;
    }

    public GridProcessUtil(Collection<Grid> grids, PREF optimzationLevel, PROC_COUNT numProcs, FDSRenderer.RENDER_ORIGIN origin) {
        this.d_optimizationLevel = optimzationLevel;
        this.d_processCount = numProcs;
        this.d_writeOrigin = origin;
        this.d_grids = grids.stream().filter(g -> g.isEnabled()).collect(Collectors.toList());
        this.initializeLookup(optimzationLevel, numProcs);
    }

    @Nullable
    public Integer getMPI_PROCESS(Grid g) {
        return this.d_gridToProcMap.get(g);
    }

    @Nullable
    public Integer getNumThreads(Grid g) {
        if (this.d_gridToProcMap.containsKey(g)) {
            return 1;
        }
        return null;
    }

    private void initializeLookup(PREF level, PROC_COUNT processes) {
        int numCores;
        this.d_gridToProcMap = new HashMap<Grid, Integer>();
        if (!this.d_writeOrigin.equals((Object)FDSRenderer.RENDER_ORIGIN.RUN_FDS_MPI)) {
            return;
        }
        int numMeshes = this.d_grids.size();
        if (numMeshes < (numCores = this.getNumCores())) {
            return;
        }
        if (level.equals((Object)PREF.BASIC) && processes.equals((Object)PROC_COUNT.PER_CORE)) {
            Map<Integer, List<Grid>> schedule = GridProcessUtil.longestFirstSched(numCores, this.d_grids);
            for (Map.Entry<Integer, List<Grid>> entry : schedule.entrySet()) {
                Integer proc = entry.getKey();
                for (Grid g : entry.getValue()) {
                    this.d_gridToProcMap.put(g, proc);
                }
            }
        }
    }

    private static Map<Integer, List<Grid>> longestFirstSched(int n, Collection<Grid> jobs) {
        List jobsLongestFirst = jobs.stream().sorted((g1, g2) -> -Double.compare(GridProcessUtil.makespan(g1), GridProcessUtil.makespan(g2))).collect(Collectors.toList());
        HashMap<Integer, List<Grid>> result = new HashMap<Integer, List<Grid>>();
        for (int i = 0; i < n; ++i) {
            result.put(i, new ArrayList());
        }
        Comparator cmpMakespanMinFirst = (s1, s2) -> {
            double t1 = GridProcessUtil.makespan((Collection)result.get(s1));
            double t2 = GridProcessUtil.makespan((Collection)result.get(s2));
            return Double.compare(t1, t2);
        };
        ArrayList keysShortestMakespanFirst = new ArrayList(result.keySet());
        for (Grid job : jobsLongestFirst) {
            keysShortestMakespanFirst.sort(cmpMakespanMinFirst);
            Integer shortestSchedule = (Integer)keysShortestMakespanFirst.get(0);
            ((List)result.get(shortestSchedule)).add(job);
        }
        return result;
    }

    private static double makespan(Grid ... schedule) {
        return Arrays.stream(schedule).map(g -> g.getCellCount()).reduce(0, Integer::sum).intValue();
    }

    private static double makespan(Collection<Grid> schedule) {
        return GridProcessUtil.makespan(schedule.toArray(new Grid[schedule.size()]));
    }

    private int getNumCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static enum PREF {
        NONE("None"),
        BASIC("Basic");

        private final String propName;

        private PREF(String propName) {
            this.propName = propName;
        }

        public String getPropName() {
            return this.propName;
        }
    }

    public static enum PROC_COUNT {
        ONE_PROC("oneProc"),
        PER_MESH("perMesh"),
        PER_CORE("perCore");

        private final String propName;

        private PROC_COUNT(String propName) {
            this.propName = propName;
        }

        public String getPropName() {
            return this.propName;
        }
    }
}

