/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxf;
import thunderheadeng.geometry.RTreef;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theTimer;

public class GeomLocator {
    private static final Logger LOGGER = Logger.getLogger(GeomLocator.class.getSimpleName());
    private Set<IDisplayableGeomSrc> d_dirtyGeom = GeomLocator.newDirtySet();
    private final RTreef<IDisplayableGeomSrc> d_finite = new RTreef(2, 16);
    private final Set<IDisplayableGeomSrc> d_infinite = new LinkedIdentityHashSet<IDisplayableGeomSrc>();

    private static Set<IDisplayableGeomSrc> newDirtySet() {
        return new LinkedIdentityHashSet<IDisplayableGeomSrc>();
    }

    public void add(IDisplayableGeomSrc geom) {
        this.d_dirtyGeom.add(geom);
    }

    public void remove(IDisplayableGeomSrc geom) {
        this.d_finite.remove(geom);
        this.d_infinite.remove(geom);
        this.d_dirtyGeom.remove(geom);
    }

    public void update(IDisplayableGeomSrc geom) {
        this.d_dirtyGeom.add(geom);
    }

    public synchronized void updateDirty() {
        if (this.d_dirtyGeom.isEmpty()) {
            return;
        }
        theTimer timer = new theTimer();
        for (IDisplayableGeomSrc geom : this.d_dirtyGeom) {
            this.removeGeometry(geom);
            this.addGeometry(geom);
        }
        this.d_dirtyGeom = GeomLocator.newDirtySet();
        LOGGER.log(Level.FINE, () -> String.format("updated geom search %g s", timer.curr()));
    }

    private void addGeometry(IDisplayableGeomSrc geom) {
        AABox bounds = geom.getBounds();
        if (bounds.isInfinite()) {
            this.d_infinite.add(geom);
        } else {
            if (!bounds.isValid()) {
                return;
            }
            AABoxf boundsFloat = bounds.toAABoxf();
            if (boundsFloat.isInfinite()) {
                LOGGER.log(Level.WARNING, () -> String.format("GeomLocator.addGeometry(geom=%s) - Error: double-precision bounding box can't fit into float.%n", geom));
                return;
            }
            this.d_finite.insert(boundsFloat, geom);
        }
    }

    private boolean removeGeometry(IDisplayableGeomSrc geom) {
        this.d_finite.remove(geom);
        this.d_infinite.remove(geom);
        return true;
    }

    public void find(ITest<AABox> tester, IResult<? super IDisplayableGeomSrc> result, boolean includeInvisible, boolean includeFinite) {
        ITest<AABoxf> testConverter = AABox.toAABoxfTest(tester);
        this.findf(testConverter, result, includeInvisible, includeFinite);
    }

    public void findf(ITest<AABoxf> tester, IResult<? super IDisplayableGeomSrc> result, boolean includeInvisible, boolean includeFinite) {
        this.updateDirty();
        if (includeFinite) {
            this.find(tester, result, this.d_finite, includeInvisible);
        }
        this.find(result, this.d_infinite, includeInvisible);
    }

    private void find(ITest<AABoxf> test, final IResult<? super IDisplayableGeomSrc> result, RTreef<IDisplayableGeomSrc> finiteGeom, boolean includeInvisible) {
        IResult<IDisplayableGeomSrc> res = result;
        if (!includeInvisible) {
            res = new IResult<IDisplayableGeomSrc>(){

                @Override
                public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                    if (!obj.isVisible()) {
                        return;
                    }
                    result.mark(obj, ctmt);
                }
            };
        }
        finiteGeom.find(test, res);
    }

    private void find(IResult<? super IDisplayableGeomSrc> result, Set<IDisplayableGeomSrc> infiniteGeom, boolean includeInvisible) {
        for (IDisplayableGeomSrc geom : infiniteGeom) {
            if (!includeInvisible && !geom.isVisible()) continue;
            result.mark(geom, Containment.INTERSECTS);
        }
    }

    public static class Collector<T extends IDisplayableGeomSrc>
    extends CollResult<IDisplayableGeomSrc, T> {
        public Collector(Class<T> type) {
            this(type, Filters.acceptAll(type));
        }

        public Collector(Class<T> type, Predicate<T> filter) {
            super(type, filter);
        }
    }
}

