/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.Floor;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.tasks.AReplaceRefTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public class FloorManager
extends Composite<Floor>
implements Serializable,
IDirectDependent {
    private static final long serialVersionUID = 1L;
    public static final Object EVT_ACTIVE_FLOOR_CHANGED = new Object();
    private Floor d_activeFloor;

    public FloorManager() {
        this(Intl.intl("Floors"));
    }

    public FloorManager(String name) {
        super(name, Floor.class);
    }

    public void addDefaults() {
        this.addDefault(new Floor(Intl.intl("Default")));
    }

    public Floor getActive() {
        return this.d_activeFloor;
    }

    public void setActive(Floor floor) {
        if (floor == this.d_activeFloor) {
            return;
        }
        this.pauseUpdates();
        if (this.d_activeFloor != null) {
            this.d_activeFloor.changedEvt(EVT_ACTIVE_FLOOR_CHANGED);
        }
        this.d_activeFloor = floor;
        if (this.d_activeFloor != null) {
            this.d_activeFloor.changedEvt(EVT_ACTIVE_FLOOR_CHANGED);
        }
        this.changedEvt(EVT_ACTIVE_FLOOR_CHANGED);
        this.resumeUpdates();
    }

    public Task taskSetActive(Floor floor) {
        Floor oldFloor = this.getActive();
        Floor newFloor = floor;
        return new AReplaceRefTask<Floor>((Object)oldFloor, (Object)newFloor){

            @Override
            protected void set(Floor obj) {
                FloorManager.this.setActive(obj);
            }
        };
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, (IPyroObject)this.d_activeFloor);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (this.d_activeFloor != old) {
            return null;
        }
        return this.taskSetActive((Floor)replacement);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }
}

