/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.reaction.Reaction;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.io.fds.v6.PredefSpeciesLoader;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Task;

public class ExSpecList
extends Composite<ExSpec> {
    static final long serialVersionUID = 1L;
    public static final String[] RADCAL_SPECS;
    public static final Map<String, ExSpec> PREDEFINED;
    public static final List<String> LUMPED_AIR_COMPS;
    public static final List<String> LUMPED_PRODUCT_COMPS;
    @Deprecated
    private Collection<String> d_reacDefAlias = new ArrayList<String>();
    public static final String RC_CARBON_DIOXIDE = "CARBON DIOXIDE";
    public static final String RC_CARBON_MONOXIDE = "CARBON_MONOXIDE";
    public static final String RC_ETHANE = "ETHANE";
    public static final String RC_ETHYLENE = "ETHYLENE";
    public static final String RC_MMA = "MMA";
    public static final String RC_METHANE = "METHANE";
    public static final String RC_METHANOL = "METHANOL";
    public static final String RC_N_HEPTANE = "N-HEPTANE";
    public static final String RC_PROPANE = "PROPANE";
    public static final String RC_PROPYLENE = "PROPYLENE";
    public static final String RC_SOOT = "SOOT";
    public static final String RC_TOLUENE = "TOLUENE";
    public static final String RC_WATER_VAPOR = "WATER VAPOR";

    public ExSpecList() {
        this(Intl.intl("Species"));
    }

    public ExSpecList(String name) {
        super(name, ExSpec.class);
    }

    public static void reloadPredefinedSpecies() {
        PREDEFINED.clear();
        for (Predefined predef : Predefined.values()) {
            PREDEFINED.put(predef.spec.getName(), predef.spec);
        }
        for (ExSpec specFromTable : PredefSpeciesLoader.getSpecies()) {
            PREDEFINED.putIfAbsent(specFromTable.getName(), specFromTable);
        }
    }

    public List<String> getPredefinedSpeciesNamesFree() {
        ArrayList<String> names = new ArrayList<String>(PREDEFINED.keySet());
        for (ExSpec es : this.flatten()) {
            String name = es.getName();
            if (!names.contains(name)) continue;
            names.remove(name);
        }
        Collections.sort(names);
        return names;
    }

    public static boolean isPredefinedSpecies(String id) {
        return PREDEFINED.containsKey(id);
    }

    public static boolean equalsPredefinedSpecies(ExSpec spec) {
        if (!ExSpecList.isPredefinedSpecies(spec.getName())) {
            return false;
        }
        ExSpec predefSpec = ExSpecList.getPredefinedSpecies(spec.getName());
        return spec.getMolecularWeight().equals(predefSpec.getMolecularWeight()) && spec.getMassFrac0() == predefSpec.getMassFrac0() && spec.getPrimParams().equals(predefSpec.getPrimParams()) && spec.getCustomFDSProps().equals(predefSpec.getCustomFDSProps());
    }

    public static boolean isImplicitSpecies(String id) {
        return id.equals("AIR") || id.equals("PRODUCTS") || LUMPED_AIR_COMPS.contains(id) || LUMPED_PRODUCT_COMPS.contains(id);
    }

    public static ExSpec getPredefinedSpecies(String id) {
        assert (ExSpecList.isPredefinedSpecies(id));
        return PREDEFINED.get(id);
    }

    public static String[] getRadCalSurrogates() {
        return RADCAL_SPECS;
    }

    public static boolean isRadCalSpecies(String id) {
        for (String spec : RADCAL_SPECS) {
            if (!id.equals(spec)) continue;
            return true;
        }
        return false;
    }

    public List<ExSpec> getAllNamedSpecs() {
        ArrayList<ExSpec> specs = new ArrayList<ExSpec>(this.flatten());
        for (ExSpec predefSpec : PREDEFINED.values()) {
            if (specs.contains(predefSpec)) continue;
            specs.add(predefSpec);
        }
        return specs;
    }

    @Deprecated
    public ExSpec getDefaultFuel() {
        for (ExSpec spec : this.flatten()) {
            if (spec.getType() != 4) continue;
            return spec;
        }
        return null;
    }

    public ExSpec generateFuelForReaction(Reaction reac, boolean addToMgr) {
        String fuelName = reac.getName() + Intl.intl("_fuel");
        return this.generateFuelForReaction(reac, fuelName, addToMgr);
    }

    public ExSpec generateFuelForReaction(Reaction reac, String specName, boolean addToMgr) {
        ExSpec fuelSpecies = new ExSpec(specName, 4);
        fuelSpecies.setReactionForFuel(reac);
        reac.setFuel(fuelSpecies);
        if (addToMgr) {
            this.add(fuelSpecies);
        }
        return fuelSpecies;
    }

    public ExSpec generateFuelForReactionName(String reacName) {
        String fuelName = reacName + Intl.intl("_fuel");
        ExSpec fuelSpecies = new ExSpec(fuelName, 4);
        this.add(fuelSpecies);
        return fuelSpecies;
    }

    public ExSpec generateFuelPrescribedName(String specName) {
        ExSpec fuelSpecies = new ExSpec(specName, 4);
        this.add(fuelSpecies);
        return fuelSpecies;
    }

    @Override
    public ExSpec get(String name) {
        ExSpec spec = (ExSpec)super.get(name);
        if (spec == null && this.isReacDefaultAlias(name)) {
            return ExSpecList.getDefaultFuel(true);
        }
        return spec;
    }

    public void addDefaults() {
        this.addImplicitSpecs();
    }

    public Collection<ExSpec> getInitialFractions() {
        ArrayList<ExSpec> initSpecs = new ArrayList<ExSpec>();
        for (ExSpec spec : this.flatten()) {
            if (!(spec.getMassFrac0() > 0.0)) continue;
            initSpecs.add(spec);
        }
        return initSpecs;
    }

    public void addImplicitSpecs() {
        this.addAirSpecs();
        this.addProductSpecs();
    }

    public void addAirSpecs() {
        this.addDefault(new ExSpec(ExSpecList.getPredefinedSpecies("AIR")));
        for (String specName : LUMPED_AIR_COMPS) {
            this.addDefault(new ExSpec(ExSpecList.getPredefinedSpecies(specName)));
        }
    }

    public void addProductSpecs() {
        this.addDefault(new ExSpec(ExSpecList.getPredefinedSpecies("PRODUCTS")));
        for (String specName : LUMPED_PRODUCT_COMPS) {
            this.addDefault(new ExSpec(ExSpecList.getPredefinedSpecies(specName)));
        }
    }

    @Override
    public <T extends IPyroObject> T find(String name, Class<T> type, boolean deep) {
        T spec = super.find(name, type, deep);
        if (spec == null && type.isAssignableFrom(ExSpec.class) && this.isReacDefaultAlias(name)) {
            return (T)ExSpecList.getDefaultFuel(false);
        }
        return spec;
    }

    public Task taskSetBackgroundSpecies(final ExSpec spec) {
        final ExSpec background = this.getBackgroundSpecies();
        return new AUndoableTask(){

            @Override
            public void undo() {
                ExSpecList.this.pauseUpdates();
                if (spec != null) {
                    spec.setIsBackgroundSpec(false);
                }
                if (background != null) {
                    background.setIsBackgroundSpec(true);
                }
                ExSpecList.this.resumeUpdates();
            }

            @Override
            public void run() {
                ExSpecList.this.pauseUpdates();
                if (background != null) {
                    background.setIsBackgroundSpec(false);
                }
                if (spec != null) {
                    spec.setIsBackgroundSpec(true);
                }
                ExSpecList.this.resumeUpdates();
            }
        };
    }

    public ExSpec getBackgroundSpecies() {
        for (ExSpec spec : this.flatten()) {
            if (!spec.isBackgroundSpec()) continue;
            return spec;
        }
        return null;
    }

    public void setBackgroundSpecies(ExSpec spec) {
        ExSpec background = this.getBackgroundSpecies();
        if (background != null) {
            background.setIsBackgroundSpec(false);
        }
        if (spec != null) {
            spec.setIsBackgroundSpec(true);
        }
    }

    @Deprecated
    public static ExSpec getDefaultFuel(boolean addToDomain) {
        PyroMod pyMod = PyroSim.getApp().getMediator();
        return ExSpecList.getDefaultFuel(pyMod.getExSpecList(), pyMod.getNames(ExSpec.class), addToDomain);
    }

    @Deprecated
    public static ExSpec getDefaultFuel(ExSpecList specList, NameGenerator ng, boolean addToDomain) {
        if (specList.getDefaultFuel() != null) {
            return specList.getDefaultFuel();
        }
        String fuelName = "REAC_FUEL";
        fuelName = ng.generateValidName(fuelName);
        ExSpec reacFuel = new ExSpec(fuelName, 4);
        if (addToDomain) {
            specList.add(reacFuel);
            specList.setReacDefaultAlias(fuelName);
        }
        return reacFuel;
    }

    @Deprecated
    public void setReacDefaultAlias(String str) {
        this.d_reacDefAlias.add(str);
    }

    @Deprecated
    public boolean isReacDefaultAlias(String str) {
        return this.d_reacDefAlias.contains(str);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (this.d_reacDefAlias == null) {
            this.d_reacDefAlias = new ArrayList<String>();
            this.d_reacDefAlias.add("REAC_FUEL");
        }
        if (in instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)in).getVersion() < 141) {
            this.addDefaults();
        }
        in.defaultReadObject();
    }

    static {
        PREDEFINED = new LinkedHashMap<String, ExSpec>();
        RADCAL_SPECS = new String[]{RC_CARBON_DIOXIDE, RC_CARBON_MONOXIDE, RC_ETHANE, RC_ETHYLENE, RC_MMA, RC_METHANE, RC_METHANOL, RC_N_HEPTANE, RC_PROPANE, RC_PROPYLENE, RC_SOOT, RC_TOLUENE, RC_WATER_VAPOR};
        LUMPED_AIR_COMPS = new ArrayList<String>();
        LUMPED_AIR_COMPS.add("NITROGEN");
        LUMPED_AIR_COMPS.add("OXYGEN");
        LUMPED_AIR_COMPS.add(RC_CARBON_DIOXIDE);
        LUMPED_AIR_COMPS.add(RC_WATER_VAPOR);
        LUMPED_PRODUCT_COMPS = new ArrayList<String>();
        LUMPED_PRODUCT_COMPS.add(RC_CARBON_DIOXIDE);
        LUMPED_PRODUCT_COMPS.add(RC_WATER_VAPOR);
        LUMPED_PRODUCT_COMPS.add("CARBON MONOXIDE");
        LUMPED_PRODUCT_COMPS.add(RC_SOOT);
        LUMPED_PRODUCT_COMPS.add("NITROGEN");
        LUMPED_PRODUCT_COMPS.add("HYDROGEN CYANIDE");
        ExSpecList.reloadPredefinedSpecies();
    }

    public static enum Predefined {
        AIR("AIR", "air"),
        PRODUCTS("PRODUCTS", "products"),
        CARBON_DIOXIDE("CARBON DIOXIDE", "CO2"),
        CARBON_MONOXIDE("CARBON MONOXIDE", "CO"),
        HYDROGEN_CYANIDE("HYDROGEN CYANIDE", "HCN"),
        NITROGEN("NITROGEN", "N2"),
        OXYGEN("OXYGEN", "O2"),
        SOOT("SOOT", "C"),
        WATER_VAPOR("WATER VAPOR", "H2O");

        private final ExSpec spec;

        private Predefined(String id, String formula) {
            this.spec = new ExSpec(id, 0);
            if (id.equals("AIR") || id.equals("PRODUCTS")) {
                this.spec.setType(5);
            } else {
                this.spec.setChemFormula(formula);
            }
        }

        public String getName() {
            return this.spec.getName();
        }
    }
}

