/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.geom.IGeomSource;
import pyrosim.io.PyroSimObjectInputStream;
import thunderheadeng.gui.ADomainObject;
import thunderheadeng.util.ResultsIdGen;
import thunderheadeng.util.theUtil;

public abstract class APyroObject
extends ADomainObject<PyroMod>
implements IPyroObject {
    static final long serialVersionUID = 1L;
    private long d_resultsId = -1L;
    @SkipDep
    private transient IPyroObject d_parent = null;
    private boolean d_enabled = true;

    public APyroObject() {
        this.generateResultsIds();
    }

    public void generateResultsIds(ResultsIdGen ids) {
        this.d_resultsId = ids.nextId();
    }

    protected void generateResultsIds() {
        this.generateResultsIds(ResultsIdGen.INSTANCE);
    }

    public void setResultsId(long id) {
        this.d_resultsId = id;
    }

    @Override
    public Object clone() {
        APyroObject obj = (APyroObject)super.clone();
        obj.d_parent = null;
        obj.generateResultsIds();
        return obj;
    }

    @Override
    public long getResultsId() {
        return this.d_resultsId;
    }

    protected void removeFromDomain(PyroMod domain) {
        for (IPyroObject iPyroObject : this.getMembers()) {
            iPyroObject.setDomain(null, null);
        }
        if (this instanceof IGeomSource) {
            IGeomSource gsrc = (IGeomSource)((Object)this);
            domain.getGeomLocator().remove(gsrc);
            if (gsrc.registerProximity()) {
                domain.getGeomProx().remove(gsrc);
            }
        }
        if (this instanceof INamed) {
            domain.getNames(this).unregisterName(((INamed)((Object)this)).getName());
        }
        this.removedEvt((Object)this);
        this.d_parent = null;
    }

    protected void addToDomain(PyroMod domain, IPyroObject parent) {
        this.d_parent = parent;
        this.addedEvt((Object)this);
        if (this instanceof INamed) {
            domain.getNames(this).registerName(((INamed)((Object)this)).getName());
        }
        if (this instanceof IGeomSource) {
            IGeomSource gsrc = (IGeomSource)((Object)this);
            domain.getGeomLocator().add(gsrc);
            if (gsrc.registerProximity()) {
                domain.getGeomProx().add(gsrc);
            }
        }
        for (IPyroObject iPyroObject : this.getMembers()) {
            iPyroObject.setDomain(domain, this);
        }
    }

    @Override
    @Deprecated
    public void setDomain(PyroMod owner) {
        super.setDomain(owner);
    }

    @Override
    public void setDomain(PyroMod domain, IPyroObject parent) {
        if (this.getDomain() == domain) {
            return;
        }
        if (this.getDomain() != null) {
            this.pauseUpdates();
            this.removeFromDomain((PyroMod)this.getDomain());
            this.resumeUpdates();
        }
        super.setDomain(domain);
        if (domain != null) {
            this.pauseUpdates();
            this.addToDomain((PyroMod)this.getDomain(), parent);
            this.resumeUpdates();
        }
    }

    @Override
    public IPyroObject getParent() {
        return this.d_parent;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.d_enabled == enabled) {
            return;
        }
        this.d_enabled = enabled;
        if (this.getDomain() != null) {
            this.changedEvt(PyroMod.EVT_ENABLED_CHANGED);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.d_enabled;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_enabled = true;
        in.defaultReadObject();
        if (PyroSimObjectInputStream.getResetResultsId(in)) {
            this.generateResultsIds();
        }
    }

    @Override
    public boolean changedEvt(Object ... changes) {
        this.pauseUpdates();
        IPyroObject parent = this.getParent();
        if (parent instanceof Composite && !APyroObject.changesExclusiveTo(changes, PyroMod.EVT_SEL)) {
            parent.changedEvt(new Object[0]);
        }
        if (this.getDomain() != null && this instanceof IGeomSource && ((PyroMod)this.getDomain()).isListening() && !APyroObject.changesExclusiveTo(changes, PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED, PyroMod.EVT_APPEARANCE, PyroMod.EVT_PARENT_CHANGED)) {
            IGeomSource gsrc = (IGeomSource)((Object)this);
            ((PyroMod)this.getDomain()).getGeomLocator().update(gsrc);
            if (gsrc.registerProximity()) {
                ((PyroMod)this.getDomain()).getGeomProx().update(gsrc);
            }
        }
        boolean result = super.changedEvt(changes);
        this.resumeUpdates();
        return result;
    }

    protected static boolean changesExclusiveTo(Object[] changeList, Object ... changes) {
        if (changeList.length == 0) {
            return false;
        }
        for (Object c1 : changeList) {
            boolean found = false;
            for (Object c2 : changes) {
                if (c1 != c2) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<? extends IPyroObject> getMembers() {
        return Collections.EMPTY_LIST;
    }

    public <T> Collection<T> getMembers(Class<T> type) {
        return theUtil.filter(this.getMembers(), type);
    }

    public <T> Collection<T> getMembers(Class<T> type, Predicate<? super T> filter) {
        return theUtil.filter(this.getMembers(), type, filter);
    }

    public <T> Collection<T> flatten(Class<T> type) {
        return Hierarchy.flatten(this.getMembers(), type);
    }

    public <T> Collection<T> flatten(Class<T> type, Predicate<? super T> filter) {
        return Hierarchy.flatten(this.getMembers(), type, filter);
    }
}

