/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.util;

import java.util.Collection;
import java.util.LinkedHashSet;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitPoint3D;

public class GeomUtil {
    public static IDOF getDOF(Collection<? extends IMutableGeomSrc> geoms) {
        LinkedHashSet<IDOF> dofs = new LinkedHashSet<IDOF>();
        for (IMutableGeomSrc iMutableGeomSrc : geoms) {
            dofs.add(iMutableGeomSrc.getGeom().getDOF());
        }
        return IDOF.group(dofs);
    }

    public static AABox getBounds(Collection<? extends IPyroGeomSrc> objects) {
        AABox bb = new AABox();
        for (IPyroGeomSrc iPyroGeomSrc : objects) {
            iPyroGeomSrc.getGeom().getBoundingBox(bb);
        }
        return bb;
    }

    public static UnitAABox getUnitBounds(Collection<? extends IPyroGeomSrc> objects) {
        AABox bb = GeomUtil.getBounds(objects);
        return new UnitAABox(bb, Geometry.LU);
    }

    public static UnitPoint3D getCenter(Collection<? extends IPyroGeomSrc> objects) {
        Unit lu = Geometry.LU;
        AABox bb = GeomUtil.getBounds(objects);
        Point3d min = bb.getMin();
        Point3d max = bb.getMax();
        min.add(max);
        min.scale(0.5);
        return new UnitPoint3D(min, lu);
    }

    public static boolean isAligned(IDOF dof) {
        return IDOF.isAligned(dof);
    }
}

