/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.recordview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.PyroSimColors;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSPrintRenderer;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.io.fds.SyntaxMap;
import pyrosim.io.fds.v6.renderers.FDS6Renderer;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.colorscheme.ColorChangedEvent;
import thunderheadeng.gui.colorscheme.ColorChangedListener;
import thunderheadeng.gui.colorscheme.ColorScheme;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiToolBar;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class RecordView
extends guiPanel
implements IEventObserver,
ColorChangedListener {
    private static final long serialVersionUID = 5094944977612462311L;
    final int LARGE_FILE_SIZE = 200000;
    private PyroMod d_mediator;
    private JTextPane d_unproc;
    private JTextComponent d_proc;
    private TextPaneWithLineNumbers d_lineNos;
    private JScrollPane d_procScroller;
    private JScrollPane d_unprocScroller;
    private JSplitPane d_splitter;
    private boolean d_modified;
    private boolean d_dirty;
    private boolean d_selDirty;
    private boolean d_renderingRecords = false;
    private Map<IPyroObject, ObjDisp> d_displays;
    private ArrayList<ObjDisp> d_displayList;
    private ArrayList<ObjDisp> d_selDisplays;
    Style d_keyWordStyle;
    Style d_specCharStyle;
    Style d_referenceStyle;
    Style d_valueStyle;
    Style d_commentStyle;

    public RecordView(PyroMod mediator) {
        guiAction[] removeAccelActions;
        this.d_mediator = mediator;
        this.d_displays = Collections.EMPTY_MAP;
        this.d_displayList = new ArrayList(0);
        this.d_selDisplays = this.d_displayList;
        this.d_dirty = true;
        this.d_selDirty = true;
        this.d_mediator.getEvents().addObserver(this);
        guiPanel top = new guiPanel();
        top.setLayout(new BorderLayout());
        JLabel recLbl = new JLabel(Intl.intl("Model Records (Read-Only)") + ":");
        recLbl.setBorder(new EmptyBorder(0, 4, 0, 4));
        top.add((Component)recLbl, "North");
        this.generateProc(true, top);
        guiPanel bottom = new guiPanel();
        JLabel addRecLbl = new JLabel(Intl.intl("Additional Records:"));
        addRecLbl.setBorder(new EmptyBorder(0, 4, 0, 4));
        bottom.setLayout(new BorderLayout());
        bottom.add((Component)addRecLbl, "North");
        this.d_unproc = new UnprocessedPane();
        this.d_unproc.setFont(this.d_proc.getFont());
        this.d_unproc.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.recsModified();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.recsModified();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.recsModified();
            }

            private void recsModified() {
                RecordView.this.d_modified = true;
            }
        });
        this.d_unproc.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (RecordView.this.d_modified && !e.isTemporary()) {
                    RecordView.this.applyChanges();
                    RecordView.this.d_modified = false;
                }
            }
        });
        JPopupMenu unprocPopup = new JPopupMenu();
        Consumer<UnprocAction> actionBuilder = action -> {
            JMenuItem menu = new JMenuItem(this.d_unproc.getActionMap().get(action.lookupStr));
            menu.setText(action.displayStr);
            unprocPopup.add(menu);
        };
        actionBuilder.accept(UnprocAction.CUT);
        actionBuilder.accept(UnprocAction.COPY);
        actionBuilder.accept(UnprocAction.PASTE);
        unprocPopup.addSeparator();
        actionBuilder.accept(UnprocAction.SELECTALL);
        this.d_unproc.setComponentPopupMenu(unprocPopup);
        this.d_unprocScroller = new JScrollPane(this.d_unproc);
        bottom.add((Component)this.d_unprocScroller, "Center");
        this.d_splitter = new JSplitPane(0, true, top, bottom);
        this.setLayout(new BorderLayout());
        this.d_splitter.setResizeWeight(0.75);
        this.updateFontSizes(null);
        guiToolBar tools = new guiToolBar();
        tools.setFloatable(false);
        tools.add(new FontBiggerAction());
        tools.add(new FontSmallerAction());
        Utils.noToolBarFocus(tools);
        this.add((Component)tools, "North");
        this.add((Component)this.d_splitter, "Center");
        for (guiAction removeAccelAction : removeAccelActions = new guiAction[]{Actions.getDeleteAction(), Actions.getPasteAction(), Actions.getCutAction(), Actions.getCopyAction()}) {
            for (KeyStroke accel : removeAccelAction.getAccelerators()) {
                this.d_proc.getInputMap().put(accel, "none");
            }
        }
    }

    public JTextComponent getModelRecords() {
        return this.d_proc;
    }

    @Override
    public void colorChanged(ColorChangedEvent e) {
        this.updateColors();
        ((TextPane)((Object)this.d_proc)).updateSyntax();
    }

    private void updateFontSizes(Font baseFont) {
        float fontSize = 12.0f;
        PyroSim pySim = PyroSim.getApp();
        if (pySim != null) {
            fontSize = PyroPrefs.getFloat(PyroPrefs.RECORD_VIEW_FONTSIZE);
        }
        if (baseFont == null) {
            Font[] allFonts;
            GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (Font f : allFonts = e.getAllFonts()) {
                if (!f.getFamily().equals("Consolas")) continue;
                baseFont = f.deriveFont(0, 12.0f);
                break;
            }
            if (baseFont == null) {
                baseFont = new Font("monospaced", 0, 12);
            }
        }
        Font displayFont = baseFont.deriveFont(fontSize);
        this.d_proc.setFont(displayFont);
        this.d_unproc.setFont(displayFont);
        this.d_lineNos.setFont(displayFont);
    }

    private StyledDocument createStyledDocument() {
        DefaultStyledDocument sdoc = new DefaultStyledDocument();
        this.d_keyWordStyle = sdoc.addStyle("SYMBOL_KEYWORD", null);
        this.d_specCharStyle = sdoc.addStyle("SYMBOL_SPECIAL", null);
        this.d_referenceStyle = sdoc.addStyle("SYMBOL_REFERENCE", null);
        this.d_valueStyle = sdoc.addStyle("SYMBOL_VALUE", null);
        this.d_commentStyle = sdoc.addStyle("SYMBOL_COMMENT", null);
        sdoc.addStyle("SYMBOL_EMPTY", null);
        this.updateStyles();
        return sdoc;
    }

    private void updateStyles() {
        ColorScheme cs = PyroSim.getApp().getColorScheme();
        String lafName = UIManager.getLookAndFeel().getName();
        if (lafName.equals("FlatLaf Dark") || lafName.equals("FlatLaf Darcula")) {
            StyleConstants.setForeground(this.d_keyWordStyle, cs.getColor(PyroSimColors.FDS_KEYWORD_COLOR_DARK));
            StyleConstants.setForeground(this.d_specCharStyle, cs.getColor(PyroSimColors.FDS_SPECIAL_COLOR_DARK));
            StyleConstants.setForeground(this.d_referenceStyle, cs.getColor(PyroSimColors.FDS_REFERENCE_COLOR_DARK));
            StyleConstants.setForeground(this.d_valueStyle, cs.getColor(PyroSimColors.FDS_VALUE_COLOR_DARK));
            StyleConstants.setForeground(this.d_commentStyle, cs.getColor(PyroSimColors.FDS_COMMENT_COLOR_DARK));
        } else {
            StyleConstants.setForeground(this.d_keyWordStyle, cs.getColor(PyroSimColors.FDS_KEYWORD_COLOR));
            StyleConstants.setForeground(this.d_specCharStyle, cs.getColor(PyroSimColors.FDS_SPECIAL_COLOR));
            StyleConstants.setForeground(this.d_referenceStyle, cs.getColor(PyroSimColors.FDS_REFERENCE_COLOR));
            StyleConstants.setForeground(this.d_valueStyle, cs.getColor(PyroSimColors.FDS_VALUE_COLOR));
            StyleConstants.setForeground(this.d_commentStyle, cs.getColor(PyroSimColors.FDS_COMMENT_COLOR));
        }
        StyleConstants.setBold(this.d_keyWordStyle, true);
        StyleConstants.setBold(this.d_specCharStyle, true);
        StyleConstants.setBold(this.d_referenceStyle, true);
        StyleConstants.setItalic(this.d_commentStyle, true);
    }

    private void updateColors() {
        this.updateStyles();
        if (this.d_proc != null) {
            ((TextPane)((Object)this.d_proc)).updateSyntax();
        }
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
    }

    public void applyChanges() {
        if (!this.d_dirty) {
            this.d_mediator.setUnprocessedRecords(this.d_unproc.getText());
        }
    }

    @Override
    public void paint(Graphics g) {
        this.updateText(true);
        this.updateTextSel();
        super.paint(g);
    }

    @Override
    public void update(Events events) {
        if (this.d_renderingRecords) {
            return;
        }
        this.d_renderingRecords = true;
        boolean changed = false;
        boolean updateSel = false;
        IEventRecord<PyroMod> pevts = events.getEvents(PyroMod.class, new Class[0]);
        changed |= pevts.containsChange(PyroMod.EVT_MODEL_CHANGED) || pevts.containsChange(PyroMod.EVT_UNPROC_RECS_CHANGED) || pevts.containsChange(PyroMod.EVT_FDS_EVAC_CHANGED) || pevts.containsChange(PyroMod.EVT_RAST_PROPS) || pevts.containsChange(PyroMod.EVT_PREFS_CHANGED) || pevts.containsChange(PyroMod.EVT_FILENAME_CHANGED);
        IEventRecord<Object> oevts = events.getEvents(Object.class, PyroMod.class);
        updateSel |= oevts.isModified();
        if ((changed |= oevts.isModified() && (!oevts.areChangesOnly() || !oevts.areChangesExclusiveTo(PyroMod.EVT_SEL))) && pevts.containsChange(PyroMod.EVT_PREFS_CHANGED)) {
            this.updateFontSizes(this.d_proc.getFont());
        }
        this.d_dirty |= changed;
        this.d_selDirty |= changed | updateSel;
        if (this.d_dirty) {
            this.clearCache();
        }
        this.repaint();
        this.d_renderingRecords = false;
    }

    private void clearCache() {
        boolean modified = this.d_displayList.size() > 0 || this.d_proc.getDocument().getLength() > 0;
        this.d_displayList = new ArrayList(0);
        this.d_selDisplays = this.d_displayList;
        this.d_displays = Collections.EMPTY_MAP;
        this.d_proc.setDocument(this.createStyledDocument());
        if (modified) {
            SwingUtilities.invokeLater(() -> System.gc());
        }
    }

    private void updateText(boolean updateUnproc) {
        if (this.d_renderingRecords) {
            return;
        }
        if (!this.d_dirty) {
            return;
        }
        this.d_renderingRecords = true;
        this.d_displayList = new ArrayList();
        this.d_displays = new IdentityHashMap<IPyroObject, ObjDisp>();
        int pos = this.d_procScroller.getVerticalScrollBar().getValue();
        FDS6Renderer writer = (FDS6Renderer)FDS.newRenderer(this.d_mediator, PyroSim.getFdsRenderPropsNullSafe(), FDSRenderer.RENDER_ORIGIN.DEFAULT);
        SyntaxMap sMap = ((TextPane)((Object)this.d_proc)).getSyntaxMap();
        sMap.clearSyntax();
        StyledDocument sdoc = this.createStyledDocument();
        PyroSim app = PyroSim.getApp();
        PyroMod pyMod = app.getMediator();
        Object filename = app.getFilename();
        if (filename == null) {
            filename = "untitled.fds";
        } else if (!((String)filename).endsWith(".fds")) {
            int idx = ((String)filename).lastIndexOf(".");
            if (idx == -1) {
                idx = ((String)filename).length();
            }
            filename = ((String)filename).substring(0, idx) + ".fds";
        }
        File fdsInputFile = new File((String)filename);
        String chid = FDSRenderer.generateChid(fdsInputFile.getName(), FDSRenderer.getDefaultScenarioNameForChid(pyMod.getScenarios()));
        FDSRenderer.Filenames fns = new FDSRenderer.Filenames(fdsInputFile.getParentFile(), chid);
        Collection<IPyroObject> allObjs = writer.collectPyroObjects();
        FDSRenderer.Prep fobjs = writer.prepareObjs(allObjs, PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEPYROGEOM), this.d_mediator.getUnprocessedRecords());
        try {
            Renderer render = new Renderer(writer.getProps(), sdoc, sMap, fobjs.splitObjs);
            writer.renderFileForVersion(fns, fobjs.objs, fobjs.deps, render, Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.d_displayList.trimToSize();
        if (sdoc.getLength() > 200000) {
            this.swapProc(false, (guiPanel)this.d_splitter.getTopComponent());
        } else {
            this.swapProc(true, (guiPanel)this.d_splitter.getTopComponent());
        }
        this.d_proc.setDocument(sdoc);
        SwingUtilities.invokeLater(() -> this.d_procScroller.getVerticalScrollBar().setValue(pos));
        if (updateUnproc) {
            this.d_unproc.setText(this.d_mediator.getUnprocessedRecords());
        }
        this.d_dirty = false;
        this.d_renderingRecords = false;
    }

    public void clearSelection() {
        if (this.d_selDisplays.size() > this.d_displayList.size() * 3 / 4) {
            ((TextPane)((Object)this.d_proc)).updateSyntax();
        } else {
            for (ObjDisp disp : this.d_selDisplays) {
                ((TextPane)((Object)this.d_proc)).updateSyntax(disp.i1, disp.i2);
            }
        }
    }

    public void select(int begin, int end) {
        this.d_proc.setCaretPosition(begin);
        this.d_proc.moveCaretPosition(end);
        this.d_proc.requestFocus();
    }

    private void updateTextSel() {
        if (this.d_renderingRecords) {
            return;
        }
        if (!this.d_selDirty) {
            return;
        }
        this.d_renderingRecords = true;
        Collection<IPyroObject> sel = this.d_mediator.getSelectionModel().flatten(IPyroObject.class);
        int oldCaret = this.d_proc.getCaretPosition();
        this.clearSelection();
        this.d_selDisplays = new ArrayList();
        for (IPyroObject obj : sel) {
            ObjDisp disp = this.d_displays.get(obj);
            if (disp == null) continue;
            this.select(disp.i1, disp.i2);
            this.d_selDisplays.add(disp);
        }
        this.d_selDisplays.trimToSize();
        if (this.d_selDisplays.size() > 0) {
            ObjDisp firstSel = this.d_selDisplays.get(0);
            this.d_proc.setCaretPosition(firstSel.i1);
            this.d_proc.moveCaretPosition(firstSel.i2);
        } else {
            this.d_proc.setCaretPosition(oldCaret);
            this.d_proc.moveCaretPosition(oldCaret);
        }
        this.d_selDirty = false;
        this.d_renderingRecords = false;
    }

    private void updateModelSel() {
        if (this.d_renderingRecords) {
            return;
        }
        this.d_renderingRecords = true;
        this.d_mediator.pauseUpdates();
        LinkedIdentityHashSet<IPyroObject> selection = new LinkedIdentityHashSet<IPyroObject>();
        int start = this.d_proc.getSelectionStart();
        int end = this.d_proc.getSelectionEnd();
        if (end >= start && !this.d_displayList.isEmpty()) {
            int beginix = this.getDisplayIndex(start);
            int endix = this.getDisplayIndex(end);
            for (int m = beginix; m <= endix; ++m) {
                ObjDisp disp = this.d_displayList.get(m);
                if (start > disp.i2 || end < disp.i1) continue;
                selection.add(disp.obj);
            }
        }
        this.d_mediator.getTaskManager().exec(new SelectTask(this.d_mediator, selection), Intl.intl("Select Records"));
        if (start == end) {
            this.d_renderingRecords = false;
            this.d_mediator.resumeUpdates();
        } else {
            this.d_mediator.resumeUpdates();
            this.d_renderingRecords = false;
        }
    }

    private int getDisplayIndex(int cursor) {
        ObjDisp tdisp = new ObjDisp(null, cursor, cursor);
        int ix = theUtil.binarySearch(this.d_displayList, tdisp, new Comparator<ObjDisp>(this){

            @Override
            public int compare(ObjDisp o1, ObjDisp o2) {
                return o1.i1 - o2.i1;
            }
        });
        if (ix < 0) {
            ix = -1 - ix;
        }
        if (ix > 0) {
            --ix;
        }
        return ix;
    }

    private ObjDisp getDisplay(int caretpos) {
        int ix = this.getDisplayIndex(caretpos);
        if (ix < 0 || ix >= this.d_displayList.size()) {
            return null;
        }
        ObjDisp disp = this.d_displayList.get(ix);
        return caretpos >= disp.i1 && caretpos <= disp.i2 ? disp : null;
    }

    private void setTextSize(float newSize) {
        if ((double)newSize < 1.0) {
            newSize = 1.0f;
        }
        if ((double)newSize > 36.0) {
            newSize = 36.0f;
        }
        try {
            PyroPrefs.set(PyroPrefs.RECORD_VIEW_FONTSIZE, Float.valueOf(newSize), true);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        this.updateFontSizes(this.d_proc.getFont());
    }

    private void swapProc(boolean rich, guiPanel top) {
        if (((TextPane)((Object)this.d_proc)).isRich() == rich) {
            return;
        }
        top.remove(1);
        if (!rich) {
            ((JLabel)top.getComponent(0)).setText("Model Records (Read-Only) (Large File Mode):");
        } else {
            ((JLabel)top.getComponent(0)).setText("Model Records (Read-Only):");
        }
        this.generateProc(rich, top);
        this.d_dirty = true;
    }

    private void generateProc(boolean rich, guiPanel top) {
        this.d_proc = null;
        this.d_proc = rich ? new RichTextPane(this.createStyledDocument(), new SyntaxMap()) : new BasicTextPane(this.createStyledDocument(), new SyntaxMap());
        this.d_proc.setEditable(false);
        this.d_proc.addCaretListener(e -> {
            if (this.d_renderingRecords) {
                return;
            }
            SwingUtilities.invokeLater(() -> this.updateModelSel());
        });
        this.d_proc.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    RecordView.this.clearSelection();
                }
            }
        });
        this.d_lineNos = new TextPaneWithLineNumbers(this.d_proc);
        this.d_procScroller = new JScrollPane(this.d_lineNos);
        this.d_procScroller.getViewport().setBackground(this.d_proc.getBackground());
        this.d_procScroller.addMouseWheelListener(e -> {
            if (e.isControlDown()) {
                this.setTextSize(this.d_proc.getFont().getSize() - e.getWheelRotation());
            }
        });
        top.add((Component)this.d_procScroller, "Center");
    }

    private static class UnprocessedPane
    extends JTextPane {
        private static final long serialVersionUID = 1L;

        public UnprocessedPane() {
            this.createMouseListener();
        }

        private void createMouseListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.requestFocusInWindow();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.requestFocusInWindow();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.requestFocusInWindow();
                }
            });
        }
    }

    private static enum UnprocAction {
        CUT(Intl.intl("Cut"), "cut-to-clipboard"),
        COPY(Intl.intl("Copy"), "copy-to-clipboard"),
        PASTE(Intl.intl("Paste"), "paste-from-clipboard"),
        SELECTALL(Intl.intl("Select All"), "select-all");

        private final String displayStr;
        private final String lookupStr;

        private UnprocAction(String displayStr, String lookupStr) {
            this.displayStr = displayStr;
            this.lookupStr = lookupStr;
        }
    }

    private class FontBiggerAction
    extends guiAction {
        private static final long serialVersionUID = 2157730166712308476L;

        public FontBiggerAction() {
            super(Intl.intl("Font Size Increase"), PyroGuiUtil.loadPyroSimIcon("font-bigger.png", 16));
            this.putValue("ShortDescription", Intl.intl("Font Size Increase"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RecordView.this.setTextSize(RecordView.this.d_proc.getFont().getSize() + 1);
        }
    }

    private class FontSmallerAction
    extends guiAction {
        private static final long serialVersionUID = 661777269162981666L;

        public FontSmallerAction() {
            super(Intl.intl("Font Size Decrease"), PyroGuiUtil.loadPyroSimIcon("font-smaller.png", 16));
            this.putValue("ShortDescription", Intl.intl("Font Size Decrease"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RecordView.this.setTextSize(RecordView.this.d_proc.getFont().getSize() - 1);
        }
    }

    private static interface TextPane {
        public SyntaxMap getSyntaxMap();

        public void updateColors();

        public void updateSyntax();

        public void updateSyntax(int var1, int var2);

        public boolean isRich();
    }

    private static class TextPaneWithLineNumbers
    extends guiPanel
    implements Scrollable {
        private static final long serialVersionUID = 4399351684684845435L;
        private static Color COLOR_FG = new Color(127, 127, 127);
        private JTextComponent d_textPane;
        private JComponent d_rowHeader;

        public TextPaneWithLineNumbers(JTextComponent textPane) {
            this.d_textPane = textPane;
            this.setLayout(new BorderLayout());
            this.add((Component)this.d_textPane, "Center");
            this.d_rowHeader = new JComponent(){
                private static final long serialVersionUID = -1527734596283354023L;

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    Rectangle headerBounds = this.getBounds();
                    Rectangle clip = g.getClipBounds();
                    FontMetrics fm = g.getFontMetrics();
                    int margin = 4;
                    int rightWall = headerBounds.width - 4;
                    int reqWidth = 8;
                    int rowHt = fm.getHeight();
                    g.setColor(COLOR_FG);
                    int row0_start = Math.min(rowHt, clip.y / rowHt);
                    int row0_end = (clip.y + clip.height) / rowHt + 1;
                    for (int row0 = row0_start; row0 <= row0_end; ++row0) {
                        String rowStr = Integer.toString(row0);
                        Rectangle2D rowStrBounds = fm.getStringBounds(rowStr, g);
                        reqWidth = Math.max(reqWidth, 4 + (int)rowStrBounds.getWidth() + 4);
                        int x = rightWall - (int)rowStrBounds.getWidth();
                        int y = row0 * rowHt - 1;
                        g.drawString(rowStr, x, y);
                    }
                    if (this.getPreferredSize().width < reqWidth) {
                        d_rowHeader.setPreferredSize(new Dimension(reqWidth, 1));
                        d_rowHeader.revalidate();
                    }
                }
            };
            this.d_rowHeader.setFont(this.d_textPane.getFont());
            this.d_textPane.setBackground(Color.WHITE);
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
            this.d_rowHeader.setPreferredSize(new Dimension(40, 1));
            this.add((Component)this.d_rowHeader, "West");
        }

        @Override
        public void updateUI() {
            if (this.d_rowHeader != null) {
                this.d_rowHeader.updateUI();
            }
            if (this.d_textPane != null) {
                this.d_textPane.updateUI();
            }
            super.updateUI();
        }

        @Override
        public void setFont(Font f) {
            super.setFont(f);
            if (this.d_rowHeader != null) {
                this.d_rowHeader.setFont(f);
            }
            if (this.d_textPane != null) {
                this.d_textPane.setFont(f);
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.d_textPane.getPreferredScrollableViewportSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.d_textPane.getFontMetrics(this.d_textPane.getFont()).getHeight();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.d_textPane.getFontMetrics(this.d_textPane.getFont()).getHeight();
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.d_textPane.getScrollableTracksViewportWidth();
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.d_textPane.getScrollableTracksViewportHeight();
        }
    }

    private class Renderer
    extends FDSPrintRenderer {
        private final StyledDocument d_doc;
        private Map<IPyroObject, IPyroObject> d_splitObjs;
        private IPyroObject d_prev;
        private final SyntaxMap d_sMap;
        private int d_syntaxCounter;

        public Renderer(FDSRenderProps props, StyledDocument doc, SyntaxMap sMap, Map<IPyroObject, IPyroObject> splitObjs) {
            super(new PrintWriter(new DocWriter(doc)), props);
            this.d_prev = null;
            this.d_doc = doc;
            this.d_sMap = sMap;
            this.d_syntaxCounter = 0;
            this.d_splitObjs = splitObjs;
        }

        private int size() {
            return this.d_doc.getLength();
        }

        @Override
        public void render(FDSRenderRecord rec, IPyroObject renderSrc) {
            IPyroObject src = this.d_splitObjs.getOrDefault(renderSrc, renderSrc);
            int begin = this.size();
            SyntaxMap objSynMap = this.renderWithSyntax(rec, src);
            int end = this.size();
            this.d_sMap.put(begin, "SYMBOL_EMPTY");
            if (src != null && src.getDomain() != null) {
                ObjDisp disp;
                if (end > begin) {
                    --end;
                }
                if ((disp = RecordView.this.d_displays.get(src)) == null) {
                    disp = new ObjDisp(src, begin, end);
                    RecordView.this.d_displays.put(src, disp);
                    RecordView.this.d_displayList.add(disp);
                } else if (src == this.d_prev) {
                    disp.append(begin, end);
                }
            }
            this.d_prev = src;
            boolean syntaxHiFlag = true;
            int syntaxHiObstHoleLimit = 4000;
            PyroSim pySim = PyroSim.getApp();
            if (pySim != null) {
                syntaxHiFlag = PyroPrefs.getBoolean(PyroPrefs.SYNTAX_HIGHLIGHT_ENABLE);
                syntaxHiObstHoleLimit = PyroPrefs.getInt(PyroPrefs.SYNTAX_HIGHLIGHT_OBSTHOLELIMIT);
            }
            boolean syntaxHiBypassFlag = false;
            if (rec.getType().equals("OBST") || rec.getType().equals("HOLE")) {
                ++this.d_syntaxCounter;
                boolean bl = syntaxHiBypassFlag = syntaxHiObstHoleLimit < this.d_syntaxCounter;
            }
            if (rec.getType().equals("GEOM") && objSynMap != null) {
                int equivObsts = (int)Math.ceil((double)objSynMap.getMap().size() / 21.0);
                this.d_syntaxCounter += equivObsts;
                boolean bl = syntaxHiBypassFlag = syntaxHiObstHoleLimit < this.d_syntaxCounter;
            }
            if (syntaxHiFlag && !syntaxHiBypassFlag && objSynMap != null) {
                if (((TextPane)((Object)RecordView.this.d_proc)).isRich()) {
                    int beginningIx;
                    Iterator<Map.Entry<Integer, String>> iter = objSynMap.getMap().entrySet().iterator();
                    int prevIx = beginningIx = this.d_sMap.getCurrIx();
                    while (iter.hasNext()) {
                        Map.Entry<Integer, String> entr = iter.next();
                        this.d_doc.setCharacterAttributes(prevIx, entr.getKey() + beginningIx - prevIx, ((RichTextPane)RecordView.this.d_proc).getStyle(entr.getValue()), true);
                        prevIx = beginningIx + entr.getKey();
                    }
                }
                this.d_sMap.mergeSyntaxToRoot(objSynMap);
            }
        }

        public SyntaxMap renderWithSyntax(FDSRenderRecord rec, IPyroObject src) {
            return rec.renderRecord(this.d_writer, this.props(), this.d_fieldRenderer);
        }
    }

    private static class ObjDisp {
        public final IPyroObject obj;
        public int i1;
        public int i2;

        public ObjDisp(IPyroObject obj, int i1, int i2) {
            this.obj = obj;
            this.i1 = i1;
            this.i2 = i2;
        }

        public void append(int i1, int i2) {
            this.i2 = i2;
        }
    }

    private class RichTextPane
    extends JTextPane
    implements TextPane {
        private static final long serialVersionUID = 4686426398407311194L;
        private SyntaxMap d_sMap;

        public RichTextPane(StyledDocument doc, SyntaxMap sMap) {
            super(doc);
            this.d_sMap = null;
            this.d_sMap = sMap;
            this.updateColors();
        }

        @Override
        public SyntaxMap getSyntaxMap() {
            return this.d_sMap;
        }

        @Override
        public void updateColors() {
            ColorScheme colors = PyroSim.getApp().getColorScheme();
            String lafName = UIManager.getLookAndFeel().getName();
            if (lafName.equals("FlatLaf Dark") || lafName.equals("FlatLaf Darcula")) {
                this.setSelectionColor(colors.getColor(PyroSimColors.FDS_SEL_COLOR_DARK));
                this.setSelectedTextColor(colors.getColor(PyroSimColors.FDS_SEL_TEXT_COLOR_DARK));
            } else {
                this.setSelectionColor(colors.getColor(PyroSimColors.FDS_SEL_COLOR));
                this.setSelectedTextColor(colors.getColor(PyroSimColors.FDS_SEL_TEXT_COLOR));
            }
        }

        @Override
        public Color getSelectedTextColor() {
            return null;
        }

        @Override
        public void updateUI() {
            RecordView.this.updateStyles();
            this.updateColors();
            this.updateSyntax();
            super.updateUI();
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHints(rh);
            super.paintComponent(g);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (e.getButton() == 3) {
                if (e.getID() != 501) {
                    return;
                }
                int newcaret = this.viewToModel(e.getPoint());
                ObjDisp disp = RecordView.this.getDisplay(newcaret);
                if (disp == null || !RecordView.this.d_mediator.getSelectionModel().isSelected(disp.obj)) {
                    RecordView.this.d_proc.setCaretPosition(newcaret);
                }
                SwingUtilities.invokeLater(() -> {
                    JPopupMenu popup = Actions.getContextMenu(RecordView.this.d_mediator.getSelectionModel().getSelection());
                    if (popup != null) {
                        popup.show(this, e.getX(), e.getY());
                    }
                });
                return;
            }
            super.processMouseEvent(e);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public void updateSyntax() {
            if (this.d_sMap != null) {
                this.updateSyntax(this.d_sMap.getMap(), 0);
            }
        }

        @Override
        public void updateSyntax(int begin, int end) {
            Map filteredMap = this.d_sMap.getMap().entrySet().stream().filter(p -> (Integer)p.getKey() >= begin && (Integer)p.getKey() <= end).sorted((p1, p2) -> Integer.compare((Integer)p1.getKey(), (Integer)p2.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            this.updateSyntax(filteredMap, begin);
        }

        @Override
        public boolean isRich() {
            return true;
        }

        public void updateSyntax(Map<Integer, String> filteredColl, int beginIx) {
            StyledDocument doc = (StyledDocument)RecordView.this.d_proc.getDocument();
            int prevIx = beginIx;
            for (Map.Entry<Integer, String> entr : filteredColl.entrySet()) {
                doc.setCharacterAttributes(prevIx, entr.getKey() - prevIx, doc.getStyle(entr.getValue()), true);
                prevIx = entr.getKey();
            }
        }
    }

    private class BasicTextPane
    extends JTextArea
    implements TextPane {
        private static final long serialVersionUID = 4686426398407311194L;
        private SyntaxMap d_sMap;

        public BasicTextPane(StyledDocument doc, SyntaxMap sMap) {
            super(doc);
            this.d_sMap = null;
            this.d_sMap = sMap;
            this.updateColors();
        }

        @Override
        public SyntaxMap getSyntaxMap() {
            return this.d_sMap;
        }

        @Override
        public void updateColors() {
            ColorScheme colors = PyroSim.getApp().getColorScheme();
            String lafName = UIManager.getLookAndFeel().getName();
            if (lafName.equals("FlatLaf Dark") || lafName.equals("FlatLaf Darcula")) {
                this.setSelectionColor(colors.getColor(PyroSimColors.FDS_SEL_COLOR_DARK));
                this.setSelectedTextColor(colors.getColor(PyroSimColors.FDS_SEL_TEXT_COLOR_DARK));
            } else {
                this.setSelectionColor(colors.getColor(PyroSimColors.FDS_SEL_COLOR));
                this.setSelectedTextColor(colors.getColor(PyroSimColors.FDS_SEL_TEXT_COLOR));
            }
        }

        @Override
        public void updateSyntax() {
        }

        @Override
        public void updateSyntax(int begin, int end) {
        }

        @Override
        public boolean isRich() {
            return false;
        }

        @Override
        public Color getSelectedTextColor() {
            return null;
        }

        @Override
        public void updateUI() {
            RecordView.this.updateStyles();
            this.updateColors();
            super.updateUI();
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHints(rh);
            super.paintComponent(g);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (e.getButton() == 3) {
                if (e.getID() != 501) {
                    return;
                }
                int newcaret = this.viewToModel(e.getPoint());
                ObjDisp disp = RecordView.this.getDisplay(newcaret);
                if (disp == null || !RecordView.this.d_mediator.getSelectionModel().isSelected(disp.obj)) {
                    RecordView.this.d_proc.setCaretPosition(newcaret);
                }
                SwingUtilities.invokeLater(() -> {
                    JPopupMenu popup = Actions.getContextMenu(RecordView.this.d_mediator.getSelectionModel().getSelection());
                    if (popup != null) {
                        popup.show(this, e.getX(), e.getY());
                    }
                });
                return;
            }
            super.processMouseEvent(e);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }
    }

    private static class DocWriter
    extends Writer {
        private final StyledDocument d_doc;
        private final StringBuilder d_buffer;

        public DocWriter(StyledDocument doc) {
            this.d_doc = doc;
            this.d_buffer = new StringBuilder();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.write(new String(cbuf, off, len));
        }

        @Override
        public void write(String str) throws IOException {
            int off = 0;
            int endlix = str.indexOf(10);
            while (endlix >= 0 && endlix < str.length()) {
                block3: {
                    this.d_buffer.append(str, off, endlix);
                    try {
                        this.d_doc.insertString(this.d_doc.getLength(), this.d_buffer.toString(), null);
                    }
                    catch (BadLocationException e) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError();
                    }
                }
                this.d_buffer.setLength(0);
                off = endlix;
                endlix = str.indexOf(10, endlix + 1);
            }
            this.d_buffer.append(str, off, str.length());
        }
    }
}

