/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.Grid;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.tasks.AddAutoRenameTask;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.actions.ActionsMesh;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.DisplayManager;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawPlaneGeomTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.ToolMeta;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.Util;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.gui.tool.ToolManager;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.text.IDisplayableTextSrc;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Task;

public class DrawToolBridge
implements ADrawTool.Listener,
ToolManager.ToolChangeListener {
    private final PyroMod d_domain;
    private final ModelView d_mv;
    private final DisplayManager d_dispMgr;
    private final ToolManager d_toolMgr;
    private final Map<Integer, IPyroGeomSrc> d_geomMap;
    private final Map<Integer, IDisplayableTextSrc> d_textMap;

    public DrawToolBridge(PyroMod domain, ModelView mv, DisplayManager dispMgr, ToolManager tools) {
        this.d_domain = domain;
        this.d_mv = mv;
        this.d_dispMgr = dispMgr;
        this.d_toolMgr = tools;
        this.d_geomMap = new HashMap<Integer, IPyroGeomSrc>();
        this.d_textMap = new HashMap<Integer, IDisplayableTextSrc>();
        Tool currTool = tools.getCurrentTool();
        if (currTool instanceof ADrawTool) {
            ((ADrawTool)currTool).addListener(this);
        }
        tools.addToolChangeListener(this);
    }

    public boolean isInteractive(Object obj) {
        return this.d_geomMap.values().contains(obj);
    }

    @Override
    public void toolWillChanged(Tool oldTool, Tool newTool) {
        if (oldTool instanceof ADrawTool) {
            this.d_dispMgr.remove(this.d_geomMap.values());
            this.d_dispMgr.remove(this.d_textMap.values());
            this.d_geomMap.clear();
            this.d_textMap.clear();
            ((ADrawTool)oldTool).removeListener(this);
        }
        if (newTool instanceof ADrawTool) {
            ((ADrawTool)newTool).addListener(this);
        }
    }

    @Override
    public void updateProps() {
        Tool tool = this.d_toolMgr.getCurrentTool();
        if (!(tool instanceof ADrawTool)) {
            return;
        }
        DrawProps props = ((ADrawTool)this.d_toolMgr.getCurrentTool()).getProps();
        ToolMeta meta = this.getMeta();
        if (meta == null || meta.objCreateType == null) {
            return;
        }
        for (Map.Entry<Integer, IPyroGeomSrc> entry : this.d_geomMap.entrySet()) {
            IPyroGeomSrc newObj;
            IPyroGeomSrc oldObj = entry.getValue();
            if (oldObj instanceof GenericGeomSrc || (newObj = props.updateObject(oldObj, meta.objCreateType)) == oldObj) continue;
            entry.setValue(newObj);
            this.d_dispMgr.remove(oldObj);
            this.d_dispMgr.add(newObj);
        }
    }

    @Override
    public void updateGeom(int id, IGeomNode geom, IPropsSrc displayProps) {
        IPyroGeomSrc geomSrc = this.d_geomMap.get(id);
        if (geomSrc != null && (!(geomSrc instanceof GenericGeomSrc) && displayProps != null || geomSrc instanceof GenericGeomSrc && displayProps == null)) {
            this.remove(id);
            geomSrc = null;
        }
        if (geomSrc == null) {
            geomSrc = this.newGeomSrc(geom, displayProps);
            if (geomSrc == null) {
                return;
            }
            this.d_geomMap.put(id, geomSrc);
            this.d_dispMgr.add(geomSrc);
        } else {
            this.updateGeomSrc(geomSrc, geom, displayProps);
            this.d_dispMgr.updateDisplays(geomSrc);
        }
    }

    @Override
    public void updateText(int id, IDisplayableTextSrc text, IPropsSrc displayProps) {
        IDisplayableTextSrc textSrc = this.d_textMap.get(id);
        if (textSrc != null) {
            this.d_dispMgr.remove(textSrc);
        }
        this.d_dispMgr.add(text);
        this.d_textMap.put(id, text);
    }

    private IPyroGeomSrc newGeomSrc(IGeomNode geom, IPropsSrc displayProps) {
        if (displayProps != null) {
            GenericGeomSrc src = new GenericGeomSrc("", geom, displayProps);
            return src;
        }
        ToolMeta meta = this.getMeta();
        if (meta == null || meta.objCreateType == null) {
            return null;
        }
        DrawProps props = ((ADrawTool)this.d_toolMgr.getCurrentTool()).getProps();
        return props.newObject(meta.objCreateType, geom);
    }

    private void updateGeomSrc(IPyroGeomSrc geomSrc, IGeomNode geom, IPropsSrc displayProps) {
        if (geomSrc instanceof GenericGeomSrc && displayProps != null) {
            geomSrc.setGeom(geom.bakeIfRecommended());
            ((GenericGeomSrc)geomSrc).setDisplayProps(displayProps);
        } else {
            ToolMeta meta = this.getMeta();
            if (meta == null || meta.objCreateType == null) {
                return;
            }
            DrawProps props = ((ADrawTool)this.d_toolMgr.getCurrentTool()).getProps();
            geom = props.finalizeGeom(geomSrc, meta.objCreateType, geom);
            if (geom != null) {
                geomSrc.setGeom(geom.bakeIfRecommended());
            }
        }
    }

    @Override
    public void remove(int id) {
        IDisplayableTextSrc textSrc;
        IPyroGeomSrc geomSrc = this.d_geomMap.remove(id);
        if (geomSrc != null) {
            this.d_dispMgr.remove(geomSrc);
        }
        if ((textSrc = this.d_textMap.remove(id)) != null) {
            this.d_dispMgr.remove(textSrc);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void finish(boolean commit) {
        if (!this.d_geomMap.isEmpty() && commit) {
            void var5_11;
            if (this.getMeta().objCreateType == DrawProps.ObjType.MESH_SPLIT) {
                this.finishMeshSplit();
                return;
            }
            ArrayList<IPyroGeomSrc> finalGeoms = new ArrayList<IPyroGeomSrc>(this.d_geomMap.size());
            LinkedIdentityHashMap<Composite, ArrayList<IPyroGeomSrc>> rootMap = new LinkedIdentityHashMap<Composite, ArrayList<IPyroGeomSrc>>();
            for (IPyroGeomSrc iPyroGeomSrc : this.d_geomMap.values()) {
                void var6_12;
                IPyroGeomSrc iPyroGeomSrc2 = (IPyroGeomSrc)iPyroGeomSrc.clone();
                if (iPyroGeomSrc2 instanceof PlanarSlice && !this.d_domain.getSlcfList().isUnique((PlanarSlice)iPyroGeomSrc2)) {
                    return;
                }
                if (iPyroGeomSrc2 instanceof VolumeSlice && !this.d_domain.getSlcf3dList().isUnique((VolumeSlice)iPyroGeomSrc2)) {
                    return;
                }
                finalGeoms.add(iPyroGeomSrc2);
                Object object = TVEntryPoints.ep(iPyroGeomSrc2).getCategoryRoot(this.d_domain, iPyroGeomSrc2);
                if (object instanceof ModelComposite) {
                    ModelComposite modelComposite = this.d_mv.getNewObstructionGroup();
                }
                if (!(var6_12 instanceof Composite)) continue;
                ArrayList<IPyroGeomSrc> list = (ArrayList<IPyroGeomSrc>)rootMap.get((Composite)var6_12);
                if (list == null) {
                    list = new ArrayList<IPyroGeomSrc>();
                    rootMap.put((Composite)var6_12, list);
                }
                list.add(iPyroGeomSrc2);
            }
            ArrayList<AddTask> tasks = new ArrayList<AddTask>();
            for (Map.Entry entry : rootMap.entrySet()) {
                void var8_21;
                List geoms = (List)entry.getValue();
                Object var8_22 = null;
                if (geoms.size() == 1) {
                    IPyroObject iPyroObject = (IPyroObject)geoms.get(0);
                } else if (geoms.size() > 1) {
                    Composite group = ((Composite)entry.getKey()).newGroup(Util.getName((IPyroObject)geoms.get(0)));
                    group.addAll(geoms);
                    Composite composite = group;
                }
                assert (var8_21 != null);
                Hierarchy.flattenComposites(Collections.singleton(var8_21)).stream().map(o -> o.getClass()).distinct().forEach(c -> this.showAllEntitiesOfObjectType((Class<?>)c));
                Composite parent = (Composite)entry.getKey();
                if (Util.isKeyedByName(this.d_domain, var8_21)) {
                    tasks.add(new AddAutoRenameTask(parent, new IPyroObject[]{var8_21}));
                    continue;
                }
                tasks.add(new AddTask((IPyroObject)entry.getKey(), new IPyroObject[]{var8_21}));
            }
            Object var5_8 = null;
            if (tasks.size() == 1) {
                Task task = (Task)tasks.get(0);
            } else {
                CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(this.d_domain);
                for (Task task : tasks) {
                    compositeTask.addTask(task);
                }
                CompositeTask<PyroMod> compositeTask2 = compositeTask;
            }
            SelectTask selectTask = new SelectTask(this.d_domain, finalGeoms);
            selectTask.addTask((Task)var5_11);
            this.d_domain.getTaskManager().exec((Task)selectTask, Intl.intl("Add Object"), 1);
        }
    }

    private void showAllEntitiesOfObjectType(Class<?> objClass) {
        this.d_mv.setViewFilterState(objClass, true);
    }

    private ToolMeta getMeta() {
        Tool tool = this.d_toolMgr.getCurrentTool();
        Object meta = this.d_toolMgr.getProps((Tool)tool).meta;
        return meta instanceof ToolMeta ? (ToolMeta)meta : null;
    }

    private void finishMeshSplit() {
        PyroMod pyMod = PyroSim.getApp().getMediator();
        DrawPlaneGeomTool tool = (DrawPlaneGeomTool)this.d_toolMgr.getCurrentTool();
        List<Plane3d> planes = tool.getPlanes();
        ArrayList<Grid> grids = new ArrayList<Grid>(pyMod.getSelectionModel().flatten(Grid.class));
        Task task = ActionsMesh.SplitMeshAction.taskSplit(grids, planes, pyMod.getDependencies(grids));
        if (task != null) {
            pyMod.getTaskManager().exec(task, Intl.intl("Split Meshes"), 1);
        }
    }
}

