/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.snappers;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.PyroMod;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Floor;
import pyrosim.domain.Grid;
import pyrosim.mv.displays.GridDisplayManager;
import pyrosim.mv.snappers.IGridSnapper;
import pyrosim.mv.snappers.ModelGridSnapper;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;

public class CompositeModelGridSnapper
implements IGridSnapper {
    private final GridDisplayManager d_dispMgr;
    private final Map<Grid, ModelGridSnapper> d_snappers;
    private boolean d_visible;
    private Floor d_activeFloor;

    public CompositeModelGridSnapper(GridDisplayManager dispMgr) {
        this.d_dispMgr = dispMgr;
        this.d_snappers = new IdentityHashMap<Grid, ModelGridSnapper>();
        this.d_visible = true;
        this.d_activeFloor = null;
    }

    @Override
    public void setVisible(boolean visible) {
        this.d_visible = visible;
    }

    @Override
    public boolean isVisible() {
        if (!this.d_visible) {
            return false;
        }
        for (ModelGridSnapper snapper : this.d_snappers.values()) {
            if (!snapper.isVisible()) continue;
            return true;
        }
        return false;
    }

    public void setActiveFloor(Floor activeFloor) {
        this.d_activeFloor = activeFloor;
        for (ModelGridSnapper snapper : this.d_snappers.values()) {
            snapper.setActiveFloor(activeFloor);
        }
    }

    @Override
    public AABox getBounds() {
        AABox bounds = new AABox();
        for (ModelGridSnapper snapper : this.d_snappers.values()) {
            bounds.add(snapper.getBounds());
        }
        return bounds;
    }

    public void removeAll() {
        this.d_snappers.clear();
        this.update();
    }

    public void addAll(PyroMod mod) {
        for (Grid grid : ((APyroObject)mod.getGridManager()).flatten(Grid.class)) {
            this.d_snappers.put(grid, this.create(grid));
        }
        this.update();
    }

    private ModelGridSnapper create(Grid grid) {
        ModelGridSnapper snapper = new ModelGridSnapper(this.d_dispMgr, grid);
        snapper.setActiveFloor(this.d_activeFloor);
        return snapper;
    }

    protected void update() {
        this.d_dispMgr.getMediator().getGeomLocator().update(this);
    }

    public void processEvents(Events events) {
        boolean modified = false;
        IEventRecord<Grid> gevts = events.getEvents(Grid.class, new Class[0]);
        for (Grid grid : gevts.getChangedObjs(EventChannel.EVT_GENERAL)) {
            this.d_snappers.get(grid).resetData();
            modified = true;
        }
        for (Grid grid : gevts.getAddedObjs()) {
            this.d_snappers.put(grid, this.create(grid));
            modified = true;
        }
        for (Grid grid : gevts.getRemovedObjs()) {
            this.d_snappers.remove(grid);
            modified = true;
        }
        if (modified) {
            this.update();
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return DisplayGeom.EMPTY;
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box) {
        if (!filter.acceptPickObjType(ModelGridSnapper.class)) {
            return;
        }
        for (ModelGridSnapper snapper : this.d_snappers.values()) {
            snapper.pickBox(result, filter, box);
        }
    }

    @Override
    public void getAll(Consumer<Object> result, IIsectFilter filter) {
        if (!filter.acceptPickObjType(ModelGridSnapper.class)) {
            return;
        }
        for (ModelGridSnapper snapper : this.d_snappers.values()) {
            snapper.getAll(result, filter);
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
        if (!filter.acceptPickObjType(ModelGridSnapper.class)) {
            return;
        }
        for (ModelGridSnapper snapper : this.d_snappers.values()) {
            if (!snapper.isVisible()) continue;
            AABox bounds = snapper.getBounds();
            if (!tester.test((AABox)bounds).positive) continue;
            snapper.pickPoints(isects, filter, rayBegin, rayDirN, maxDist, tester);
        }
    }

    @Override
    public void pickCells(IIsectCollector isects, Point3d rayBegin, Vector3d rayDir, ITest<AABox> tester) {
        for (ModelGridSnapper snapper : this.d_snappers.values()) {
            if (!snapper.isVisible()) continue;
            AABox bounds = snapper.getBounds();
            if (!tester.test((AABox)bounds).positive) continue;
            snapper.pickCells(isects, rayBegin, rayDir, tester);
        }
    }
}

