/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.PyroMod;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.mv.ModelView;
import pyrosim.mv.PyroDrawProps;
import pyrosim.mv.displays.APyroDisplayMgr;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.IPyroDisplay;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.text.IDisplayableTextSrc;

public class TextDisplayMgr
extends APyroDisplayMgr<IDisplayableTextSrc, TextDisplay> {
    private final PyroDrawProps d_drawProps;

    public TextDisplayMgr(PyroMod mod, ModelView mv, APyroDisplayMgr.TargetSceneMap scenes, PyroDrawProps drawProps, DisplayFilter dispFilter, Predicate<IDisplayableTextSrc> filter) {
        super(mod, mv, scenes, dispFilter, new IPyroDisplayMgr.ObjFilter<IDisplayableTextSrc>(IDisplayableTextSrc.class, filter, new Class[0]));
        this.d_drawProps = drawProps;
    }

    @Override
    protected TextDisplay createDisplay(IDisplayableTextSrc obj, boolean visible, boolean selected) {
        TextDisplay display = new TextDisplay(obj, this.d_drawProps);
        display.setVisible(visible);
        display.setSelected(selected);
        return display;
    }

    @Override
    protected boolean isVisible(IDisplayableTextSrc obj) {
        return !this.isFiltered(obj);
    }

    @Override
    public void addAll() {
    }

    public static class TextDisplay
    implements IPyroDisplay {
        private final IDisplayableTextSrc d_textSrc;
        private final GeomDisplay d_geomDisplay;

        public TextDisplay(IDisplayableTextSrc textSrc, INativeDisplayProps dispProps) {
            this.d_textSrc = textSrc;
            this.d_geomDisplay = new GeomDisplay(dispProps, (IDisplayableGeomSrc)new GenericGeomSrc("", GeomNodeLeaf.EMPTY_NODE, null), this.d_textSrc);
        }

        @Override
        public void setVisible(boolean visible) {
            this.d_geomDisplay.setVisible(visible);
        }

        @Override
        public void setSelected(boolean selected) {
            this.d_geomDisplay.setSelected(selected);
        }

        @Override
        public void update() {
            this.d_geomDisplay.update();
        }

        @Override
        public void getDisplayObjs(RenderTarget target, Collection<? super IDisplayable> displays) {
            Collections.addAll(displays, this.d_geomDisplay.getDisplayObjs());
        }

        @Override
        public AABox getBounds() {
            return this.d_geomDisplay.getBoundingBox();
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
        }

        @Override
        public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull region) {
        }

        @Override
        public void getAll(Consumer<Object> result, IIsectFilter filter) {
        }
    }
}

