/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Grid;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.PyroDisplayGeom;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.geom.TexCoordGenerator;
import pyrosim.io.fds.EnabledFilter;
import pyrosim.mv.ModelView;
import pyrosim.mv.PyroDrawProps;
import pyrosim.mv.displays.APyroDisplayMgr;
import pyrosim.mv.displays.ClippingManager;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.EventResult;
import pyrosim.mv.displays.IPyroDisplay;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.IDisplayMgr;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import thunderheadeng.scene3d.nativebuffered.IPrimTransformAnim;
import thunderheadeng.scene3d.nativebuffered.PrimTransformAnim;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.transformpreview.GeomDispTransformPreview;
import thunderheadeng.scene3d.transformpreview.ITransformPreview;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theTimer;

public class GeomDisplayMgr
extends APyroDisplayMgr<IPyroGeomSrc, CapDisplay> {
    private final PyroDrawProps d_drawProps;
    private GridMergeUtil.MergeResult d_gridBoundaries;
    private final boolean d_capsEnabled;

    public GeomDisplayMgr(PyroMod mod, ModelView mv, APyroDisplayMgr.TargetSceneMap scenes, PyroDrawProps drawProps, DisplayFilter df, Predicate<IPyroGeomSrc> filter) {
        super(mod, mv, scenes, df, new IPyroDisplayMgr.ObjFilter<IPyroGeomSrc>(IPyroGeomSrc.class, filter, Grid.class));
        this.d_drawProps = drawProps;
        this.d_capsEnabled = ((Optional)scenes.apply(RenderTarget.CLIP_CAPS)).isPresent();
    }

    protected Composite<? extends IPyroObject>[] getManagers(PyroMod domain) {
        return new Composite[]{domain.getGridManager(), domain.getObstructions(), domain.getZoneMgr(), domain.getDevices(), domain.getSlcfList(), domain.getSlcf3dList(), domain.getViews()};
    }

    @Override
    public ITransformPreview getTransformPreview(IDisplayMgr<? super IPyroGeomSrc> copyMgr, Collection<? extends IPyroGeomSrc> objs, boolean copyMode) {
        if (!(copyMgr instanceof GeomDisplayMgr)) {
            return super.getTransformPreview(copyMgr, objs, copyMode);
        }
        return new GeomDispTransformPreview<IPyroGeomSrc, CapDisplay>(this, (IPyroDisplayMgr)copyMgr, objs, copyMode, new GeomDispTransformPreview.IAppHook<IPyroGeomSrc, CapDisplay>(this){

            @Override
            public void copyVis(IDisplayMgr<IPyroGeomSrc> srcMgr, IDisplayMgr<IPyroGeomSrc> destMgr, Collection<Pair<CapDisplay, CapDisplay>> displays) {
                for (Pair<CapDisplay, CapDisplay> entry : displays) {
                    ((CapDisplay)entry.v2).setVisible(((CapDisplay)entry.v1).isVisible());
                    ((CapDisplay)entry.v2).setSelected(((CapDisplay)entry.v1).isSelected());
                }
            }

            @Override
            public void hide(IDisplayMgr<IPyroGeomSrc> mgr, Collection<? extends CapDisplay> cdisps) {
                for (CapDisplay capDisplay : cdisps) {
                    capDisplay.setVisible(false);
                    capDisplay.setSelected(false);
                }
            }

            @Override
            public CapDisplay getDisplay(IDisplayMgr<IPyroGeomSrc> mgr, IPyroGeomSrc obj) {
                return (CapDisplay)((GeomDisplayMgr)mgr).getDisplay(obj);
            }

            @Override
            public void setDispAnim(IDisplayMgr<IPyroGeomSrc> mgr, Collection<? extends CapDisplay> displays, Function<CapDisplay, PrimTransformAnim> anims) {
                for (CapDisplay capDisplay : displays) {
                    capDisplay.setTransformAnim(anims.apply(capDisplay));
                }
            }

            @Override
            public void transformUpdated(IDisplayMgr<IPyroGeomSrc> mgr) {
            }
        });
    }

    @Override
    public void setSearchTreeEnabled(boolean enabled, Predicate<? super IPyroGeomSrc> objsToAddToSearch) {
        if (enabled != this.getSearchTree().isPresent()) {
            for (CapDisplay display : this.getDisplayMap().values()) {
                display.setCacheEnabled(enabled);
            }
        }
        super.setSearchTreeEnabled(enabled, objsToAddToSearch);
    }

    @Override
    public void addAll() {
        for (Composite<? extends IPyroObject> manager : this.getManagers(this.getMediator())) {
            this.addDisplays(manager.flatten(IPyroGeomSrc.class, this.getObjFilter().toTypedPredicate()));
        }
    }

    @Override
    protected CapDisplay createDisplay(IPyroGeomSrc obj, boolean visible, boolean selected) {
        PyroDrawProps dispProps = this.getDrawProps();
        CapDisplay disp = new CapDisplay(dispProps, obj, GeomDispTransformPreview.IDENTITY_ANIM, this.d_capsEnabled, this.getSearchTree().isPresent());
        disp.setSelected(selected);
        disp.setVisible(visible);
        return disp;
    }

    @Override
    public void updateDisplay(IPyroGeomSrc obj, CapDisplay display) {
        this.updateSelection(obj, display);
        this.updateVisibility(obj, display);
        display.setSource(obj);
        this.updateSearch(obj, display);
    }

    @Override
    protected boolean isVisible(IPyroGeomSrc obj) {
        return obj.isEnabled() && obj.isVisible() && !this.isFiltered(obj);
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.d_gridBoundaries = null;
    }

    @Override
    protected Set<? extends IPyroGeomSrc> getUpdateObjs(Events events, IEventRecord<IPyroGeomSrc> evts) {
        Set<IPyroGeomSrc> updateObjs = evts.getChangedObjs(EventChannel.EVT_GENERAL, PyroMod.EVT_APPEARANCE);
        IdentityHashSet additionalUpdateObjs = new IdentityHashSet();
        IEventRecord<Grid> gridEvts = events.getEvents(Grid.class, new Class[0]);
        Set<Grid> changedGrids = GeomDisplayMgr.getChangedDependedOn(events, Grid.class, new Object[0]);
        if (gridEvts.hasAddedObjs() || gridEvts.hasRemovedObjs() || !changedGrids.isEmpty()) {
            additionalUpdateObjs.addAll(this.getMediator().getSlcfList().flatten(PlanarSlice.class, this.getObjFilter().toTypedPredicate()));
            additionalUpdateObjs.addAll(this.getMediator().getSlcf3dList().flatten(VolumeSlice.class, this.getObjFilter().toTypedPredicate()));
            additionalUpdateObjs.addAll(this.getMediator().getObstructions().flatten(Vent.class, this.getObjFilter().toTypedPredicate()));
            additionalUpdateObjs.addAll(this.getMediator().getObstructions().flatten(Obstruction.class, this.getObjFilter().toTypedPredicate()));
        }
        if (!additionalUpdateObjs.isEmpty()) {
            updateObjs = new IdentityHashSet<IPyroGeomSrc>(updateObjs);
            updateObjs.addAll(additionalUpdateObjs);
        }
        return updateObjs;
    }

    private static <T extends IPyroObject> Set<T> getChangedDependedOn(Events events, Class<T> depOnType, Object ... includeEvts) {
        IEventRecord<T> objEvents = events.getEvents(depOnType, new Class[0]);
        Set<T> changedObjs = includeEvts.length > 0 ? objEvents.getChangedObjs(includeEvts) : objEvents.getChangedNotOfType(PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED, PyroMod.EVT_PARENT_CHANGED);
        return changedObjs;
    }

    @Override
    public void processEvents(Events events, EventResult result) {
        IEventRecord<Grid> gridEvts = events.getEvents(Grid.class, new Class[0]);
        Set<Grid> changedGrids = gridEvts.getChangedNotOfType(PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED, PyroMod.EVT_PARENT_CHANGED);
        if (gridEvts.hasAddedObjs() || gridEvts.hasRemovedObjs() || !changedGrids.isEmpty()) {
            this.d_gridBoundaries = null;
        }
        super.processEvents(events, result);
    }

    @Override
    public void updateClipping(ClippingManager clipMgr) {
        if (!this.d_capsEnabled) {
            return;
        }
        theTimer timer = new theTimer();
        LinkedIdentityHashSet displays = new LinkedIdentityHashSet();
        for (CapDisplay disp : this.getDisplayMap().values()) {
            if (!disp.containsCaps) continue;
            displays.add(disp);
        }
        ConvexHull region = clipMgr.getClipRegion();
        IResult<IDisplayableGeomSrc> result = (obj, ctmt) -> {
            CapDisplay disp;
            if (ctmt == Containment.INTERSECTS && obj instanceof IPyroGeomSrc && (disp = (CapDisplay)this.getDisplay((IPyroGeomSrc)obj)) != null) {
                displays.add(disp);
            }
        };
        this.getMediator().getGeomLocator().find(region, result, true, true);
        System.out.printf("Updating clip caps for %d/%d displays...", displays.size(), this.getDisplayMap().size());
        System.out.flush();
        for (CapDisplay disp : displays) {
            disp.update();
        }
        System.out.printf("done (%g s)%n", timer.curr());
    }

    public GridMergeUtil.MergeResult getGridBoundaries() {
        if (this.d_gridBoundaries == null) {
            Collection<Grid> grids = this.getMediator().getGridManager().flatten(Grid.class, new EnabledFilter());
            this.d_gridBoundaries = GridMergeUtil.mergeGrids(grids, Collections.EMPTY_LIST);
        }
        return this.d_gridBoundaries;
    }

    protected PyroDrawProps getDrawProps() {
        return this.d_drawProps;
    }

    @Override
    public IPickable getPicker(IPyroGeomSrc obj) {
        if (obj instanceof Vent) {
            return this.getDisplay(obj);
        }
        return super.getPicker(obj);
    }

    public static class CapDisplay
    implements IPyroDisplay {
        private IDisplayableGeomSrc d_src;
        private final GeomDisplay d_uncappedDisp;
        private final GeomDisplay d_cappedDisp;
        public boolean containsCaps = false;
        private boolean d_retainCache = false;
        private DisplayGeom d_cachedUncapped;
        private DisplayGeom d_cachedCapped;

        public CapDisplay(INativeDisplayProps dispProps, IDisplayableGeomSrc source, IPrimTransformAnim anim, boolean capsEnabled, boolean cachingEnabled) {
            this.d_retainCache = cachingEnabled;
            this.d_src = source;
            this.updateCache(dispProps, capsEnabled);
            GeomSource d_uncappedSrc = new GeomSource(true);
            GeomSource d_cappedSrc = capsEnabled ? new GeomSource(false) : null;
            this.d_uncappedDisp = new GeomDisplay(dispProps, (IDisplayableGeomSrc)d_uncappedSrc, anim);
            this.d_cappedDisp = capsEnabled ? new GeomDisplay(dispProps, (IDisplayableGeomSrc)d_cappedSrc, anim) : null;
        }

        public void setSource(IDisplayableGeomSrc newSrc) {
            this.d_src = newSrc;
            this.update();
        }

        public void setCacheEnabled(boolean enabled) {
            this.d_retainCache = enabled;
            if (!enabled) {
                this.d_cachedUncapped = null;
                this.d_cachedCapped = null;
            }
        }

        @Override
        public AABox getBounds() {
            return this.d_uncappedDisp.getBoundingBox();
        }

        @Override
        public void getAll(Consumer<Object> result, IIsectFilter filter) {
            if (filter.acceptPickObject(this.d_src)) {
                result.accept(this.d_src);
            }
        }

        @Override
        public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull region) {
            if (!filter.acceptPickObject(this.d_src)) {
                return;
            }
            INativeDisplayProps props = this.d_uncappedDisp.getDisplayProps();
            IPickable.pickBox(this.d_src, () -> this.getGeom(props, true), result, filter, region);
            if (this.d_cappedDisp != null) {
                IPickable.pickBox(this.d_src, () -> this.getGeom(props, false), result, filter, region);
            }
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
            if (!filter.acceptPickObject(this.d_src)) {
                return;
            }
            INativeDisplayProps props = this.d_uncappedDisp.getDisplayProps();
            IPickable.pickPoints(this.d_src, () -> this.getGeom(props, true), isects, filter, rayBegin, rayDirN, maxDist, tester);
            if (this.d_cappedDisp != null) {
                IPickable.pickPoints(this.d_src, () -> this.getGeom(props, false), isects, filter, rayBegin, rayDirN, maxDist, tester);
            }
        }

        @Override
        public void getDisplayObjs(RenderTarget target, Collection<? super IDisplayable> displays) {
            switch (target) {
                case NORMAL: {
                    displays.add(this.d_uncappedDisp);
                    break;
                }
                case CLIP_CAPS: {
                    if (this.d_cappedDisp == null) break;
                    displays.add(this.d_cappedDisp);
                }
            }
        }

        private void apply(Consumer<GeomDisplay> disp) {
            disp.accept(this.d_uncappedDisp);
            if (this.d_cappedDisp != null) {
                disp.accept(this.d_cappedDisp);
            }
        }

        @Override
        public void setSelected(boolean selected) {
            this.apply(disp -> disp.setSelected(selected));
        }

        public boolean isSelected() {
            return this.d_uncappedDisp.isSelected();
        }

        @Override
        public void setVisible(boolean visible) {
            this.apply(disp -> disp.setVisible(visible));
        }

        public boolean isVisible() {
            return this.d_uncappedDisp.isVisible();
        }

        public void setTransformAnim(IPrimTransformAnim anim) {
            this.apply(disp -> disp.setTransformAnim(anim));
        }

        private void updateCache(IDisplayProps props) {
            this.updateCache(props, this.d_cappedDisp != null);
        }

        private void updateCache(IDisplayProps props, boolean capsEnabled) {
            PyroDrawProps pprops;
            ClippingManager cmgr;
            DisplayGeom uncapped = this.d_src.getDisplayGeom(props);
            DisplayGeom caps = DisplayGeom.EMPTY;
            if (capsEnabled && props instanceof PyroDrawProps && (cmgr = (pprops = (PyroDrawProps)props).getClippingManager()) != null && !cmgr.getClipRegion().acceptsAll()) {
                IElemSource<Point2d> defPrimUV = TexCoordGenerator.DEFAULT_OBJ;
                IPropsSrc psrc = null;
                boolean autoOpacity = false;
                psrc = cmgr.getClipProps();
                autoOpacity = true;
                caps = GeomUtil.generateClipCaps(pprops, uncapped, cmgr.getClipRegion(), psrc, autoOpacity, defPrimUV);
                boolean bl = this.containsCaps = caps.node.getNumPrims(7) != 0;
            }
            if (uncapped instanceof PyroDisplayGeom && (((PyroDisplayGeom)uncapped).options & 1) != 0) {
                uncapped = GeomUtil.convertToOutline(uncapped);
                if (caps != DisplayGeom.EMPTY) {
                    caps = GeomUtil.convertToOutline(caps);
                }
            }
            this.d_cachedUncapped = uncapped;
            this.d_cachedCapped = caps;
        }

        @Override
        public void update() {
            this.updateCache(this.d_uncappedDisp.getDisplayProps());
            this.apply(disp -> disp.update());
        }

        private synchronized DisplayGeom getGeom(IDisplayProps props, boolean uncapped) {
            if (uncapped && this.d_cachedUncapped == null || !uncapped && this.d_cachedCapped == null) {
                this.updateCache(props);
            }
            if (uncapped) {
                DisplayGeom result = this.d_cachedUncapped;
                if (!this.d_retainCache) {
                    this.d_cachedUncapped = null;
                }
                return result;
            }
            DisplayGeom result = this.d_cachedCapped;
            if (!this.d_retainCache) {
                this.d_cachedCapped = null;
            }
            return result;
        }

        private class GeomSource
        implements IDisplayableGeomSrc {
            private boolean d_uncapped;

            public GeomSource(boolean uncapped) {
                this.d_uncapped = uncapped;
            }

            @Override
            public AABox getBounds() {
                return null;
            }

            @Override
            public boolean isVisible() {
                return true;
            }

            @Override
            public void setVisible(boolean visible) {
            }

            @Override
            public DisplayGeom getDisplayGeom(IDisplayProps props) {
                return CapDisplay.this.getGeom(props, this.d_uncapped);
            }
        }
    }
}

