/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.vecmath.Matrix4d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.Native;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IDisplayable;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderable;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ISceneObject;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Scene;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.SceneRenderOptions;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2012_1.thunderheadeng.util.Keyable;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class ModelScene
extends Scene {
    private static final long serialVersionUID = 1481471511062920032L;
    private static final int MAX_ARR_SIZE = 10000;
    private SceneRenderOptions d_drawProps = new SceneRenderOptions();
    private Matrix4d d_xform = null;
    private static final int method_addRenderableObjects = 0;
    private static final int method_removeRenderableObjects = 1;
    private static final int method_addSceneObjects = 2;
    private static final int method_removeSceneObjects = 3;
    private static final int method_removeAllObjects = 4;
    private static final int method_forceImmediate = 5;
    private static final int method_addCullBox = 6;
    private static final int method_removeCullBox = 7;
    private static final int method_removeAllCullBoxes = 8;

    public ModelScene() {
        this.markNativeDirty();
        this.nativeConstructed(ModelScene.class);
    }

    public void setTransform(Matrix4d xform) {
        if (theUtil.equal(this.d_xform, xform)) {
            return;
        }
        this.d_xform = xform;
        this.markNativeDirty();
    }

    public Matrix4d getTransform() {
        return this.d_xform;
    }

    @Override
    public Class resolveNativeClass() {
        return ModelScene.class;
    }

    public void setDrawProps(SceneRenderOptions pdp) {
        assert (pdp != null);
        this.d_drawProps = pdp;
        this.markNativeDirty();
    }

    public SceneRenderOptions getDrawProps() {
        return this.d_drawProps;
    }

    @Override
    public void writeNativeData(INativeStream writer) {
        super.writeNativeData(writer);
        writer.write((Keyable)this.d_drawProps);
        writer.writeBoolean(this.d_xform != null);
        if (this.d_xform != null) {
            Matrix4d inverse = new Matrix4d(this.d_xform);
            inverse.invert();
            ModelScene.write(writer, this.d_xform);
            ModelScene.write(writer, inverse);
        }
    }

    private static void write(INativeStream writer, Matrix4d xform) {
        writer.writeDoubles(xform.m00, xform.m01, xform.m02, xform.m03, xform.m10, xform.m11, xform.m12, xform.m13, xform.m20, xform.m21, xform.m22, xform.m23, xform.m30, xform.m31, xform.m32, xform.m33);
    }

    public void forceImmediate(boolean force) {
        Native.manager.execMethod(ModelScene.class, this, 5, force);
        Native.manager.flush();
    }

    public void addObjects(IDisplayable ... objs) {
        this.addObjects(Arrays.asList(objs));
    }

    public void addObjects(Collection<? extends IDisplayable> objs) {
        this.addRenderableObjects(new FilteredCollection<IRenderable>(objs, IRenderable.class));
        this.addSceneObjects(new FilteredCollection<ISceneObject>(objs, ISceneObject.class));
    }

    public void removeObjects(IDisplayable ... objs) {
        this.removeObjects(Arrays.asList(objs));
    }

    public void removeObjects(Collection<? extends IDisplayable> objs) {
        this.removeRenderableObjects(new FilteredCollection<IRenderable>(objs, IRenderable.class));
        this.removeSceneObjects(new FilteredCollection<ISceneObject>(objs, ISceneObject.class));
    }

    public void addRenderableObjects(IRenderable ... objs) {
        this.addRenderableObjects(Arrays.asList(objs));
    }

    public void addRenderableObjects(Collection<? extends IRenderable> objs) {
        this.execArrayMethod(0, objs);
    }

    public void removeRenderableObjects(IRenderable ... objs) {
        this.removeRenderableObjects(Arrays.asList(objs));
    }

    public void removeRenderableObjects(Collection<? extends IRenderable> objs) {
        this.execArrayMethod(1, objs);
    }

    public void addSceneObjects(ISceneObject ... objs) {
        this.addSceneObjects(Arrays.asList(objs));
    }

    public void addSceneObjects(Collection<? extends ISceneObject> objs) {
        this.execArrayMethod(2, objs);
    }

    public void removeSceneObjects(ISceneObject ... objs) {
        this.removeSceneObjects(Arrays.asList(objs));
    }

    public void removeSceneObjects(Collection<? extends ISceneObject> objs) {
        this.execArrayMethod(3, objs);
    }

    public void removeAllObjects() {
        Native.manager.execMethod(ModelScene.class, this, 4, new Object[0]);
    }

    private final void execArrayMethod(int methodID, Collection<? extends Keyable> objs) {
        int numArrs = objs.size() / 10000;
        if (objs.size() % 10000 != 0) {
            ++numArrs;
        }
        Iterator<? extends Keyable> it = objs.iterator();
        int remaining = objs.size();
        Object[] arr = new Object[Math.min(10000, remaining)];
        for (int m = 0; m < numArrs; ++m) {
            int count = Math.min(remaining, 10000);
            if (m == numArrs - 1 && m > 0) {
                arr = new Object[count];
            }
            for (int n = 0; n < count; ++n) {
                arr[n] = it.next();
            }
            remaining -= count;
            Native.manager.execMethod(ModelScene.class, this, methodID, count, arr);
        }
    }

    private final Object[] getKeyableArray(Collection<?> objs) {
        FilteredCollection<Keyable> nativeObjs = new FilteredCollection<Keyable>(objs, Keyable.class);
        Object[] nativeObjsA = nativeObjs.toArray((Keyable[])new Keyable[nativeObjs.size()]);
        return nativeObjsA;
    }

    private static Object[] extractCHParams(ConvexHull ch) {
        Object[] params = new Object[1 + ch.getPlanes().length * 4];
        params[0] = ch.getPlanes().length;
        for (int m = 0; m < ch.getPlanes().length; ++m) {
            Plane3d plane = ch.getPlanes()[m];
            int offset = (m << 2) + 1;
            params[offset + 0] = plane.x;
            params[offset + 1] = plane.y;
            params[offset + 2] = plane.z;
            params[offset + 3] = plane.w;
        }
        return params;
    }

    public void addCullBox(ConvexHull hull) {
        Object[] vals = ModelScene.extractCHParams(hull);
        Native.manager.execMethod(ModelScene.class, this, 6, vals);
    }

    public void removeCullBox(ConvexHull hull) {
        Object[] vals = ModelScene.extractCHParams(hull);
        Native.manager.execMethod(ModelScene.class, this, 7, vals);
    }

    public void removeAllCullBoxes() {
        Native.manager.execMethod(ModelScene.class, this, 8, new Object[0]);
    }
}

