/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.util.Observer;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.ANativelyMirrored;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.Native;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.CameraRecord;
import pyrosim.legacy_2012_1.thunderheadeng.util.ObservableMediator;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public abstract class Camera
extends ANativelyMirrored {
    private static final long serialVersionUID = 800908134791145585L;
    public static final int LOCALAXIS_FORWARD = 0;
    public static final int LOCALAXIS_RIGHT = 1;
    public static final int LOCALAXIS_UP = 2;
    private final ObservableMediator d_observable = new ObservableMediator();
    private Point3d d_pos;
    private Point3d d_ref;
    private Vector3d d_up;
    private Matrix4d d_customXform;
    private static final int method_worldToView = 0;
    private static final int method_viewToWorld = 1;
    private static final int method_worldToScreen = 2;
    private static final int method_screenToWorld = 3;
    private static final int method_viewToScreen = 4;
    private static final int method_screenToView = 5;
    private static final int method_worldToCamera = 6;
    private static final int method_screenToCamera = 7;
    private static final int method_reset = 8;
    private static final int method_getMatrix = 9;
    private static final int method_setCopyCam = 10;
    private static final int method_setClip = 11;
    private static final int method_getClip = 12;
    private static final int method_zoom = 13;
    private static final int method_zoomAboutPoint = 14;
    private static final int method_setZoom = 15;
    private static final int method_getZoom = 16;
    private static final int method_fitClipping = 17;
    public static final int MAT_TRANSFORM = 0;
    public static final int MAT_INV_TRANSFORM = 1;
    public static final int MAT_VIEW = 2;
    public static final int MAT_INV_VIEW = 3;
    public static final int MAT_PROJECTION = 4;
    public static final int MAT_INV_PROJECTION = 5;
    public static final int MAT_WORLD_TO_SCREEN = 6;
    public static final int MAT_SCREEN_TO_WORLD = 7;

    protected abstract double calcScreenZValue(double var1);

    protected abstract Point3d constrainPointToView(Point3d var1, Point3d var2);

    public abstract double getSubjectSize();

    public abstract Vector3d getViewVector(Point3d var1);

    protected Camera() {
    }

    public Camera(Point3d pos, Point3d ref, Vector3d up, double near, double far) {
        this.d_pos = new Point3d(pos);
        this.d_ref = new Point3d(ref);
        this.d_up = new Vector3d(up);
        this.nativeConstructed(Camera.class);
        this.setClip(near, far);
    }

    @Override
    public Class resolveNativeClass() {
        return Camera.class;
    }

    public void setCustomTransform(Matrix4d xform) {
        this.d_customXform = xform;
        this.markNativeDirty();
    }

    public Matrix4d getCustomTransform() {
        return this.d_customXform;
    }

    public Matrix4d getInverseCustomTransform() {
        if (this.d_customXform == null) {
            return null;
        }
        Matrix4d inv = new Matrix4d(this.d_customXform);
        inv.invert();
        return inv;
    }

    protected AABox toView(AABox bb) {
        if (this.d_customXform == null) {
            return bb;
        }
        bb = new AABox(bb);
        bb.transformEq(this.d_customXform);
        return bb;
    }

    protected Vector3d toView(Vector3d v) {
        Matrix4d xform = this.getCustomTransform();
        return xform != null ? Util3D.xform(xform, v) : v;
    }

    protected Point3d toView(Point3d p) {
        Matrix4d xform = this.getCustomTransform();
        return xform != null ? Util3D.xform(xform, p) : p;
    }

    @Override
    public void writeNativeData(INativeStream writer) {
        writer.writeDoubles(this.d_pos.x, this.d_pos.y, this.d_pos.z);
        writer.writeDoubles(this.d_ref.x, this.d_ref.y, this.d_ref.z);
        writer.writeDoubles(this.d_up.x, this.d_up.y, this.d_up.z);
        writer.writeBoolean(this.d_customXform != null);
        if (this.d_customXform != null) {
            Matrix4d inverse = new Matrix4d(this.d_customXform);
            inverse.invert();
            Camera.write(writer, this.d_customXform);
            Camera.write(writer, inverse);
        }
    }

    private static void write(INativeStream writer, Matrix4d xform) {
        writer.writeDoubles(xform.m00, xform.m01, xform.m02, xform.m03, xform.m10, xform.m11, xform.m12, xform.m13, xform.m20, xform.m21, xform.m22, xform.m23, xform.m30, xform.m31, xform.m32, xform.m33);
    }

    public void setCopyCam(Camera cam) {
        Native.manager.execMethod(Camera.class, this, 10, cam);
    }

    public abstract Camera createCopyCam();

    public void addObserver(Observer ob) {
        this.d_observable.addObserver(ob);
    }

    public void removeObserver(Observer ob) {
        this.d_observable.deleteObserver(ob);
    }

    public void resetRotation() {
        Vector3d pos = new Vector3d(this.d_pos);
        this.d_up.set(0.0, 0.0, 1.0);
        this.d_ref.set(0.0, 1.0, 0.0);
        this.d_pos.set(0.0, 0.0, 0.0);
        this.d_ref.add(pos);
        this.d_pos.add(pos);
        this.markDirty();
    }

    public AABox ensureValidForReset(AABox bb, double maxVal) {
        return bb.ensureValidSize(maxVal, maxVal);
    }

    public void reset(AABox bb, int screenWidth, int screenHeight) {
        this.reset(new Vector3d(0.0, 0.0, -1.0), new Vector3d(0.0, 1.0, 0.0), bb, screenWidth, screenHeight);
    }

    public void reset(Vector3d viewDir, Vector3d upDir, AABox bb, int screenWidth, int screenHeight) {
        this.setZoom(new Point2d(0.0, 0.0), 1.0);
    }

    public void orbit(double deg, double ax, double ay, double az) {
        Vector3d localX = new Vector3d();
        Vector3d localY = new Vector3d();
        Vector3d localZ = new Vector3d();
        localZ.sub(this.d_pos, this.d_ref);
        localY.set(this.d_up);
        localX.cross(localY, localZ);
        localX.normalize();
        localY.normalize();
        localZ.normalize();
        localX.scale(ax);
        localY.scale(ay);
        localZ.scale(az);
        Vector3d newAxis = new Vector3d(localX);
        newAxis.add(localY);
        newAxis.add(localZ);
        double angle = deg * Math.PI / 180.0;
        AxisAngle4d axisAngle = new AxisAngle4d(newAxis, angle);
        Matrix3d rot = new Matrix3d();
        rot.set(axisAngle);
        Vector3d pos = new Vector3d();
        pos.sub(this.d_pos, this.d_ref);
        rot.transform(pos);
        this.d_pos.add(this.d_ref, pos);
        rot.transform(this.d_up);
        this.markDirty();
    }

    public void orbit(double deg, Vector3d axis) {
        this.orbit(deg, axis.x, axis.y, axis.z);
    }

    public void rotate(double deg, Vector3d rotVec) {
        double angle = deg * Math.PI / 180.0;
        AxisAngle4d axisAngle = new AxisAngle4d(rotVec, angle);
        Matrix3d rot = new Matrix3d();
        rot.set(axisAngle);
        Vector3d view = new Vector3d();
        view.sub(this.d_ref, this.d_pos);
        rot.transform(view);
        this.d_ref.add(this.d_pos, view);
        rot.transform(this.d_up);
        this.markDirty();
    }

    public void rotate(double deg, double ax, double ay, double az) {
        this.rotate(deg, new Vector3d(ax, ay, az));
    }

    public void translateWorld(Vector3d offset, boolean offsetRef) {
        this.d_pos.add(offset);
        if (offsetRef) {
            this.d_ref.add(offset);
        }
        this.markDirty();
    }

    public void translateWorld(double ox, double oy, double oz, boolean offsetRef) {
        this.translateWorld(new Vector3d(ox, oy, oz), offsetRef);
    }

    public void translateEye(Point3d loc, Vector3d offset) {
        Vector3d localX = new Vector3d();
        Vector3d localY = new Vector3d();
        Vector3d localZ = new Vector3d();
        localZ.sub(this.d_pos, this.d_ref);
        localY.set(this.d_up);
        localX.cross(localY, localZ);
        localX.normalize();
        localY.normalize();
        localZ.normalize();
        localX.scale(offset.x);
        localY.scale(offset.y);
        localZ.scale(offset.z);
        Vector3d newOffset = new Vector3d(0.0, 0.0, 0.0);
        newOffset.add(localX);
        newOffset.add(localY);
        newOffset.add(localZ);
        loc.add(newOffset);
    }

    public void translateEye(Vector3d offset, boolean offsetRef) {
        Vector3d localX = new Vector3d();
        Vector3d localY = new Vector3d();
        Vector3d localZ = new Vector3d();
        localZ.sub(this.d_pos, this.d_ref);
        localY.set(this.d_up);
        localX.cross(localY, localZ);
        localX.normalize();
        localY.normalize();
        localZ.normalize();
        localX.scale(offset.x);
        localY.scale(offset.y);
        localZ.scale(offset.z);
        Vector3d newOffset = new Vector3d(0.0, 0.0, 0.0);
        newOffset.add(localX);
        newOffset.add(localY);
        newOffset.add(localZ);
        this.d_pos.add(newOffset);
        if (offsetRef) {
            this.d_ref.add(newOffset);
        }
        this.markDirty();
    }

    public void translateEye(double x, double y, double z, boolean offsetRef) {
        Vector3d tmp = new Vector3d(x, y, z);
        this.translateEye(tmp, offsetRef);
    }

    public void zoomAboutPoint(double factor, Point2d locCamera) {
        Native.manager.execMethod(Camera.class, this, 14, factor, locCamera.x, locCamera.y);
    }

    public void zoom(double factor, Point2d zoomCenterCam) {
        Native.manager.execMethod(Camera.class, this, 13, factor, zoomCenterCam.x, zoomCenterCam.y);
    }

    public void setZoom(Point2d locCamera, double amount) {
        Native.manager.execMethod(Camera.class, this, 15, amount, locCamera.x, locCamera.y);
    }

    protected Pair<Double, Point2d> getFullZoom() {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 16, new Object[0]);
        Native.manager.flush();
        double z = Native.manager.readDouble();
        Point2d loc = new Point2d(Native.manager.readDouble(), Native.manager.readDouble());
        Native.manager.unlockWriteBuffer();
        return new Pair<Double, Point2d>(z, loc);
    }

    public double getZoom() {
        return (Double)this.getFullZoom().v1;
    }

    public Point2d getZoomLoc() {
        return (Point2d)this.getFullZoom().v2;
    }

    public void setPosition(Point3d pos) {
        this.d_pos.set(pos);
        this.markDirty();
    }

    public void setPosition(double x, double y, double z) {
        this.d_pos.set(x, y, z);
        this.markDirty();
    }

    public Point3d getPosition() {
        return new Point3d(this.d_pos);
    }

    public void setReference(Point3d ref) {
        this.d_ref.set(ref);
        this.markDirty();
    }

    public void setReference(double x, double y, double z) {
        this.d_ref.set(x, y, z);
        this.markDirty();
    }

    public Point3d getReference() {
        return new Point3d(this.d_ref);
    }

    public void setUpVector(Vector3d up) {
        this.d_up.set(up);
        this.markDirty();
    }

    public void setUpVector(double x, double y, double z) {
        this.d_up.set(x, y, z);
        this.markDirty();
    }

    public Vector3d getUpVector() {
        return new Vector3d(this.d_up);
    }

    public void setClip(double near, double far) {
        Native.manager.execMethod(Camera.class, this, 11, near, far);
    }

    public double[] getClip() {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 12, new Object[0]);
        Native.manager.flush();
        double[] result = new double[]{Native.manager.readDouble(), Native.manager.readDouble()};
        Native.manager.unlockWriteBuffer();
        return result;
    }

    public double getNearClip() {
        return this.getClip()[0];
    }

    public double getFarClip() {
        return this.getClip()[1];
    }

    public void fitClipping(AABox box) {
        this.fitClipping(box, 0.005);
    }

    public void fitClipping(AABox box, double tol) {
        Native.manager.execMethod(Camera.class, this, 17, box.getMinX(), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ(), tol);
    }

    public Vector3d getViewVector() {
        Vector3d view = new Vector3d();
        view.sub(this.d_ref, this.d_pos);
        return view;
    }

    public Vector3d getRightVector() {
        Vector3d up = this.getUpVector();
        Vector3d forward = this.getViewVector();
        Vector3d right = new Vector3d();
        right.cross(forward, up);
        return right;
    }

    public double getDistance() {
        return this.getViewVector().length();
    }

    public Plane3d getViewPlane() {
        Vector3d view = this.getViewVector();
        view.normalize();
        Point3d position = this.getPosition();
        double d = -position.x * view.x - position.y * view.y - position.z * view.z;
        return new Plane3d(view.x, view.y, view.z, d);
    }

    public Plane3d getRefPlane() {
        Vector3d view = this.getViewVector();
        view.normalize();
        Point3d ref = this.getReference();
        return new Plane3d(view, ref);
    }

    public Vector3d vecToPointAlongLocalAxis(Point3d point, int localAxis) {
        Vector3d axis = new Vector3d();
        switch (localAxis) {
            case 0: {
                axis.normalize(this.getViewVector());
                break;
            }
            case 2: {
                axis.normalize(this.getUpVector());
                break;
            }
            case 1: {
                axis.normalize(this.getRightVector());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Vector3d pointToCam = new Vector3d();
        pointToCam.sub(point, this.getPosition());
        double length = pointToCam.dot(axis);
        axis.scale(length);
        return axis;
    }

    public Matrix3d getLocalTransformLHR() {
        Vector3d up = this.getUpVector();
        up.normalize();
        Vector3d right = this.getRightVector();
        right.normalize();
        Vector3d forward = this.getViewVector();
        forward.normalize();
        return new Matrix3d(right.x, right.y, right.z, up.x, up.y, up.z, forward.x, forward.y, forward.z);
    }

    public Matrix3d getLocalTransformRHR() {
        Matrix3d mat = this.getLocalTransformLHR();
        mat.m20 = -mat.m20;
        mat.m21 = -mat.m21;
        mat.m22 = -mat.m22;
        return mat;
    }

    protected void markDirty() {
        this.markNativeDirty();
        this.d_observable.setChanged();
        this.d_observable.notifyObservers();
    }

    private static Point3d readP3d() {
        Native.manager.flush();
        double[] result = new double[3];
        Native.manager.readDoubles(result);
        return new Point3d(result);
    }

    private static Point4d readP4d() {
        Native.manager.flush();
        double[] result = new double[4];
        Native.manager.readDoubles(result);
        return new Point4d(result);
    }

    private static Matrix4d readMatrix4d() {
        Native.manager.flush();
        double[] result = new double[16];
        Native.manager.readDoubles(result);
        return new Matrix4d(result);
    }

    protected Point3d worldToLocal(Point3d world) {
        Matrix3d mat = this.getLocalTransformRHR();
        Point3d local = new Point3d(world);
        mat.transform(local);
        return local;
    }

    protected Point3d worldToView(Point3d world) {
        Point4d result = this.worldToView(new Point4d(world.x, world.y, world.z, 1.0));
        return theUtil.p4dTo3d(result);
    }

    protected Point4d worldToView(Point4d world) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 0, world.x, world.y, world.z, world.w);
        Point4d p = Camera.readP4d();
        Native.manager.unlockWriteBuffer();
        return p;
    }

    protected Point3d viewToWorld(Point3d view) {
        Point4d result = this.viewToWorld(new Point4d(view.x, view.y, view.z, 1.0));
        return theUtil.p4dTo3d(result);
    }

    protected Point4d viewToWorld(Point4d view) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 1, view.x, view.y, view.z, view.w);
        Point4d result = Camera.readP4d();
        Native.manager.unlockWriteBuffer();
        return result;
    }

    protected Point3d worldToScreen(Point3d world) {
        return this.worldToScreen(new Point4d(world.x, world.y, world.z, 1.0));
    }

    protected Point3d worldToScreen(Point4d world) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 2, world.x, world.y, world.z, world.w);
        Point3d p = Camera.readP3d();
        Native.manager.unlockWriteBuffer();
        return p;
    }

    protected Point3d screenToWorld(Point3d screen) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 3, screen.x, screen.y, screen.z);
        Point3d result = Camera.readP3d();
        Native.manager.unlockWriteBuffer();
        return result;
    }

    protected double screenToWorld(double lengthScreen, Point3d refWorld) {
        Point3d displayPos = this.worldToScreen(refWorld);
        return this.screenToWorld(lengthScreen, displayPos.z);
    }

    protected double screenToWorld(double lengthDisplay, double distFromCamera) {
        Point3d refWorld = this.screenToWorld(new Point3d(lengthDisplay, 0.0, distFromCamera));
        Point3d originWorld = this.screenToWorld(new Point3d(0.0, 0.0, distFromCamera));
        return refWorld.distance(originWorld);
    }

    protected Point3d viewToScreen(Point4d view) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 4, view.x, view.y, view.z, view.w);
        Point3d result = Camera.readP3d();
        Native.manager.unlockWriteBuffer();
        return result;
    }

    protected Point3d viewToScreen(Point3d view) {
        return this.viewToScreen(new Point4d(view.x, view.y, view.z, 1.0));
    }

    protected Point3d screenToView(Point3d screen) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 5, screen.x, screen.y, screen.z);
        Point3d result = Camera.readP3d();
        Native.manager.unlockWriteBuffer();
        return result;
    }

    protected double screenToView(double lengthScreen) {
        Point3d refView = this.screenToView(new Point3d(lengthScreen, 0.0, 0.0));
        Point3d originView = this.screenToView(new Point3d(0.0, 0.0, 0.0));
        return refView.distance(originView);
    }

    protected Point3d worldToCamera(Point3d world) {
        Point4d result = this.worldToCamera(new Point4d(world.x, world.y, world.z, 1.0));
        return theUtil.p4dTo3d(result);
    }

    protected Point4d worldToCamera(Point4d world) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 6, world.x, world.y, world.z, world.w);
        Point4d result = Camera.readP4d();
        Native.manager.unlockWriteBuffer();
        return result;
    }

    protected Point3d screenToCamera(Point3d screen) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 7, screen.x, screen.y, screen.z);
        Point3d result = Camera.readP3d();
        Native.manager.unlockWriteBuffer();
        return result;
    }

    public Matrix4d getMatrix(int type) {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(Camera.class, this, 9, type);
        Matrix4d mat = Camera.readMatrix4d();
        Native.manager.unlockWriteBuffer();
        return mat;
    }

    public abstract CameraRecord capture();

    public void apply(CameraRecord cc) {
        this.pauseUpdates();
        this.setPosition(cc.loc);
        this.setReference(cc.ref);
        this.setUpVector(cc.up);
        this.setZoom(cc.zoomLoc, cc.zoom);
        this.setClip(cc.near, cc.far);
        this.resumeUpdates();
    }
}

