/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultEditorKit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Modifiable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Validateable;

public abstract class guiField
extends JTextField
implements Modifiable,
Validateable {
    private static final long serialVersionUID = -8798676699661380879L;
    private static final String CUT = "cut-to-clipboard";
    private static final String COPY = "copy-to-clipboard";
    private static final String PASTE = "paste-from-clipboard";
    private static final String DELETE_SELECTION = "delete-selection";
    private static final String SELECT_ALL = "select-all";
    private boolean d_selectAll = true;
    private boolean d_validate = false;
    private Map<Object, Action> d_rightClickMenuActions;
    private JPopupMenu d_rightClickMenu;

    public guiField() {
        Dimension d = this.getPreferredSize();
        this.setPreferredSize(new Dimension(90, d.height));
        this.setHorizontalAlignment(2);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (guiField.this.d_selectAll) {
                            guiField.this.selectAll();
                        }
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    guiField.this.d_selectAll = true;
                    if (guiField.this.d_validate) {
                        guiField.this.validateData();
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                guiField.this.d_selectAll = false;
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                Component c = e.getComponent();
                if (c.isEnabled() && e.isPopupTrigger()) {
                    JPopupMenu menu = guiField.this.getRightClickMenu();
                    menu.setLocation(e.getPoint());
                    menu.show(c, e.getX(), e.getY());
                }
            }
        });
    }

    private JPopupMenu getRightClickMenu() {
        if (this.d_rightClickMenu == null) {
            this.d_rightClickMenu = new JPopupMenu();
            this.d_rightClickMenuActions = new HashMap<Object, Action>();
            DefaultEditorKit.CutAction cut = new DefaultEditorKit.CutAction();
            cut.putValue("Name", Intl.intl("Cut"));
            DefaultEditorKit.CopyAction copy = new DefaultEditorKit.CopyAction();
            copy.putValue("Name", Intl.intl("Copy"));
            DefaultEditorKit.PasteAction paste = new DefaultEditorKit.PasteAction();
            paste.putValue("Name", Intl.intl("Paste"));
            AbstractAction delete = new AbstractAction(Intl.intl("Delete")){
                private static final long serialVersionUID = 1398582832918844675L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    guiField.this.replaceSelection("");
                }
            };
            AbstractAction selectAll = new AbstractAction(Intl.intl("Select All")){
                private static final long serialVersionUID = -5283032343778516000L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    guiField.this.selectAll();
                }
            };
            this.d_rightClickMenuActions.put(CUT, cut);
            this.d_rightClickMenuActions.put(COPY, copy);
            this.d_rightClickMenuActions.put(PASTE, paste);
            this.d_rightClickMenuActions.put(DELETE_SELECTION, delete);
            this.d_rightClickMenuActions.put(SELECT_ALL, selectAll);
            this.d_rightClickMenu.add(cut);
            this.d_rightClickMenu.add(copy);
            this.d_rightClickMenu.add(paste);
            this.d_rightClickMenu.add(delete);
            this.d_rightClickMenu.addSeparator();
            this.d_rightClickMenu.add(selectAll);
        }
        String selText = this.getSelectedText();
        boolean canEdit = this.isEnabled() && this.isEditable();
        this.d_rightClickMenuActions.get(CUT).setEnabled(selText != null && canEdit);
        this.d_rightClickMenuActions.get(COPY).setEnabled(selText != null);
        this.d_rightClickMenuActions.get(PASTE).setEnabled(canEdit);
        this.d_rightClickMenuActions.get(DELETE_SELECTION).setEnabled(selText != null && canEdit);
        this.d_rightClickMenuActions.get(SELECT_ALL).setEnabled(!this.getText().isEmpty() && (selText == null || selText.length() < this.getText().length()));
        return this.d_rightClickMenu;
    }

    public void setAutoValidate(boolean flag) {
        this.d_validate = flag;
    }

    protected boolean shouldValidate() {
        return this.isEnabled();
    }

    protected void showMessageBox(String msg) {
        this.showMessageBox(msg, false);
    }

    protected void showMessageBox(String msg, boolean removeFocusListeners) {
        FocusListener[] listeners = null;
        if (removeFocusListeners) {
            for (FocusListener listener : listeners = this.getFocusListeners()) {
                this.removeFocusListener(listener);
            }
        }
        Window parent = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        JOptionPane.showMessageDialog(parent, msg, Intl.intl("Invalid Entry"), 2);
        if (removeFocusListeners) {
            for (FocusListener listener : listeners) {
                this.addFocusListener(listener);
            }
        }
    }

    protected void requestFocusHack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                guiField.this.requestFocus();
            }
        });
    }

    public boolean validateData() {
        return this.validateData(true, true);
    }
}

