/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiLabel;

public class GridBagHelper {
    public static int REMAINING = 0;
    public static final int DEF_COL_SPACE = 6;
    public static final int DEF_ROW_SPACE = 6;
    public static final int DEF_INDENT = 18;
    public static final Anchor DEF_ANCHOR = Anchor.LEFT;
    public static final double DEF_FILL = 0.0;
    private final Container d_panel;
    public int d_colSpace;
    public int d_rowSpace;
    public int d_indent;
    public Anchor d_anchor;
    public double d_hfill;
    public double d_vfill;
    private boolean d_firstRowAdded = true;
    private int d_currRow;
    private int d_currCol;
    private int d_indentLevel;

    public GridBagHelper(Container panel, boolean setBorder, int colSpace, int rowSpace) {
        this.d_panel = panel;
        if (!(panel.getLayout() instanceof GridBagLayout)) {
            panel.setLayout(new GridBagLayout());
        }
        this.d_colSpace = colSpace;
        this.d_rowSpace = rowSpace;
        this.d_indent = 18;
        this.d_anchor = DEF_ANCHOR;
        this.d_vfill = 0.0;
        this.d_hfill = 0.0;
        this.d_currCol = 0;
        this.d_currRow = 0;
        this.d_indentLevel = 0;
        if (setBorder) {
            this.addBorder();
        }
    }

    public GridBagHelper(Container panel) {
        this(panel, false, 6, 6);
    }

    public GridBagHelper(Container panel, boolean setBorder) {
        this(panel, setBorder, 6, 6);
    }

    public void setCurrentRow(int row) {
        this.d_currRow = row;
    }

    public int getCurrentRow() {
        return this.d_currRow;
    }

    public void indent(boolean forward) {
        if (forward) {
            this.indent();
        } else {
            this.unindent();
        }
    }

    public void indent() {
        ++this.d_indentLevel;
    }

    public void unindent() {
        --this.d_indentLevel;
    }

    public void addFilledRow(Object component) {
        this.addRow(component, 1.0, REMAINING);
    }

    public void addIdentRow(Object ... components) {
        this.indent(true);
        this.addRow(components);
        this.indent(false);
    }

    public void addRow(Object ... components) {
        int m;
        for (m = 0; m < components.length; ++m) {
            if (!(components[m] instanceof String)) continue;
            components[m] = new guiLabel((String)components[m]);
        }
        m = 0;
        while (m < components.length) {
            if (components[m] != null && !(components[m] instanceof Component)) {
                ++m;
                continue;
            }
            Component comp = (Component)components[m];
            m = this.addCol(comp, components, m + 1);
        }
        this.nextRow();
    }

    public void nextRow() {
        ++this.d_currRow;
        this.d_firstRowAdded = false;
        this.d_currCol = 0;
    }

    public void addCol(Component comp, Object ... constraints) {
        this.addCol(comp, constraints, 0);
    }

    public void addCol(String lbl, Object ... contraints) {
        this.addCol((Component)new guiLabel(lbl), contraints);
    }

    public int addCol(Component comp, Object[] constraints, int constraintBegin) {
        int colLeft;
        Object mod;
        int m;
        int left = this.d_indentLevel * this.d_indent;
        int top = this.d_firstRowAdded ? 0 : this.d_rowSpace;
        double hfill = this.d_hfill;
        double vfill = this.d_vfill;
        int numCols = 1;
        int numRows = 1;
        Anchor anchor = this.d_anchor;
        for (m = constraintBegin; m < constraints.length && !((mod = constraints[m]) instanceof Component) && mod != null; ++m) {
            if (mod instanceof Anchor) {
                anchor = (Anchor)((Object)mod);
                continue;
            }
            if (mod instanceof Double) {
                hfill = (Double)mod;
                continue;
            }
            if (mod instanceof double[]) {
                hfill = ((double[])mod)[0];
                vfill = ((double[])mod)[1];
                continue;
            }
            if (mod instanceof Integer) {
                numCols = (Integer)mod;
                continue;
            }
            if (!(mod instanceof int[])) continue;
            numCols = ((int[])mod)[0];
            numRows = ((int[])mod)[1];
        }
        int n = colLeft = this.d_currCol == 0 ? left : this.d_colSpace;
        if (comp == null) {
            this.d_currCol += numCols;
            return m;
        }
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = hfill == 0.0 && vfill == 0.0 ? 0 : (hfill == 0.0 ? 3 : (vfill == 0.0 ? 2 : 1));
        cons.weightx = hfill;
        cons.weighty = vfill;
        switch (anchor.ordinal()) {
            case 0: {
                cons.anchor = 18;
                break;
            }
            case 1: {
                cons.anchor = 11;
                break;
            }
            case 2: {
                cons.anchor = 12;
                break;
            }
            case 3: {
                cons.anchor = 17;
                break;
            }
            case 4: {
                cons.anchor = 10;
                break;
            }
            case 5: {
                cons.anchor = 13;
                break;
            }
            case 6: {
                cons.anchor = 16;
                break;
            }
            case 7: {
                cons.anchor = 15;
                break;
            }
            case 8: {
                cons.anchor = 14;
            }
        }
        cons.gridx = this.d_currCol;
        cons.gridy = this.d_currRow;
        cons.gridwidth = numCols;
        cons.gridheight = numRows;
        cons.insets = new Insets(top, colLeft, 0, 0);
        this.d_panel.add(comp, cons);
        this.d_currCol += numCols;
        return m;
    }

    public void finalizeRows() {
        GridBagUtil.addGlue(this.d_panel);
    }

    public void addBorder() {
        this.addBorder(12, 12, 12, 12);
    }

    public void addBorder(int top, int left, int bottom, int right) {
        if (this.d_panel instanceof JComponent) {
            ((JComponent)this.d_panel).setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
        }
    }

    public static enum Anchor {
        TOP_LEFT,
        TOP,
        TOP_RIGHT,
        LEFT,
        CENTER,
        RIGHT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT;

    }
}

