/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JPanel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Series;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;

public class Graph
extends JPanel {
    private static final long serialVersionUID = -3669781768695711115L;
    private final RenderingHints AA_ON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private final RenderingHints AA_OFF = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    public static final int AUTO = -1;
    public static final int SOLID = 0;
    public static final int DASH = 1;
    public static final int DOT = 2;
    public static final int DASH_DOT = 3;
    public static final int DASH_DOT_DOT = 4;
    public static final int NO_LINE = 5;
    public static final int SQUARE = 6;
    public static final int DIAMOND = 7;
    public static final int TRIANGLE = 8;
    public static final int CIRCLE = 9;
    public static final int SQUARE_OUTLINE = 10;
    public static final int DIAMOND_OUTLINE = 11;
    public static final int TRIANGLE_OUTLINE = 12;
    public static final int CIRCLE_OUTLINE = 13;
    public static final int NO_MARK = 14;
    private static final int TOP = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 3;
    public static final int COLORS = 0;
    public static final int PATTERNS = 1;
    public static final int COLORS_AND_PATTERNS = 2;
    private int d_autoMode = 2;
    private int d_gridlines = 0;
    private float d_size = 0.0f;
    private DateFormat d_axisTimeFormat = null;
    private boolean d_autoRangeX = true;
    private boolean d_autoRangeY = true;
    private double d_xmin;
    private double d_xmax;
    private double d_ymin;
    private double d_ymax;
    private boolean d_showLegend = false;
    private String d_title = "";
    private String d_xTitle = "";
    private String d_yTitle = "";
    private Set<Series> series;
    private AffineTransform transform;
    private AffineTransform inverse;
    private int curr = 0;
    private int currStyle = 0;
    private double xmin = Double.MAX_VALUE;
    private double xmax = -1.7976931348623157E308;
    private double ymin = Double.MAX_VALUE;
    private double ymax = -1.7976931348623157E308;
    private double xinc = 0.0;
    private double yinc = 0.0;
    private Set<Annotation> d_annotations;
    private Color[] colors = new Color[]{SystemColor.windowText, Color.blue, Color.red, Color.green, Color.magenta, Color.orange, Color.cyan, Color.gray, Color.pink, Color.yellow};
    private int[] styles = new int[]{0, 1, 2, 3, 4};
    private int[] markers = new int[]{6, 7, 8, 9, 10, 11, 12, 13};
    private int[] weights = new int[]{1, 3};

    public void setAutoMode(int mode) {
        this.d_autoMode = mode;
    }

    public int getAutoMode() {
        return this.d_autoMode;
    }

    public void setGridlines(int mode) {
        this.d_gridlines = mode;
    }

    public int getGridlines() {
        return this.d_gridlines;
    }

    public Graph() {
        this.series = new LinkedHashSet<Series>();
        this.d_annotations = new HashSet<Annotation>();
        this.transform = new AffineTransform();
    }

    public void reset() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Graph.this.series.clear();
                Graph.this.d_annotations.clear();
            }
        });
    }

    public void addSeries(final Series s) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Graph.this.series.add(s);
            }
        });
    }

    public void removeSeries(final Series s) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Graph.this.series.remove(s);
            }
        });
    }

    public boolean addAnnotation(Annotation a) {
        return this.d_annotations.add(a);
    }

    public boolean removeAnnotation(Annotation a) {
        return this.d_annotations.remove(a);
    }

    public void setLegendVisible(boolean flag) {
        this.d_showLegend = flag;
    }

    private void updateTransform() {
        this.updateAxes();
        Dimension dim = this.getSize();
        this.transform.setToIdentity();
        this.transform.scale((double)dim.width / (this.xmax - this.xmin) / 1.4, -((double)dim.height) / (this.ymax - this.ymin) / 1.3);
        this.transform.translate(-(this.xmin - 0.2 * (this.xmax - this.xmin)), -(this.ymax + 0.15 * (this.ymax - this.ymin)));
        try {
            this.inverse = new AffineTransform(this.transform);
            this.inverse.invert();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            this.inverse = null;
        }
    }

    public void setAutoRangeX(boolean flag) {
        this.d_autoRangeX = flag;
    }

    public boolean getAutoRangeX() {
        return this.d_autoRangeX;
    }

    public void setAutoRangeY(boolean flag) {
        this.d_autoRangeY = flag;
    }

    public boolean getAutoRangeY() {
        return this.d_autoRangeY;
    }

    public void setRangeX(double min, double max) {
        this.d_xmin = min;
        this.d_xmax = max;
    }

    public void setRangeY(double min, double max) {
        this.d_ymin = min;
        this.d_ymax = max;
    }

    public double getMinX() {
        return this.d_xmin;
    }

    public double getMaxX() {
        return this.d_xmax;
    }

    public double getMinY() {
        return this.d_ymin;
    }

    public double getMaxY() {
        return this.d_ymax;
    }

    private void calcGlobalBounds() {
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        for (Series s : this.series) {
            if (s.getMinX() < xmin) {
                xmin = s.getMinX();
            }
            if (s.getMaxX() > xmax) {
                xmax = s.getMaxX();
            }
            if (s.getMinY() < ymin) {
                ymin = s.getMinY();
            }
            if (!(s.getMaxY() > ymax)) continue;
            ymax = s.getMaxY();
        }
        if (this.d_autoRangeX) {
            this.d_xmin = xmin;
            this.d_xmax = xmax;
        }
        if (this.d_autoRangeY) {
            this.d_ymin = ymin;
            this.d_ymax = ymax;
        }
        if (this.d_xmin == this.d_xmax) {
            this.d_xmin -= 0.1;
            this.d_xmax += 0.1;
        }
        if (this.d_ymin == this.d_ymax) {
            this.d_ymin -= 0.1;
            this.d_ymax += 0.1;
        }
    }

    private void updateAxes() {
        this.calcGlobalBounds();
        double xrange = this.d_xmax - this.d_xmin;
        if (xrange == 0.0) {
            xrange = 0.2;
        }
        this.xinc = Math.log(xrange) / Math.log(10.0);
        this.xinc = Math.floor(this.xinc);
        this.xinc = Math.pow(10.0, this.xinc);
        if (xrange / this.xinc < 2.0) {
            this.xinc /= 5.0;
        } else if (xrange / this.xinc < 5.0) {
            this.xinc /= 2.0;
        }
        this.xmin = Math.floor(this.d_xmin / this.xinc) * this.xinc;
        this.xmax = Math.ceil(this.d_xmax / this.xinc) * this.xinc;
        double yrange = this.d_ymax - this.d_ymin;
        if (yrange == 0.0) {
            yrange = 0.2;
        }
        this.yinc = Math.log(yrange) / Math.log(10.0);
        this.yinc = Math.floor(this.yinc);
        this.yinc = Math.pow(10.0, this.yinc);
        if (yrange / this.yinc < 2.0) {
            this.yinc /= 5.0;
        } else if (yrange / this.yinc < 5.0) {
            this.yinc /= 2.0;
        }
        this.ymin = Math.floor(this.d_ymin / this.yinc) * this.yinc;
        this.ymax = Math.ceil(this.d_ymax / this.yinc) * this.yinc;
    }

    public void setAxisTimeFormat(DateFormat df) {
        this.d_axisTimeFormat = df;
    }

    public Stroke getStroke(Series s) {
        int weight;
        int style = s.getLineType();
        if (style == 5) {
            return null;
        }
        if (style == -1) {
            style = this.getAutoLineStyle(s);
        }
        if ((weight = s.getWeight()) == -1) {
            weight = this.getAutoWeight(s);
        }
        float[] dash = new float[]{16.0f, 4.0f};
        float[] dot = new float[]{4.0f, 4.0f};
        float[] dashdot = new float[]{15.0f, 4.0f, 4.0f, 4.0f};
        float[] dashdotdot = new float[]{16.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f};
        switch (style) {
            case 0: {
                return new BasicStroke(weight);
            }
            case 1: {
                return new BasicStroke(weight, 0, 0, 10.0f, dash, 0.0f);
            }
            case 2: {
                return new BasicStroke(weight, 0, 0, 10.0f, dot, 0.0f);
            }
            case 3: {
                return new BasicStroke(weight, 0, 0, 10.0f, dashdot, 0.0f);
            }
            case 4: {
                return new BasicStroke(weight, 0, 0, 10.0f, dashdotdot, 0.0f);
            }
        }
        return null;
    }

    private void drawSeries(Graphics2D gra, Series series) {
        GeneralPath path = new GeneralPath();
        double[] x = series.getX();
        double[] y = series.getY();
        double[] pts = new double[2 * x.length];
        for (int i = 0; i < x.length; ++i) {
            pts[2 * i] = x[i];
            pts[2 * i + 1] = y[i];
        }
        this.transform.transform(pts, 0, pts, 0, x.length);
        if (x.length == 0) {
            return;
        }
        Stroke oldStroke = gra.getStroke();
        Color color = series.getColor();
        if (color == null) {
            color = this.getAutoColor(series);
        }
        gra.setPaint(color);
        if (series.getLineType() == 5) {
            return;
        }
        Stroke stroke = this.getStroke(series);
        assert (stroke != null);
        gra.setStroke(stroke);
        Point2D.Double pt1 = new Point2D.Double(this.xmin, this.ymax);
        Point2D.Double pt2 = new Point2D.Double(this.xmax, this.ymin);
        this.transform.transform(pt1, pt1);
        this.transform.transform(pt2, pt2);
        Shape s = gra.getClip();
        gra.clipRect((int)((Point2D)pt1).getX(), (int)((Point2D)pt1).getY(), (int)(((Point2D)pt2).getX() - ((Point2D)pt1).getX()), (int)(((Point2D)pt2).getY() - ((Point2D)pt1).getY()));
        boolean drawing = false;
        for (int i = 0; i < x.length - 1; ++i) {
            if (x[i] < this.xmin && x[i + 1] < this.xmin || x[i] > this.xmax && x[i + 1] > this.xmax || y[i] < this.ymin && y[i + 1] < this.ymin || y[i] > this.ymax && y[i + 1] > this.ymax) {
                drawing = false;
                continue;
            }
            if (!drawing) {
                path.moveTo((float)pts[2 * i], (float)pts[2 * i + 1]);
                drawing = true;
            }
            path.lineTo((float)pts[2 * (i + 1)], (float)pts[2 * (i + 1) + 1]);
        }
        gra.draw(path);
        gra.setClip(s);
        gra.setStroke(oldStroke);
    }

    private void drawMarkers(Graphics2D gra, Series series) {
        double[] x = series.getX();
        double[] y = series.getY();
        double[] coord = new double[2];
        block10: for (int i = 0; i < x.length; ++i) {
            if (x[i] < this.xmin || x[i] > this.xmax || y[i] < this.ymin || y[i] > this.ymax) continue;
            coord[0] = x[i];
            coord[1] = y[i];
            this.transform.transform(coord, 0, coord, 0, 1);
            int mark = series.getMarkType();
            if (mark == -1) {
                mark = this.getAutoMarkStyle(series);
            }
            switch (mark) {
                case 6: {
                    this.drawSquare(gra, (float)coord[0], (float)coord[1], 1);
                    continue block10;
                }
                case 7: {
                    this.drawDiamond(gra, (float)coord[0], (float)coord[1], 1);
                    continue block10;
                }
                case 8: {
                    this.drawTriangle(gra, (float)coord[0], (float)coord[1], 1);
                    continue block10;
                }
                case 9: {
                    this.drawCircle(gra, (float)coord[0], (float)coord[1], 1);
                    continue block10;
                }
                case 10: {
                    this.drawSquare(gra, (float)coord[0], (float)coord[1], 0);
                    continue block10;
                }
                case 11: {
                    this.drawDiamond(gra, (float)coord[0], (float)coord[1], 0);
                    continue block10;
                }
                case 12: {
                    this.drawTriangle(gra, (float)coord[0], (float)coord[1], 0);
                    continue block10;
                }
                case 13: {
                    this.drawCircle(gra, (float)coord[0], (float)coord[1], 0);
                }
            }
        }
    }

    private void drawSquare(Graphics2D gra, float x, float y, int filled) {
        Rectangle2D.Float square = new Rectangle2D.Float(x - 3.0f * this.d_size, y - 3.0f * this.d_size, 6.0f * this.d_size, 6.0f * this.d_size);
        if (filled == 0) {
            gra.draw(square);
        } else {
            gra.fill(square);
        }
    }

    private void drawDiamond(Graphics2D gra, float x, float y, int filled) {
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y - 4.0f * this.d_size);
        path.lineTo(x + 4.0f * this.d_size, y);
        path.lineTo(x, y + 4.0f * this.d_size);
        path.lineTo(x - 4.0f * this.d_size, y);
        path.closePath();
        if (filled == 0) {
            gra.draw(path);
        } else {
            gra.fill(path);
        }
    }

    private void drawTriangle(Graphics2D gra, float x, float y, int filled) {
        GeneralPath path = new GeneralPath();
        path.moveTo(x - 4.0f * this.d_size, y + 2.0f * this.d_size);
        path.lineTo(x + 4.0f * this.d_size, y + 2.0f * this.d_size);
        path.lineTo(x, y - 4.0f * this.d_size);
        path.closePath();
        if (filled == 0) {
            gra.draw(path);
        } else {
            gra.fill(path);
        }
    }

    private void drawCircle(Graphics2D gra, float x, float y, int filled) {
        Arc2D.Float circle = new Arc2D.Float(x - 3.5f * this.d_size, y - 3.5f * this.d_size, 7.0f * this.d_size, 7.0f * this.d_size, 0.0f, 360.0f, 0);
        if (filled == 0) {
            gra.draw(circle);
        } else {
            gra.fill(circle);
        }
    }

    private void drawGridlines(Graphics2D gra) {
        int i;
        GeneralPath path = new GeneralPath();
        int numGrids = (int)((this.xmax - this.xmin) / this.xinc);
        for (i = 1; i < numGrids; ++i) {
            path.moveTo((float)(this.xmin + (double)i * this.xinc), (float)this.ymin);
            path.lineTo((float)(this.xmin + (double)i * this.xinc), (float)this.ymax);
        }
        path.transform(this.transform);
        gra.draw(path);
        path.reset();
        numGrids = (int)((this.ymax - this.ymin) / this.yinc);
        for (i = 1; i < numGrids; ++i) {
            path.moveTo((float)this.xmin, (float)(this.ymin + (double)i * this.yinc));
            path.lineTo((float)this.xmax, (float)(this.ymin + (double)i * this.yinc));
        }
        path.transform(this.transform);
        gra.draw(path);
    }

    private void drawAxes(Graphics2D gra) {
        int i;
        Point2D.Double x1 = new Point2D.Double(this.xmin, 0.0);
        Point2D.Double x2 = new Point2D.Double(this.xmax, 0.0);
        if (this.ymax < 0.0) {
            ((Point2D)x1).setLocation(this.xmin, this.ymax);
            ((Point2D)x2).setLocation(this.xmax, this.ymax);
        } else if (this.ymin > 0.0) {
            ((Point2D)x1).setLocation(this.xmin, this.ymin);
            ((Point2D)x2).setLocation(this.xmax, this.ymin);
        }
        Point2D.Double y1 = new Point2D.Double(0.0, this.ymin);
        Point2D.Double y2 = new Point2D.Double(0.0, this.ymax);
        if (this.xmax < 0.0) {
            ((Point2D)y1).setLocation(this.xmax, this.ymin);
            ((Point2D)y2).setLocation(this.xmax, this.ymax);
        } else if (this.xmin > 0.0) {
            ((Point2D)y1).setLocation(this.xmin, this.ymin);
            ((Point2D)y2).setLocation(this.xmin, this.ymax);
        }
        Point2D.Double x1n = new Point2D.Double();
        Point2D.Double x2n = new Point2D.Double();
        Point2D.Double y1n = new Point2D.Double();
        Point2D.Double y2n = new Point2D.Double();
        this.transform.transform(x1, x1n);
        this.transform.transform(x2, x2n);
        this.transform.transform(y1, y1n);
        this.transform.transform(y2, y2n);
        Line2D.Double xAxis = new Line2D.Double(x1, x2);
        Line2D.Double yAxis = new Line2D.Double(y1, y2);
        Line2D.Double xAxis2 = new Line2D.Double(x1n, x2n);
        Line2D.Double yAxis2 = new Line2D.Double(y1n, y2n);
        gra.draw(xAxis2);
        gra.draw(yAxis2);
        NumberFormat nf = NumberFormat.getNumberInstance();
        ((DecimalFormat)nf).applyPattern("0.00E00");
        Point2D.Double pt = new Point2D.Double();
        GeneralPath ticks = new GeneralPath();
        int numGrids = (int)((this.xmax - this.xmin) / this.xinc);
        for (i = 0; i <= numGrids; ++i) {
            pt.x = this.xmin + (double)i * this.xinc;
            pt.y = xAxis.y1;
            this.transform.transform(pt, pt);
            ticks.moveTo((float)pt.x, (float)(pt.y - (double)(4.0f * this.d_size)));
            ticks.lineTo((float)pt.x, (float)(pt.y + (double)(4.0f * this.d_size)));
        }
        gra.draw(ticks);
        ticks.reset();
        numGrids = (int)((this.ymax - this.ymin) / this.yinc);
        for (i = 0; i <= numGrids; ++i) {
            pt.x = yAxis.x1;
            pt.y = this.ymin + (double)i * this.yinc;
            this.transform.transform(pt, pt);
            ticks.moveTo((float)(pt.x - (double)(4.0f * this.d_size)), (float)pt.y);
            ticks.lineTo((float)(pt.x + (double)(4.0f * this.d_size)), (float)pt.y);
        }
        gra.draw(ticks);
        pt.x = (this.xmin + this.xmax) / 2.0;
        pt.y = xAxis.y1;
        if (this.d_gridlines != 0) {
            pt.y = this.ymin;
        }
        pt.y = (this.ymin + this.ymax) / 2.0;
        pt.x = this.xmin;
        this.transform.transform(pt, pt);
    }

    private void drawLabels(Graphics2D gra) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        ((DecimalFormat)nf).applyPattern("0.00E00");
        Point2D.Double pt = new Point2D.Double();
        int numGrids = (int)((this.xmax - this.xmin) / this.xinc);
        double xAxisLoc = 0.0;
        int align = 0;
        float offset = 8.0f * this.d_size;
        if (this.ymax <= 0.0) {
            xAxisLoc = this.ymax;
            align = 3;
            offset = -offset;
        } else if (this.ymin > 0.0 || this.d_gridlines != 0) {
            xAxisLoc = this.ymin;
        }
        if (this.d_axisTimeFormat != null) {
            gra.setFont(new Font("SansSerif", 0, (int)(10.0f * this.d_size)));
            for (i = 0; i <= numGrids; ++i) {
                pt.x = this.xmin + (double)i * this.xinc;
                pt.y = xAxisLoc;
                this.transform.transform(pt, pt);
                this.drawText(gra, this.d_axisTimeFormat.format(new Date((long)(this.xmin + (double)i * this.xinc))), (float)pt.x, (float)pt.y + offset, align);
            }
        } else {
            gra.setFont(new Font("SansSerif", 0, (int)(14.0f * this.d_size)));
            for (i = 0; i <= numGrids; ++i) {
                pt.x = this.xmin + (double)i * this.xinc;
                pt.y = xAxisLoc;
                this.transform.transform(pt, pt);
                this.drawText(gra, Global.formatGraph(this.xmin + (double)i * this.xinc), (float)pt.x, (float)pt.y + offset, align);
            }
        }
        numGrids = (int)((this.ymax - this.ymin) / this.yinc);
        double yAxisLoc = 0.0;
        align = 2;
        offset = -10.0f * this.d_size;
        if (this.xmax < 0.0) {
            yAxisLoc = this.xmax;
            align = 1;
            offset = -offset;
        } else if (this.xmin > 0.0 || this.d_gridlines != 0) {
            yAxisLoc = this.xmin;
        }
        for (int i = 0; i <= numGrids; ++i) {
            pt.x = yAxisLoc;
            pt.y = this.ymin + (double)i * this.yinc;
            this.transform.transform(pt, pt);
            this.drawText(gra, Global.formatGraph(this.ymin + (double)i * this.yinc), (float)pt.x + offset, (float)pt.y, align);
        }
        pt.x = (this.xmin + this.xmax) / 2.0;
        pt.y = this.ymin;
        this.transform.transform(pt, pt);
        gra.setFont(new Font("SansSerif", 0, (int)(18.0f * this.d_size)));
        this.drawText(gra, this.d_xTitle, (float)pt.x, (float)pt.y + 25.0f * this.d_size, 0);
        pt.y = (this.ymin + this.ymax) / 2.0;
        pt.x = this.xmin;
        this.transform.transform(pt, pt);
        AffineTransform oldTransform = gra.getTransform();
        AffineTransform newTransform = (AffineTransform)oldTransform.clone();
        newTransform.rotate(-1.5707963267948966, pt.x, pt.y);
        gra.setTransform(newTransform);
        this.drawText(gra, this.d_yTitle, (float)pt.x, (float)(pt.y - (double)(75.0f * this.d_size)), 3);
        gra.setTransform(oldTransform);
    }

    private void drawText(Graphics2D gra, String str, float x, float y, int align) {
        FontMetrics fm = gra.getFontMetrics();
        int height = fm.getAscent();
        int width = fm.stringWidth(str);
        switch (align) {
            case 0: {
                x = (int)((double)x - (double)width / 2.0);
                y += (float)height;
                break;
            }
            case 1: {
                y += (float)((int)((double)height / 2.0));
                break;
            }
            case 2: {
                x -= (float)width;
                y += (float)((int)((double)height / 2.0));
                break;
            }
            case 3: {
                x -= (float)((int)((double)width / 2.0));
            }
        }
        gra.drawString(str, x, y);
    }

    public void drawAnnotation(Graphics2D g, Annotation a) {
        if (this.inverse == null) {
            return;
        }
        double x = a.point.getX();
        double y = a.point.getY();
        double r = 6.0;
        double wxr = Math.abs(this.inverse.getScaleX() * r);
        double wyr = Math.abs(this.inverse.getScaleY() * r);
        Arc2D.Double circleBack = new Arc2D.Double(x - wxr, y - wyr, 2.0 * wxr, 2.0 * wyr, 0.0, 360.0, 0);
        r = 4.0;
        wxr = Math.abs(this.inverse.getScaleX() * r);
        wyr = Math.abs(this.inverse.getScaleY() * r);
        Arc2D.Double circleFore = new Arc2D.Double(x - wxr, y - wyr, 2.0 * wxr, 2.0 * wyr, 0.0, 360.0, 0);
        AffineTransform old = new AffineTransform(g.getTransform());
        g.transform(this.transform);
        g.setColor(SystemColor.window);
        g.fill(circleBack);
        g.setColor(a.color);
        g.fill(circleFore);
        g.setTransform(old);
        g.setFont(new Font("Monospaced", 0, (int)(18.0 * Math.min(0.8, (double)this.d_size))));
        FontMetrics fMetrics = g.getFontMetrics();
        Rectangle2D strRect = fMetrics.getStringBounds(a.text, g);
        g.setColor(SystemColor.windowText);
        Point2D.Double textPoint = new Point2D.Double(x, y);
        this.transform.transform(textPoint, textPoint);
        g.drawString(a.text, (float)(((Point2D)textPoint).getX() - strRect.getWidth() / 2.0), (float)(((Point2D)textPoint).getY() - strRect.getHeight() / 2.0));
    }

    public void drawLegend(Graphics2D g) {
        if (this.series.isEmpty()) {
            return;
        }
        int textWidth = 0;
        g.setFont(new Font("Monospaced", 0, (int)(18.0 * Math.min(0.8, (double)this.d_size))));
        FontMetrics fm = g.getFontMetrics();
        for (Series s : this.series) {
            textWidth = Math.max(textWidth, fm.stringWidth(s.getName()));
        }
        int rowHeight = fm.getMaxAscent() + fm.getMaxDescent() + 6;
        int leftBoundX = this.getWidth() - 12 - textWidth;
        int top = (int)(10.0f * this.d_size) + 2 * rowHeight;
        int lineLen = 40;
        for (Series s : this.series) {
            g.setStroke(this.getStroke(s));
            g.setColor(s.getColor());
            Line2D.Double line = new Line2D.Double(leftBoundX, top + rowHeight / 2, leftBoundX + lineLen, top + rowHeight / 2);
            g.draw(line);
            g.setColor(SystemColor.windowText);
            this.drawText(g, s.getName(), leftBoundX, top, 1);
            top += rowHeight;
        }
    }

    @Override
    public void paint(Graphics g) {
        this.d_size = (float)this.getWidth() / 800.0f;
        this.updateTransform();
        Graphics2D gra = (Graphics2D)g;
        gra.addRenderingHints(this.AA_OFF);
        gra.setColor(SystemColor.window);
        gra.fill(new Rectangle(this.getSize()));
        Rectangle2D.Double rect = new Rectangle2D.Double(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
        gra.setColor(SystemColor.windowText);
        Point2D.Double pt = new Point2D.Double(this.xmin, this.ymin);
        this.transform.transform(pt, pt);
        pt.x = this.xmax;
        pt.y = this.ymax;
        this.transform.transform(pt, pt);
        if (this.d_gridlines != 0) {
            gra.setPaint(Color.gray);
            this.drawGridlines(gra);
            gra.setPaint(Color.black);
            gra.draw(this.transform.createTransformedShape(rect));
        }
        gra.setStroke(new BasicStroke(2.0f));
        this.drawAxes(gra);
        gra.addRenderingHints(this.AA_ON);
        gra.setPaint(Color.blue);
        gra.setStroke(new BasicStroke(1.0f));
        for (Series s : this.series) {
            this.drawSeries(gra, s);
            this.drawMarkers(gra, s);
        }
        gra.addRenderingHints(this.AA_OFF);
        gra.setPaint(Color.black);
        this.drawLabels(gra);
        gra.setFont(new Font("SansSerif", 0, (int)(24.0f * this.d_size)).deriveFont(1));
        this.drawText(gra, this.d_title, (float)((double)this.getSize().width / 2.0), 10.0f * this.d_size, 0);
        for (Annotation a : this.d_annotations) {
            this.drawAnnotation(gra, a);
        }
        if (this.d_showLegend) {
            this.drawLegend(gra);
        }
    }

    public void setTitle(String title) {
        this.d_title = title;
    }

    public void setXTitle(String title) {
        this.d_xTitle = title;
    }

    public void setYTitle(String title) {
        this.d_yTitle = title;
    }

    private int getAutoMarkStyle(Series s) {
        return this.markers[s.getId() % this.markers.length];
    }

    private Color getAutoColor(Series s) {
        if (this.d_autoMode == 1) {
            return this.colors[0];
        }
        return this.colors[s.getId() % this.colors.length];
    }

    private int getAutoLineStyle(Series s) {
        if (this.d_autoMode == 0) {
            return 0;
        }
        if (this.d_autoMode == 1) {
            return this.styles[s.getId() % this.styles.length];
        }
        return this.styles[s.getId() / this.colors.length % this.styles.length];
    }

    private int getAutoWeight(Series s) {
        if (this.d_autoMode == 0) {
            return this.weights[s.getId() / this.colors.length % this.weights.length];
        }
        if (this.d_autoMode == 1) {
            return this.weights[s.getId() / this.styles.length % this.weights.length];
        }
        return this.weights[s.getId() / this.colors.length / this.styles.length % this.weights.length];
    }

    public boolean pickPoint(int sx, int sy, int pxTol, PickPointVal dest) {
        assert (dest != null);
        Point2D.Double ptScreen = new Point2D.Double(sx, sy);
        Point2D.Double ptWorld = new Point2D.Double();
        Point2D.Double tolWorld = null;
        try {
            this.inverse.transform(ptScreen, ptWorld);
            tolWorld = new Point2D.Double(this.inverse.getScaleX() * (double)pxTol, this.inverse.getScaleY() * (double)pxTol);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        double distMin = tolWorld.distance(0.0, 0.0);
        Series seriesMin = null;
        int ixMin = -1;
        for (Series s : this.series) {
            double[] xs = s.getX();
            double[] ys = s.getY();
            for (int i = 0; i < xs.length; ++i) {
                double dist = ptWorld.distance(xs[i], ys[i]);
                if (!(dist <= distMin)) continue;
                distMin = dist;
                seriesMin = s;
                ixMin = i;
            }
        }
        if (seriesMin != null) {
            dest.series = seriesMin;
            dest.i = ixMin;
            return true;
        }
        return false;
    }

    public static class Annotation {
        public final String text;
        public final Point2D point;
        public final Color color;

        public Annotation(String text, Point2D point, Color color) {
            this.text = text;
            this.point = point;
            this.color = color;
        }
    }

    public static class PickPointVal {
        public Series series = null;
        public int i = -1;
    }
}

