/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ISearchVol;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IProxyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.util.TaskProgress;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;

public class TransformedGeom
implements IProxyGeom,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final Matrix4d xform;
    public final IGeom geom;

    public TransformedGeom(Matrix4d xform, IGeom geom) {
        this.xform = xform;
        this.geom = geom;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 dict) {
        Object ngeom = dict.get(this.geom);
        MatrixXform transform = new MatrixXform(this.xform);
        if (ngeom instanceof thunderheadeng.geometry.objs.IGeom) {
            return GeomNodeUtil.newNode((ITransform)transform, (thunderheadeng.geometry.objs.IGeom)ngeom);
        }
        if (ngeom instanceof IGeomNode) {
            IGeomNode gnode = (IGeomNode)ngeom;
            TransformInfo ti = transform.getInfo();
            return gnode.transform(ti);
        }
        return null;
    }

    @Override
    public IGeom getBase() {
        return this.geom;
    }

    @Override
    public TransformedGeom collapse() {
        Matrix4d lxform = this.xform;
        IGeom g = this.geom;
        while (g instanceof TransformedGeom) {
            TransformedGeom tg = (TransformedGeom)g;
            g = tg.geom;
            if (lxform == this.xform) {
                lxform = new Matrix4d(this.xform);
            }
            lxform.mul(tg.xform);
        }
        return g == this.geom ? this : new TransformedGeom(lxform, g);
    }

    @Override
    public IGeom optimize(IPointOptimizer pool) {
        IGeom ngeom = this.geom.optimize(pool);
        if (GeomConstants.IDENTITY4d.equals(this.xform)) {
            return ngeom;
        }
        if (ngeom != this.geom) {
            return new TransformedGeom(this.xform, ngeom);
        }
        return this;
    }

    @Override
    public AABox getBoundingBox(final AABox aabb) {
        final TransformedGeom collapsed = this.collapse();
        AABox bb = new AABox(){
            private static final long serialVersionUID = 8170265483089249418L;

            @Override
            public void add(AABox box) {
                aabb.add(box.transform(collapsed.xform));
            }

            @Override
            public void add(ISearchVol vol) {
                assert (false);
                aabb.add(vol);
            }

            @Override
            public void addPoint(double x, double y, double z) {
                Point3d p = new Point3d(x, y, z);
                collapsed.xform.transform(p);
                aabb.addPoint(p.x, p.y, p.z);
            }
        };
        collapsed.geom.getBoundingBox(bb);
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IGeom transform(Matrix4d xform, IGeom.XformOp op) {
        Matrix4d newXform = new Matrix4d(xform);
        newXform.mul(this.xform);
        return this.geom.transform(newXform, op);
    }

    @Override
    public boolean isAxisAlignedBlock(Matrix4d parentXform) {
        parentXform = TransformedGeom.transform(parentXform, this.xform);
        return this.geom.isAxisAlignedBlock(parentXform);
    }

    @Override
    public boolean isShell() {
        return this.geom.isShell();
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public int getNumPrims(int types) {
        return this.geom.getNumPrims(types);
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> prims) {
        TransformedGeom collapsed = this.collapse();
        IGeom xformed = collapsed.geom.transform(collapsed.xform, IGeom.XformOp.EXPLODED);
        prims.add(xformed);
        return prims;
    }

    private static Matrix4d transform(Matrix4d parentXform, Matrix4d xform) {
        if (parentXform == null) {
            return xform;
        }
        parentXform = new Matrix4d(parentXform);
        parentXform.mul(xform);
        return parentXform;
    }

    public static TransformedGeom collapse(TransformedGeom geom) {
        return geom.collapse();
    }

    @Override
    public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
        Matrix4d ixform = this.getInverseXform();
        region = region.transform(ixform);
        return this.geom.intersectsBox(source, filter, region);
    }

    @Override
    public void pickPoints(final IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        Matrix4d ixform = this.getInverseXform();
        rayBegin = Util3D.xform(ixform, rayBegin);
        rayEnd = Util3D.xform(ixform, rayEnd);
        rayDirN = Util3D.xform(ixform, rayDirN);
        rayDirN.normalize();
        IIsectCollector xformCollector = new IIsectCollector(){

            @Override
            public void add(Object obj, Point3d p, GeomType type, IPrimitive prim) {
                p = Util3D.xform(TransformedGeom.this.xform, p);
                prim = prim.transform(TransformedGeom.this.xform);
                isects.add(obj, p, type, prim);
            }

            @Override
            public void addInfinite(Object obj, Point3d p, GeomType type, IPrimitive prim) {
                p = Util3D.xform(TransformedGeom.this.xform, p);
                prim = prim.transform(TransformedGeom.this.xform);
                isects.addInfinite(obj, p, type, prim);
            }

            @Override
            public TaskProgress getProgress() {
                return isects.getProgress();
            }
        };
        tester = new XformTester(tester, this.xform);
        this.geom.pickPoints(xformCollector, filter, source, rayBegin, rayEnd, rayDirN, tester);
    }

    public Matrix4d getInverseXform() {
        Matrix4d wlxform = new Matrix4d(this.xform);
        wlxform.invert();
        return wlxform;
    }

    @Override
    public void find(ITest<AABox> test, IResult<? super IPrimitive> result) {
        TransformedGeom collapsed = this.collapse();
        test = new XformTester(test, collapsed.xform);
        result = new XformResult(result, collapsed.xform);
        collapsed.geom.find(test, result);
    }

    @Override
    public void getAll(IResult<? super IPrimitive> result) {
        Collection<IGeom> pieces = this.explode(new ArrayList<IGeom>());
        for (IGeom subGeom : pieces) {
            subGeom.getAll(result);
        }
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        if (!(this.geom instanceof IManipulatable)) {
            return Collections.EMPTY_LIST;
        }
        Collection<? extends IHandle> geomHandles = ((IManipulatable)((Object)this.geom)).generateManipHandles();
        ArrayList<Handle> handles = new ArrayList<Handle>(geomHandles.size());
        for (IHandle iHandle : geomHandles) {
            handles.add(new Handle(this, iHandle));
        }
        return handles;
    }

    private static class XformTester
    implements ITest<AABox> {
        private final ITest<AABox> base;
        private final Matrix4d xform;

        public XformTester(ITest<AABox> base, Matrix4d xform) {
            this.base = base;
            this.xform = xform;
        }

        @Override
        public Containment test(AABox bb) {
            AABox xformbb = new AABox(bb);
            xformbb.transformEq(this.xform);
            return this.base.test(xformbb);
        }
    }

    private static class XformResult
    implements IResult<IPrimitive> {
        private final Matrix4d d_xform;
        private final IResult<? super IPrimitive> d_base;

        public XformResult(IResult<? super IPrimitive> base, Matrix4d xform) {
            this.d_xform = xform;
            this.d_base = base;
        }

        @Override
        public void mark(IPrimitive obj, Containment ctmt) {
            obj = obj.transform(this.d_xform);
            this.d_base.mark(obj, ctmt);
        }
    }

    private static class Handle
    implements IHandle {
        private TransformedGeom d_geom;
        private final IHandle d_handle;
        private Matrix4d t_xform;
        private Matrix4d t_invXform;

        public Handle(TransformedGeom geom, IHandle handle) {
            this.d_geom = geom;
            this.d_handle = handle;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Handle && ((Handle)obj).d_handle.equals(this.d_handle);
        }

        @Override
        public IGeom getGeom() {
            return new TransformedGeom(this.d_geom.xform, this.d_handle.getGeom());
        }

        @Override
        public IIsectFilter getPickFilter() {
            return this.d_handle.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            this.t_invXform = this.d_geom.getInverseXform();
            this.t_xform = this.d_geom.xform;
            ISnapConstraint constraint = this.d_handle.getConstraint(handleLoc = Util3D.xform(this.t_invXform, handleLoc));
            return constraint == null ? constraint : constraint.transform(this.t_xform);
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            assert (this.t_invXform != null && this.t_xform != null);
            handleLoc = Util3D.xform(this.t_invXform, handleLoc);
            constraint = constraint == null ? constraint : constraint.transform(this.t_invXform);
            this.d_handle.begin(handleLoc, constraint);
        }

        @Override
        public Object modify(Point3d newLoc) throws Exception {
            newLoc = Util3D.xform(this.t_invXform, newLoc);
            Object mod = this.d_handle.modify(newLoc);
            this.d_geom = this.modify(mod);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.d_geom = this.modify(this.d_handle.end());
            this.t_invXform = null;
            this.t_xform = null;
            return this.d_geom;
        }

        private TransformedGeom modify(Object mod) {
            if (mod instanceof IGeom) {
                return new TransformedGeom(this.d_geom.xform, (IGeom)mod);
            }
            return this.d_geom;
        }
    }
}

