/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ACurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;

public class PolyCurve
extends ACurve
implements ICurve,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final ICurve[] curves;

    public PolyCurve(ICurve ... curves) {
        this.curves = curves;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 dict) {
        thunderheadeng.geometry.objs.ICurve[] newCurves = new thunderheadeng.geometry.objs.ICurve[this.curves.length];
        for (int m = 0; m < this.curves.length; ++m) {
            newCurves[m] = (thunderheadeng.geometry.objs.ICurve)dict.get(this.curves[m]);
        }
        return new thunderheadeng.geometry.objs.PolyCurve(newCurves);
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        for (ICurve curve : this.curves) {
            curve.getBoundingBox(aabb);
        }
        return aabb;
    }

    @Override
    public ICurve optimize(IPointOptimizer pool) {
        ICurve[] newCurves = new ICurve[this.curves.length];
        boolean modified = false;
        for (int m = 0; m < this.curves.length; ++m) {
            ICurve subCurve = this.curves[m];
            ICurve newSubCurve = subCurve.optimize(pool);
            modified |= subCurve != newSubCurve;
            newCurves[m] = newSubCurve;
        }
        return modified ? new PolyCurve(newCurves) : this;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public PolyCurve transform(Matrix4d xform) {
        ICurve[] newCurves = new ICurve[this.curves.length];
        for (int m = 0; m < this.curves.length; ++m) {
            newCurves[m] = this.curves[m].transform(xform);
        }
        return new PolyCurve(newCurves);
    }

    @Override
    public Mesh getSegments(double errorTol) {
        Mesh[] meshes = new Mesh[this.curves.length];
        for (int m = 0; m < this.curves.length; ++m) {
            meshes[m] = this.curves[m].getSegments(errorTol);
        }
        return Mesh.merge(meshes);
    }

    @Override
    public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
        if (filter.acceptGeomType(source, GeomType.EDGE)) {
            for (ICurve geom : this.curves) {
                if (!geom.intersectsBox(source, filter, region)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        for (ICurve geom : this.curves) {
            isects.getProgress().check();
            geom.pickPoints(isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
        }
    }

    @Override
    public Point3d project(Point3d p, double tol) {
        Point3d nearestp = null;
        double nearestDistSq = Double.MAX_VALUE;
        for (ICurve curve : this.curves) {
            Point3d nearp = curve.project(p, tol);
            double distsq = p.distanceSquared(nearp);
            if (!(distsq < nearestDistSq)) continue;
            nearestDistSq = distsq;
            nearestp = nearp;
        }
        return nearestp;
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        ArrayList<Handle> handles = new ArrayList<Handle>();
        for (int m = 0; m < this.curves.length; ++m) {
            ICurve curve = this.curves[m];
            if (!(curve instanceof IManipulatable)) continue;
            for (IHandle iHandle : ((IManipulatable)((Object)curve)).generateManipHandles()) {
                handles.add(new Handle(this, m, iHandle));
            }
        }
        return handles;
    }

    private static class Handle
    implements IHandle {
        private PolyCurve d_geom;
        private final int d_curveIx;
        private final IHandle d_curveHandle;
        private ICurve[] t_curves;

        public Handle(PolyCurve geom, int curveIx, IHandle curveHandle) {
            this.d_geom = geom;
            this.d_curveIx = curveIx;
            this.d_curveHandle = curveHandle;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Handle && ((Handle)obj).d_curveIx == this.d_curveIx && ((Handle)obj).d_curveHandle.equals(this.d_curveHandle);
        }

        @Override
        public IGeom getGeom() {
            return this.d_curveHandle.getGeom();
        }

        @Override
        public IIsectFilter getPickFilter() {
            return this.d_curveHandle.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return this.d_curveHandle.getConstraint(handleLoc);
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.t_curves = Arrays.copyOf(this.d_geom.curves, this.d_geom.curves.length);
            this.d_curveHandle.begin(handleLoc, constraint);
        }

        @Override
        public Object modify(Point3d newLoc) throws Exception {
            Object curveMod = this.d_curveHandle.modify(newLoc);
            this.d_geom = this.replace(curveMod);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.d_geom = this.replace(this.d_curveHandle.end());
            this.t_curves = null;
            return this.d_geom;
        }

        private PolyCurve replace(Object modified) {
            PolyCurve result = this.d_geom;
            if (modified instanceof ICurve) {
                this.t_curves[this.d_curveIx] = (ICurve)modified;
                result = new PolyCurve(this.t_curves);
            }
            return result;
        }
    }
}

