/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ITransform;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.MatrixXform;

public class BGImageXform
implements ITransform {
    private static final long serialVersionUID = 1L;
    public final Point2d anchorImage;
    public final Point3d anchorModel;
    public final Point2d aImage;
    public final Point2d bImage;
    public final double distABModel;
    public final double abAngle;

    public BGImageXform(Point2d anchorImage, Point3d anchorModel, Point2d aImage, Point2d bImage, double distABModel, double abAngle) {
        this.anchorImage = anchorImage;
        this.anchorModel = anchorModel;
        this.aImage = aImage;
        this.bImage = bImage;
        this.distABModel = distABModel;
        this.abAngle = Double.isNaN(abAngle) ? Util2D.angle(new Vector2d(1.0, 0.0), Util2D.vector(aImage, bImage)) : abAngle;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 dict) {
        return new thunderheadeng.geometry.objs.BGImageXform(this.anchorImage, this.anchorModel, this.aImage, this.bImage, this.distABModel, this.abAngle);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BGImageXform)) {
            return false;
        }
        BGImageXform xform = (BGImageXform)obj;
        return this.anchorImage.equals(xform.anchorImage) && this.anchorModel.equals(xform.anchorModel) && this.aImage.equals(xform.aImage) && this.bImage.equals(xform.bImage) && this.distABModel == xform.distABModel && this.abAngle == xform.abAngle;
    }

    @Override
    public Matrix4d toMatrix() {
        Matrix4d xform = new Matrix4d();
        xform.setIdentity();
        if (this.aImage.equals(this.bImage) || this.distABModel == 0.0) {
            return xform;
        }
        xform.setTranslation(new Vector3d(this.anchorModel.x, this.anchorModel.y, this.anchorModel.z));
        double scale = BGImageXform.getBackgroundImageScale(this.aImage, this.bImage, this.distABModel);
        xform.mul(Util.scaleMat(scale, scale, 1.0));
        double angle = BGImageXform.getBGImageRotation(this.aImage, this.bImage, this.abAngle);
        xform.mul(Util.rotMat(0.0, 0.0, 1.0, angle));
        xform.mul(Util.translateMat(-this.anchorImage.x, -this.anchorImage.y, 0.0));
        return xform;
    }

    private static double getBackgroundImageScale(Point2d aImage, Point2d bImage, double distABModel) {
        double pixelDist = aImage.distance(bImage);
        return distABModel / pixelDist;
    }

    private static double getBGImageRotation(Point2d aImage, Point2d bImage, double desiredAngle) {
        Vector2d ab = Util2D.vector(aImage, bImage);
        double currAngle = Util2D.angle(new Vector2d(1.0, 0.0), ab);
        return desiredAngle - currAngle;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.ROT_Z;
    }

    @Override
    public ITransform transform(Matrix4d xform) {
        Matrix4d lwxform = this.toMatrix();
        Matrix4d newXform = new Matrix4d(xform);
        newXform.mul(lwxform);
        if (this.getDOF().accept(xform)) {
            Point3d newAnchor = Util3D.xform(newXform, this.anchorModel);
            Point3d aMdl = Util3D.xform(newXform, new Point3d(this.aImage.x, this.aImage.y, 0.0));
            Point3d bMdl = Util3D.xform(newXform, new Point3d(this.bImage.x, this.bImage.y, 0.0));
            double newDist = aMdl.distance(bMdl);
            Vector3d abVec = Util3D.vector(aMdl, bMdl);
            double newAngle = Util3D.angle(GeomConstants.VEC3D_XPOS, abVec, GeomConstants.VEC3D_ZPOS);
            return new BGImageXform(this.anchorImage, newAnchor, this.aImage, this.bImage, newDist, newAngle);
        }
        return new MatrixXform(newXform);
    }
}

