/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Random;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter2D;
import pyrosim.legacy_2012_1.thunderheadeng.util.theMath;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Util2D {
    public static Point2d linePoint(Point2d p1, Point2d p2, double t) {
        if (t == 1.0) {
            return new Point2d(p2);
        }
        return new Point2d(p1.x + (p2.x - p1.x) * t, p1.y + (p2.y - p1.y) * t);
    }

    public static Point2d linePoint(Point2d p1, Vector2d vec, double t) {
        return new Point2d(p1.x + vec.x * t, p1.y + vec.y * t);
    }

    private static double dirDotTest(Vector2d vec1, Vector2d vec2, double tol) {
        double v1lenSq = vec1.lengthSquared();
        if (v1lenSq <= tol) {
            return Double.NaN;
        }
        double v2lenSq = vec2.lengthSquared();
        if (v2lenSq <= tol) {
            return Double.NaN;
        }
        Vector2d vec1n = Util2D.scale(vec1, 1.0 / Math.sqrt(v1lenSq));
        Vector2d vec2n = Util2D.scale(vec2, 1.0 / Math.sqrt(v2lenSq));
        return vec1n.dot(vec2n);
    }

    private static double randomVecComp(Random rand) {
        return rand.nextDouble() * 2.0 - 1.0;
    }

    public static Vector2d newRandomVec2D(Random rand) {
        Vector2d v = new Vector2d(Util2D.randomVecComp(rand), Util2D.randomVecComp(rand));
        v.normalize();
        return v;
    }

    public static boolean areLinesParallel(Vector2d vec1, Vector2d vec2, double tol) {
        double dotTest = Util2D.dirDotTest(vec1, vec2, tol);
        return Double.isNaN(dotTest) || Math.abs(Math.abs(dotTest) - 1.0) <= tol;
    }

    public static boolean areLinesAligned(Point2d p1, Vector2d v1, Point2d p2, Vector2d v2, double tol) {
        return Util2D.areLinesParallel(v1, v2, tol) && Util2D.areLinesParallel(v1, Util2D.vector(p1, p2), tol);
    }

    public static boolean areLineSegsAligned(Point2d p1a, Point2d p2a, Point2d p1b, Point2d p2b, double distTol) {
        Vector2d dira = Util2D.vector(p1a, p2a);
        Vector2d dirb = Util2D.vector(p1b, p2b);
        double d1 = Inter2D.nearestPtOnLine(p1a, dira, p1b).distanceLinf(p1b);
        double d2 = Inter2D.nearestPtOnLine(p1a, dira, p2b).distanceLinf(p2b);
        double d3 = Inter2D.nearestPtOnLine(p1b, dirb, p1a).distanceLinf(p1a);
        double d4 = Inter2D.nearestPtOnLine(p1b, dirb, p2a).distanceLinf(p2a);
        double maxd = Math.max(d1, d2);
        if (d3 > maxd) {
            maxd = d3;
        }
        if (d4 > maxd) {
            maxd = d4;
        }
        return maxd <= distTol;
    }

    public static Point2d add(Point2d p1, Tuple2d p2) {
        return new Point2d(p1.x + p2.x, p1.y + p2.y);
    }

    public static Vector2d vector(Point2d p1, Point2d p2) {
        Vector2d vec = new Vector2d();
        vec.sub(p2, p1);
        return vec;
    }

    public static Vector2d vectorN(Point2d p1, Point2d p2) {
        Vector2d vec = new Vector2d();
        vec.sub(p2, p1);
        vec.normalize();
        return vec;
    }

    public static Vector2d normalize(Vector2d vec) {
        Vector2d vec1 = new Vector2d();
        vec1.normalize(vec);
        return vec1;
    }

    public static Vector2d scale(Vector2d vec, double scale) {
        return new Vector2d(vec.x * scale, vec.y * scale);
    }

    public static double cross(Vector2d v1, Vector2d v2) {
        return v1.x * v2.y - v1.y * v2.x;
    }

    public static double cross(double v1x, double v1y, double v2x, double v2y) {
        return v1x * v2y - v1y * v2x;
    }

    public static double tOnLine(Point2d lp, Vector2d ldir, Point2d p) {
        Vector2d lpp = Util2D.vector(lp, p);
        double dot = ldir.dot(lpp);
        return dot / ldir.lengthSquared();
    }

    public static Vector2d negate(Vector2d vec) {
        return new Vector2d(-vec.x, -vec.y);
    }

    public static double angle(Vector2d v1, Vector2d v2) {
        double absAngle = v1.angle(v2);
        double cross = Util2D.cross(v1, v2);
        return cross >= 0.0 ? absAngle : -absAngle;
    }

    public static double angle(double ax, double ay, double bx, double by) {
        double dot = ax * bx + ay * by;
        double maga = Math.sqrt(ax * ax + ay * ay);
        double magb = Math.sqrt(bx * bx + by * by);
        return Math.acos(dot / (maga * magb));
    }

    public static double sAngle(double ax, double ay, double bx, double by) {
        double magb;
        double cross = ax * by - ay * bx;
        double maga = Math.sqrt(ax * ax + ay * ay);
        double sin = cross / (maga * (magb = Math.sqrt(bx * bx + by * by)));
        double angle = sin > 1.0 ? 1.5707963267948966 : (sin < -1.0 ? -1.5707963267948966 : Math.asin(sin));
        double dot = ax * bx + ay * by;
        if (dot < 0.0) {
            angle = angle < 0.0 ? -angle - Math.PI : Math.PI - angle;
        }
        return angle;
    }

    public static Point2d round(Point2d p, int numDecimals) {
        return new Point2d(theMath.round(p.x, numDecimals), theMath.round(p.y, numDecimals));
    }

    public static Point2d round(Point2d p, double tol) {
        return new Point2d(theMath.round(p.x, tol), theMath.round(p.y, tol));
    }

    public static double simplePolygonArea(Point2d ... points) {
        if (points.length < 3) {
            return 0.0;
        }
        Point2d first = points[0];
        int end = first.equals(points[points.length - 1]) ? points.length - 1 : points.length;
        double area = 0.0;
        double p1x = points[1].x - first.x;
        double p1y = points[1].y - first.y;
        for (int m = 2; m < end; ++m) {
            Point2d p2 = points[m];
            double p2x = p2.x - first.x;
            double p2y = p2.y - first.y;
            area += p1x * p2y - p1y * p2x;
            p1x = p2x;
            p1y = p2y;
        }
        return 0.5 * area;
    }

    public static Point2d simplePolygonCentroid(Point2d ... points) {
        double area = Util2D.simplePolygonArea(points);
        if (area == 0.0) {
            return null;
        }
        assert (points.length >= 3);
        Point2d first = points[0];
        int end = first.equals(points[points.length - 1]) ? points.length - 1 : points.length;
        double cx = 0.0;
        double cy = 0.0;
        double p1x = points[1].x - first.x;
        double p1y = points[1].y - first.y;
        for (int m = 2; m < end; ++m) {
            Point2d p2 = points[m];
            double p2x = p2.x - first.x;
            double p2y = p2.y - first.y;
            double temp = p1x * p2y - p2x * p1y;
            cx += (p1x + p2x) * temp;
            cy += (p1y + p2y) * temp;
            p1x = p2x;
            p1y = p2y;
        }
        double mult = 1.0 / (6.0 * area);
        return new Point2d(first.x + mult * cx, first.y + mult * cy);
    }

    public static boolean rectify(Point2d min, Point2d max) {
        double temp;
        boolean rectified = false;
        if (max.x < min.x) {
            temp = max.x;
            max.x = min.x;
            min.x = temp;
            rectified = true;
        }
        if (max.y < min.y) {
            temp = max.y;
            max.y = min.y;
            min.y = temp;
            rectified = true;
        }
        return rectified;
    }

    public static Point2d lerp(Point2d p1, Point2d p2, double t) {
        return new Point2d(theUtil.lerp(p1.x, p2.x, t), theUtil.lerp(p1.y, p2.y, t));
    }

    public static Rectangle2D getBounds(Point2d ... points) {
        if (points.length == 0) {
            return new Rectangle2D.Double();
        }
        Point2d p1 = points[0];
        Rectangle2D.Double rect = new Rectangle2D.Double(p1.x, p1.y, 0.0, 0.0);
        for (int m = 1; m < points.length; ++m) {
            Point2d p = points[m];
            rect.add(p.x, p.y);
        }
        return rect;
    }

    public static Rectangle2D getBounds(List<Point2d> points) {
        if (points.size() == 0) {
            return new Rectangle2D.Double();
        }
        Point2d p1 = points.get(0);
        Rectangle2D.Double rect = new Rectangle2D.Double(p1.x, p1.y, 0.0, 0.0);
        for (int m = 1; m < points.size(); ++m) {
            Point2d p = points.get(m);
            rect.add(p.x, p.y);
        }
        return rect;
    }

    public static double[] getInterpolateParams(Point2d p1, Point2d p2, Point2d p3, Point2d p) {
        double[] params = new double[2];
        Util2D.getInterpolateParams(p1, p2, p3, p, params);
        return params;
    }

    public static void getInterpolateParams(Point2d p1, Point2d p2, Point2d p3, Point2d p, double[] params) {
        double v1x = p2.x - p1.x;
        double v1y = p2.y - p1.y;
        double v2x = p3.x - p1.x;
        double v2y = p3.y - p1.y;
        double v3x = p.x - p1.x;
        double v3y = p.y - p1.y;
        double s = 1.0 / Util2D.cross(v1x, v1y, v2x, v2y);
        double t = Util2D.cross(v3x, v3y, v2x, v2y) * s;
        double u = Util2D.cross(v1x, v1y, v3x, v3y) * s;
        params[0] = t;
        params[1] = u;
    }

    public static double interpolate(double v1, double v2, double v3, double[] params) {
        return v1 + (v2 - v1) * params[0] + (v3 - v1) * params[1];
    }

    public static boolean isConvex(double tol, Point2d ... points) {
        Point2d p2;
        Point2d p1;
        int m;
        if (points.length < 3) {
            return false;
        }
        double tolSq = tol * tol;
        Vector2d prevVec = new Vector2d();
        double prevCross = Double.NaN;
        Vector2d nextVec = new Vector2d();
        double nextCross = Double.NaN;
        prevVec.sub(points[1], points[0]);
        for (m = 1; m < points.length; ++m) {
            p1 = points[m];
            p2 = points[(m + 1) % points.length];
            nextVec.sub(p2, p1);
            prevCross = Util2D.cross(prevVec, nextVec);
            if (!theUtil.eq0(prevCross, tolSq)) {
                prevVec.set(nextVec);
                break;
            }
            if (!(prevVec.dot(nextVec) < 0.0)) continue;
            return false;
        }
        if (m == points.length) {
            return false;
        }
        ++m;
        while (m <= points.length) {
            p1 = points[m % points.length];
            p2 = points[(m + 1) % points.length];
            nextVec.sub(p2, p1);
            nextCross = Util2D.cross(prevVec, nextVec);
            if (!theUtil.eq0(nextCross, tolSq)) {
                if (prevCross < 0.0 && nextCross > 0.0 || prevCross > 0.0 && nextCross < 0.0) {
                    return false;
                }
                prevVec.set(nextVec);
            } else if (prevVec.dot(nextVec) < 0.0) {
                return false;
            }
            ++m;
        }
        return true;
    }

    public static double triArea(Point2d p1, Point2d p2, Point2d p3) {
        double area = 0.5 * Math.abs(Util2D.cross(p1, p2, p3));
        return area;
    }

    public static double cross(Point2d origin, Point2d p1, Point2d p2) {
        double area = p1.x * origin.y - origin.x * p1.y + (p2.x * p1.y - p1.x * p2.y) + (origin.x * p2.y - p2.x * origin.y);
        return area;
    }
}

