/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.evac.Exit;
import pyrosim.legacy_2012_1.domain.evac.ExitList;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class ExitParser
extends AFDS5Parser {
    public ExitParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id;
        if (!rec.contains("ID")) {
            this.addWarning(rec, Intl.intl("Unable to process EXIT record: ID missing"), Intl.intl("EXIT Record Ignored"));
            return false;
        }
        ExitList mgr = this.getContainer().getExitList();
        if (mgr.get(id = rec.getString("ID")) != null) {
            this.addWarning(rec, Intl.intl("Unable to process EXIT record: Duplicate ID"), Intl.intl("EXIT Record Ignored"));
            return false;
        }
        Exit e = new Exit(id);
        e.setProp("FYI", rec.get("FYI"));
        if (rec.contains("XB")) {
            FDSArray<UnitDouble> xbRaw = rec.getArray("XB", false);
            e.setProp("XB", xbRaw.toFlatArray(new UnitDouble[xbRaw.getTotalLength()]));
        }
        if (rec.contains("XYZ")) {
            FDSArray<UnitDouble> xyzRaw = rec.getArray("XYZ", false);
            e.setProp("XYZ", xyzRaw.toFlatArray(new UnitDouble[xyzRaw.getTotalLength()]));
        }
        e.setProp("IOR", rec.get("IOR"));
        e.setProp("COUNT_ONLY", rec.get("COUNT_ONLY"));
        GridList gridList = this.getContainer().getGridManager();
        if (rec.contains("MESH_ID")) {
            e.setProp("MESH_ID", gridList.get(rec.getString("MESH_ID")));
        }
        if (rec.contains("VENT_FFIELD")) {
            e.setProp("VENT_FFIELD", gridList.get(rec.getString("VENT_FFIELD")));
        }
        if (rec.contains("FLOW_FIELD_ID")) {
            e.setProp("FLOW_FIELD_ID", gridList.get(rec.getString("FLOW_FIELD_ID")));
        }
        e.setProp("RGB", this.parseColor(rec, "RGB", "COLOR", null, false));
        e.setProp("TIME_OPEN", rec.get("TIME_OPEN"));
        e.setProp("TIME_CLOSE", rec.get("TIME_CLOSE"));
        mgr.add(e);
        this.flagObjectAdded(e);
        this.flagEvac();
        return true;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("EXIT");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }
}

