/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.reaction;

import java.io.Serializable;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.reaction.Reaction;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;

public class ReactionList
extends Composite<Reaction>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public ReactionList() {
        this(Intl.intl("Reactions"));
    }

    public ReactionList(String name) {
        super(name, Reaction.class);
    }

    public Reaction getActiveReaction() {
        for (Reaction reac : this.flatten()) {
            if (!reac.isActive()) continue;
            return reac;
        }
        return null;
    }

    public Task taskSetActiveReaction(final Reaction reac) {
        final Reaction active = this.getActiveReaction();
        return new AUndoableTask(){

            @Override
            public void undo() {
                ReactionList.this.pauseUpdates();
                if (reac != null) {
                    reac.setActive(false);
                }
                if (active != null) {
                    active.setActive(true);
                }
                ReactionList.this.resumeUpdates();
            }

            @Override
            public void run() {
                ReactionList.this.pauseUpdates();
                if (active != null) {
                    active.setActive(false);
                }
                if (reac != null) {
                    reac.setActive(true);
                }
                ReactionList.this.resumeUpdates();
            }
        };
    }
}

