/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.quantity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityType;
import pyrosim.legacy_2012_1.domain.quantity.StaticQuantity;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.util.ANameSorter;
import pyrosim.legacy_2012_1.util.Filters;
import pyrosim.legacy_2012_1.util.ITransformer;
import pyrosim.legacy_2012_1.util.TransformedCollection;
import pyrosim.legacy_2012_1.util.Util;

public class QuantityUtil {
    public static final IObjectFilter<Quantity> STATIC_QUANT_FILTER = new IObjectFilter<Quantity>(){

        @Override
        public boolean shouldFilter(Quantity o) {
            return o.getNumArgs() == 0;
        }
    };
    public static final IObjectFilter<Quantity> OBJ_QUANT_FILTER = new IObjectFilter<Quantity>(){

        @Override
        public boolean shouldFilter(Quantity o) {
            return o.getNumArgs() > 0;
        }
    };

    public static boolean isOneOf(Quantity quantity, QuantityType ... quantityTypes) {
        for (QuantityType quantityType : quantityTypes) {
            if (quantity.quantityType != quantityType) continue;
            return true;
        }
        return false;
    }

    public static boolean canOutputAll(Quantity quantity, int types) {
        return (quantity.outputTypes & types) == types;
    }

    public static boolean canOutputAny(Quantity quantity, int types) {
        return (quantity.outputTypes & types) != 0;
    }

    public static boolean isSpecMassFraction(Quantity quantity) {
        return quantity.unitType == 18;
    }

    public static Collection<Quantity> getQuantities(final int outputTypes) {
        return QuantityUtil.getQuantities(new IObjectFilter<Quantity>(){

            @Override
            public boolean shouldFilter(Quantity o) {
                return !QuantityUtil.canOutputAll(o, outputTypes);
            }
        });
    }

    public static Collection<Quantity> getQuantities(int outputTypes, QuantityType ... quantityTypes) {
        TypeFilter typeFilter = new TypeFilter(outputTypes, quantityTypes);
        return QuantityUtil.getQuantities(typeFilter);
    }

    public static Collection<Quantity> getQuantities(final IObjectFilter<Quantity> filter) {
        Collection<Quantity> quantities = Arrays.asList(Quantity.values());
        quantities = Util.filter(quantities, Quantity.class, new IObjectFilter<Quantity>(){

            @Override
            public boolean shouldFilter(Quantity o) {
                return o.isDeprecated() || filter.shouldFilter(o);
            }
        });
        return quantities;
    }

    public static Collection<Quantity> sort(Collection<Quantity> quantities) {
        ArrayList<Quantity> sorted = new ArrayList<Quantity>(quantities);
        Collections.sort(sorted, new ANameSorter<Quantity>(){

            @Override
            protected String getName(Quantity o) {
                return o.name;
            }
        });
        return sorted;
    }

    public static Collection<IQuantity> sortQuantities(Collection<? extends IQuantity> quantities) {
        ArrayList<IQuantity> sorted = new ArrayList<IQuantity>(quantities);
        Collections.sort(sorted, new ANameSorter<IQuantity>(){

            @Override
            protected String getName(IQuantity o) {
                return o.getDescription();
            }
        });
        return sorted;
    }

    public static Map<String, List<Quantity>> groupObjQuantities() {
        HashMap<String, List<Quantity>> categoryMap = new HashMap<String, List<Quantity>>();
        for (Quantity quant : Quantity.values()) {
            if (quant.category == null || quant.getNumArgs() <= 0) continue;
            ArrayList<Quantity> quantities = (ArrayList<Quantity>)categoryMap.get(quant.category);
            if (quantities == null) {
                quantities = new ArrayList<Quantity>();
                categoryMap.put(quant.category, quantities);
            }
            quantities.add(quant);
        }
        return categoryMap;
    }

    public static Collection<StaticQuantity> generateStaticQuantities(IObjectFilter<Quantity> filter, boolean sorted) {
        filter = Filters.merge(OBJ_QUANT_FILTER, filter);
        Collection<Quantity> quants = QuantityUtil.getQuantities(filter);
        ITransformer<Quantity, StaticQuantity> transformer = new ITransformer<Quantity, StaticQuantity>(){

            @Override
            public StaticQuantity transform(Quantity obj) {
                return obj.create();
            }
        };
        Collection<Object> quantities = new TransformedCollection<Quantity, StaticQuantity>(quants, transformer);
        if (sorted) {
            quantities = Util.sort(quantities, new ANameSorter<StaticQuantity>(){

                @Override
                protected String getName(StaticQuantity o) {
                    return o.getDescription();
                }
            });
        }
        return quantities;
    }

    public static Collection<? extends IPyroObject> getValidArguments(PyroMod domain, Quantity quantity, int arg) {
        Class<? extends IPyroObject> type = quantity.requiredTypes[arg];
        IObjectFilter filter = quantity.typeFilters[arg];
        return Util.getAllObjects(domain, type, filter, true);
    }

    public static void takeDepSnapshot(DepList deps, DLink link, IQuantity ... quantities) {
        for (IQuantity quant : quantities) {
            QuantityUtil.takeDepSnapshot(deps, link, quant);
        }
    }

    public static void takeDepSnapshot(DepList deps, DLink link, Collection<IQuantity> quantities) {
        for (IQuantity quant : quantities) {
            QuantityUtil.takeDepSnapshot(deps, link, quant);
        }
    }

    public static void takeDepSnapshot(DepList deps, DLink link, IQuantity quantity) {
        if (quantity instanceof ObjectQuantity) {
            ObjectQuantity oq = (ObjectQuantity)quantity;
            for (Object o : oq.objects) {
                deps.add(link, (IPyroObject)o);
            }
        }
    }

    public static boolean isQuantityRef(IPyroObject obj, IQuantity ... quantities) {
        for (IQuantity quant : quantities) {
            if (!QuantityUtil.isQuantityRef(obj, quant)) continue;
            return true;
        }
        return false;
    }

    public static boolean isQuantityRef(IPyroObject obj, Collection<? extends IQuantity> quantities) {
        for (IQuantity iQuantity : quantities) {
            if (!QuantityUtil.isQuantityRef(obj, iQuantity)) continue;
            return true;
        }
        return false;
    }

    public static boolean isQuantityRef(IPyroObject obj, IQuantity quant) {
        if (quant instanceof ObjectQuantity) {
            for (Object pobj : ((ObjectQuantity)quant).objects) {
                if (pobj != obj) continue;
                return true;
            }
        }
        return false;
    }

    public static class TypeFilter
    implements IObjectFilter<Quantity> {
        private final int outputTypes;
        private final QuantityType[] quantityTypes;

        public TypeFilter(int outputTypes, QuantityType ... quantityTypes) {
            this.outputTypes = outputTypes;
            this.quantityTypes = quantityTypes;
        }

        @Override
        public boolean shouldFilter(Quantity o) {
            return this.quantityTypes.length > 0 && !QuantityUtil.isOneOf(o, this.quantityTypes) || !QuantityUtil.canOutputAll(o, this.outputTypes);
        }
    }
}

