/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.output;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy.v172.domain.output.AMsrStat;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.output.IMeasurementStat;
import pyrosim.legacy_2012_1.domain.output.StatGeom;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityReplacer;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BlockGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IBoxCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.EmptyTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.util.Util;

public abstract class AMsrStat
extends NamedPyroObject
implements IMeasurementStat,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private IQuantity d_msr;
    private Set<Integer> d_stats;
    private IGeom d_geom;
    private boolean d_visible;
    private static final Color s_boxColor = new Color(0.2f, 0.2f, 1.0f, 0.3f);
    private static final Color s_pointColor = new Color(0.2f, 0.2f, 1.0f, 1.0f);

    public abstract IObjectFilter<Quantity> getQuantityFilter();

    public AMsrStat(String name, IQuantity msr, Collection<Integer> stats, IGeom geom) {
        super(name);
        this.d_msr = msr;
        this.d_stats = new HashSet<Integer>(stats);
        assert (AMsrStat.isValidGeom(geom));
        this.d_geom = geom;
        this.d_visible = true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AMsrStat)) {
            return false;
        }
        AMsrStat stat = (AMsrStat)obj;
        return this.d_msr.equals(stat.d_msr) && this.d_stats.equals(stat.d_stats) && this.d_geom.equals(stat.d_geom);
    }

    @Override
    public Object clone() {
        AMsrStat clone = (AMsrStat)super.clone();
        clone.d_stats = new HashSet<Integer>(this.d_stats);
        return clone;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible == visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(PyroMod.EVT_VISIBILITY_CHANGED);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public IQuantity getQuantity() {
        return this.d_msr;
    }

    @Override
    public void setStats(Collection<Integer> stats) {
        this.d_stats.clear();
        this.d_stats.addAll(stats);
        this.changedEvt(new Object[0]);
    }

    @Override
    public Set<Integer> getStats() {
        return Collections.unmodifiableSet(this.d_stats);
    }

    public static boolean isValidGeom(IGeom geom) {
        return geom instanceof Point || geom instanceof AABoxGeom || geom instanceof AARectangle || geom instanceof StatGeom.GridGeom;
    }

    @Override
    public IGeom getStatGeom() {
        return this.d_geom;
    }

    @Override
    public IGeom getGeom() {
        if (this.d_geom instanceof BlockGeom) {
            return this.d_geom;
        }
        if (this.d_geom instanceof AABoxGeom) {
            AABoxGeom g = (AABoxGeom)this.d_geom;
            return new BlockGeom(g.min, g.max, g.swizzle);
        }
        if (this.d_geom instanceof RestrictedRect) {
            return this.d_geom;
        }
        if (this.d_geom instanceof AARectangle) {
            return new RestrictedRect((AARectangle)this.d_geom);
        }
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
        if (AMsrStat.isValidGeom(geom = Geometry.finalize(geom, optimizeGeom))) {
            this.d_geom = geom;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        Color c = this.d_geom instanceof Point ? s_pointColor : s_boxColor;
        IPrimProps.AProps props = this.d_geom instanceof Point ? new IPrimProps.Vertex(c, 10.0) : new IPrimProps.Face(c, null, true);
        return new DisplayGeom(this.d_geom, (IPrimProps)props);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        QuantityUtil.takeDepSnapshot(deps, DLink.STRONG, this.d_msr);
        if (this.d_geom instanceof StatGeom.GridGeom) {
            deps.add(DLink.STRONG, (IPyroObject)((StatGeom.GridGeom)this.d_geom).grid);
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (QuantityUtil.isQuantityRef(old, this.d_msr)) {
            Util.removeNonNull(objs);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (QuantityUtil.isQuantityRef(old, this.d_msr)) {
            assert (old.equals(replacement));
            QuantReplacer replacer = new QuantReplacer();
            return replacer.taskReplaceDep(old, replacement, this.d_msr);
        }
        if (old instanceof Grid) {
            assert (replacement != null);
            return new AReplaceRefTask<Grid>((Object)old, (Object)replacement){

                @Override
                protected void set(Grid obj) {
                    AMsrStat.this.setGeom(new StatGeom.GridGeom(obj), true);
                }
            };
        }
        return EmptyTask.INSTANCE;
    }

    @Override
    public boolean isMixFracOnly() {
        return this.d_msr.get().mixFracOnly;
    }

    @Override
    public AABox getBounds() {
        return this.getGeom().getBoundingBox(new AABox());
    }

    @Override
    public void getAll(IBoxCollector result, IIsectFilter filter) {
        if (filter.acceptPickObject(this)) {
            result.add(this);
        }
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        if (this.getGeom().intersectsBox(this, filter, box)) {
            result.add(this);
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        this.getGeom().pickPoints(isects, filter, this, rayBegin, rayEnd, rayDirN, tester);
    }

    private static class RestrictedRect
    extends AARectangle {
        static final long serialVersionUID = 1L;

        public RestrictedRect(AARectangle baseRect) {
            super(baseRect.d_plane, baseRect.d_planeVal, baseRect.d_minx, baseRect.d_miny, baseRect.d_maxx, baseRect.d_maxy);
        }

        @Override
        public AMsrStat.RestrictedRect fromLegacy(LegacyDictionary_2012_1 dict) {
            return new AMsrStat.RestrictedRect(super.fromLegacy(dict));
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }
    }

    protected class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)AMsrStat.this.getDomain());
        }

        @Override
        protected boolean canReplaceQuant(IQuantity old, IQuantity repl) {
            return old.equals(repl);
        }

        @Override
        protected Task taskReplaceQuant(IQuantity oldMsr, IQuantity newMsr) {
            assert (newMsr != null);
            return new AReplaceRefTask<IQuantity>((Object)AMsrStat.this.d_msr, (Object)newMsr){

                @Override
                protected void set(IQuantity obj) {
                    AMsrStat.this.d_msr = obj;
                    AMsrStat.this.changedEvt(new Object[0]);
                }
            };
        }
    }
}

