/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.surf;

import java.io.Serializable;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.boundcond.surf.HeatRelease;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class Fuel
implements Serializable {
    static final long serialVersionUID = 1L;

    public static class ManualReac
    implements IReaction {
        static final long serialVersionUID = 1L;
        public final HeatRelease d_heatRelease;
        public final IIgnition d_ignition;
        public final UnitDouble d_heatOfVap;

        public ManualReac() {
            this(new HeatRelease(), SIUS.newud(0.0, 46), new ImmediateIgnite());
        }

        public ManualReac(HeatRelease heatRelease, UnitDouble heatOfVap, IIgnition ignition) {
            this.d_heatRelease = heatRelease;
            this.d_heatOfVap = heatOfVap;
            this.d_ignition = ignition;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ManualReac)) {
                return false;
            }
            ManualReac r = (ManualReac)obj;
            return this.d_heatRelease.equals(r.d_heatRelease) && this.d_ignition.equals(r.d_ignition) && (this.d_heatOfVap == null ? r.d_heatOfVap == null : this.d_heatOfVap.equals(r.d_heatOfVap));
        }

        @Override
        public boolean invokesMixFrac() {
            return this.d_heatRelease.invokesMixFrac();
        }

        public static class ImmediateIgnite
        implements IIgnition {
            static final long serialVersionUID = 1L;

            public boolean equals(Object obj) {
                return obj instanceof ImmediateIgnite;
            }
        }

        public static interface IIgnition
        extends Serializable {
        }

        public static class TemperatureIgnite
        implements IIgnition {
            static final long serialVersionUID = 1L;
            public final UnitDouble d_temperature;

            public TemperatureIgnite() {
                this(new UnitDouble(5000.0, SI.CELSIUS));
            }

            public TemperatureIgnite(UnitDouble temp) {
                this.d_temperature = temp;
            }

            public boolean equals(Object obj) {
                return obj instanceof TemperatureIgnite && this.d_temperature.equals(((TemperatureIgnite)obj).d_temperature);
            }
        }
    }

    public static class MaterialReac
    implements IReaction {
        static final long serialVersionUID = 1L;

        public boolean equals(Object obj) {
            return obj instanceof MaterialReac;
        }

        @Override
        public boolean invokesMixFrac() {
            return false;
        }
    }

    public static interface IReaction
    extends Serializable {
        public boolean invokesMixFrac();
    }
}

