/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import pyrosim.legacy_2012_1.ILegacy_2012_1;

public class LegacyDictionary_2012_1 {
    private final Map<Object, Object> d_resolvedRefs = new IdentityHashMap<Object, Object>();
    private static final IResolver<ILegacy_2012_1> s_objResolver = new IResolver<ILegacy_2012_1>(){

        @Override
        public Object resolve(LegacyDictionary_2012_1 dict, ILegacy_2012_1 o) {
            return o.fromLegacy(dict);
        }
    };

    public Object get(ILegacy_2012_1 obj) {
        return this.resolve(obj, s_objResolver);
    }

    public <TCurr, TLeg extends ILegacy_2012_1> SortedSet<TCurr> get(SortedSet<TLeg> v) {
        if (v == null) {
            return null;
        }
        return (SortedSet)this.resolve(v, new SortedSetResolver());
    }

    public <TCurr, TLeg extends ILegacy_2012_1> List<TCurr> get(List<TLeg> v) {
        if (v == null) {
            return null;
        }
        return (List)this.resolve(v, new ListResolver());
    }

    public <TCurr, TLeg extends ILegacy_2012_1> TCurr[] get(Class<TCurr> currClazz, TLeg[] v) {
        if (v == null) {
            return null;
        }
        return (Object[])this.resolve(v, new ArrResolver(currClazz));
    }

    private <TCurr, TLeg> TCurr resolve(TLeg obj, IResolver<TLeg> resolver) {
        if (obj == null) {
            return null;
        }
        if (!this.d_resolvedRefs.containsKey(obj)) {
            Object result = resolver.resolve(this, obj);
            this.d_resolvedRefs.put(obj, result);
            return (TCurr)result;
        }
        return (TCurr)this.d_resolvedRefs.get(obj);
    }

    private static interface IResolver<T> {
        public Object resolve(LegacyDictionary_2012_1 var1, T var2);
    }

    private static class SortedSetResolver<TCurr, TLeg extends ILegacy_2012_1>
    implements IResolver<SortedSet<TLeg>> {
        private SortedSetResolver() {
        }

        @Override
        public Object resolve(LegacyDictionary_2012_1 dict, SortedSet<TLeg> o) {
            TreeSet<Object> result = new TreeSet<Object>();
            for (ILegacy_2012_1 leg : o) {
                result.add(dict.get(leg));
            }
            return result;
        }
    }

    private static class ListResolver<TCurr, TLeg extends ILegacy_2012_1>
    implements IResolver<Collection<TLeg>> {
        private ListResolver() {
        }

        @Override
        public Object resolve(LegacyDictionary_2012_1 dict, Collection<TLeg> o) {
            ArrayList<Object> result = new ArrayList<Object>(o.size());
            for (ILegacy_2012_1 leg : o) {
                result.add(dict.get(leg));
            }
            return result;
        }
    }

    private static class ArrResolver<TCurr, TLeg extends ILegacy_2012_1>
    implements IResolver<TLeg[]> {
        private final Class<TCurr> d_currClazz;

        public ArrResolver(Class<TCurr> currClazz) {
            this.d_currClazz = currClazz;
        }

        @Override
        public Object resolve(LegacyDictionary_2012_1 dict, TLeg[] o) {
            Object[] currArr = (Object[])Array.newInstance(this.d_currClazz, o.length);
            for (int m = 0; m < o.length; ++m) {
                currArr[m] = dict.get((ILegacy_2012_1)o[m]);
            }
            return currArr;
        }
    }
}

