/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import pyrosim.legacy_2006_2.thunderheadeng.util.DiscreteSignal;

public class AnalogSignal
extends DiscreteSignal {
    private static final long serialVersionUID = -3655710375763244224L;
    private double d_sampleInterval;
    private double[] d_data;

    protected AnalogSignal() {
    }

    @Override
    public DiscreteSignal newSignal(double sampleInterval, int numSamples) {
        return new AnalogSignal(sampleInterval, numSamples);
    }

    public AnalogSignal(double sampleInterval, int numSamples) {
        this.d_sampleInterval = sampleInterval;
        this.d_data = new double[numSamples];
    }

    public AnalogSignal(double sampleInterval, double[] data) {
        this.d_sampleInterval = sampleInterval;
        this.d_data = data;
    }

    public Object clone() {
        AnalogSignal clone = new AnalogSignal(this.getSampleInterval(), this.getNumSamples());
        System.arraycopy(this.d_data, 0, clone.d_data, 0, this.d_data.length);
        return clone;
    }

    @Override
    public int getNumSamples() {
        return this.d_data.length;
    }

    @Override
    public double getSampleInterval() {
        return this.d_sampleInterval;
    }

    @Override
    public void setSample(int sample, double value) {
        this.d_data[sample] = value;
    }

    @Override
    public double evaluateSample(int sample) {
        return this.d_data[sample];
    }

    @Override
    public double[] toArray() {
        return this.d_data;
    }

    @Override
    public void resample(double newSampleInterval) {
        if (newSampleInterval == this.d_sampleInterval) {
            return;
        }
        int newNumSamples = (int)Math.ceil((double)this.getNumSamples() * this.d_sampleInterval / newSampleInterval);
        double[] newData = new double[newNumSamples];
        for (int i = 0; i < newNumSamples; ++i) {
            int oldIndex = (int)Math.floor((double)i * this.d_sampleInterval / newSampleInterval);
            newData[i] = this.evaluateSample(oldIndex);
        }
        this.d_sampleInterval = newSampleInterval;
        this.d_data = newData;
    }
}

