/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import pyrosim.legacy_2006_2.thunderheadeng.gui.DlgListener;
import pyrosim.legacy_2006_2.thunderheadeng.gui.Modifiable;
import pyrosim.legacy_2006_2.thunderheadeng.gui.guiPanel;

public class guiDialog
extends JDialog
implements Modifiable {
    private static final long serialVersionUID = -9121253956771601671L;
    public static final int OK = 1;
    public static final int APPLY = 2;
    public static final int RESET = 4;
    public static final int CANCEL = 8;
    public static final int CLOSE = 16;
    public static final int HELP = 32;
    private JPanel d_btnPanel;
    private guiPanel d_dialogPane;
    protected int d_status;
    private Window d_owner = null;
    private Vector d_listeners = new Vector();
    private JButton d_helpButton;
    private JButton d_okButton;
    private JButton d_cancelButton;
    private JButton d_closeButton;
    private JButton d_resetButton;
    private JButton d_applyButton;
    protected CancelListener d_cancelListener;
    private boolean d_minimumSizeEnabled = false;
    private boolean d_disposeAfterModal = true;

    public guiDialog(JFrame owner) {
        this(owner, "", 0);
    }

    public guiDialog(JFrame owner, String title) {
        this(owner, title, 0);
    }

    public guiDialog(JDialog owner, String title, int buttons) {
        super((Dialog)owner, title);
        this.init(owner, buttons);
    }

    public guiDialog(JFrame owner, String title, int buttons) {
        super((Frame)owner, title);
        this.init(owner, buttons);
    }

    private void init(Window owner, int buttons) {
        JButton button;
        this.d_owner = owner;
        this.setResizable(false);
        this.setModal(true);
        JPanel btnHolder = new JPanel(new FlowLayout(2, 0, 0));
        this.d_btnPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        btnHolder.setBorder(BorderFactory.createEmptyBorder(6, 12, 11, 11));
        btnHolder.add(this.d_btnPanel);
        this.d_dialogPane = new guiPanel(new BorderLayout());
        this.d_dialogPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.getContentPane().add((Component)this.d_dialogPane, "Center");
        this.getContentPane().add((Component)btnHolder, "South");
        this.d_cancelListener = new CancelListener();
        this.getRootPane().registerKeyboardAction(this.d_cancelListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.addWindowListener(this.d_cancelListener);
        if ((buttons & 2) != 0) {
            this.d_applyButton = new ApplyBtn(this);
            button = this.d_applyButton;
            this.addButton(button);
            this.getRootPane().setDefaultButton(button);
        }
        if ((buttons & 1) != 0) {
            this.d_okButton = new OkBtn(this);
            button = this.d_okButton;
            this.addButton(button);
            this.getRootPane().setDefaultButton(button);
        }
        if ((buttons & 4) != 0) {
            this.d_resetButton = new ResetBtn(this);
            button = this.d_resetButton;
            this.addButton(button);
        }
        if ((buttons & 8) != 0) {
            this.d_cancelButton = new CancelBtn(this);
            button = this.d_cancelButton;
            this.addButton(button);
        }
        if ((buttons & 0x10) != 0) {
            this.d_closeButton = new CloseBtn(this);
            button = this.d_closeButton;
            this.addButton(button);
        }
        if ((buttons & 0x20) != 0) {
            this.d_helpButton = new HelpBtn(this);
            this.addButton(this.d_helpButton);
        }
        this.setSize(0, 0);
    }

    public JButton getButton(int button) {
        switch (button) {
            case 2: {
                return this.d_applyButton;
            }
            case 1: {
                return this.d_okButton;
            }
            case 4: {
                return this.d_resetButton;
            }
            case 8: {
                return this.d_cancelButton;
            }
            case 16: {
                return this.d_closeButton;
            }
            case 32: {
                return this.d_helpButton;
            }
        }
        return null;
    }

    public void setButtons(JComponent[] buttons) {
        this.d_btnPanel.removeAll();
        for (int i = 0; i < buttons.length; ++i) {
            this.addButton(buttons[i]);
        }
    }

    public void addButton(JComponent button) {
        JButton tmpButton = new JButton("Cancel");
        Dimension minSize = tmpButton.getPreferredSize();
        if (button.getPreferredSize().getWidth() < (double)minSize.width) {
            button.setPreferredSize(minSize);
        }
        this.d_btnPanel.add(button);
    }

    public guiPanel getDialogPane() {
        return this.d_dialogPane;
    }

    public void setHelpIDString(String id) {
    }

    public void center() {
        Dimension dialogSize = this.getSize();
        if (this.d_owner == null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Point location = new Point(0, 0);
            this.setLocation(location.x + screenSize.width / 2 - dialogSize.width / 2, location.y + screenSize.height / 2 - dialogSize.height / 2);
        } else {
            Dimension screenSize = this.d_owner.getSize();
            Point location = this.d_owner.getLocation();
            int cenX = location.x + screenSize.width / 2;
            int cenY = location.y + screenSize.height / 2;
            Dimension crtSize = Toolkit.getDefaultToolkit().getScreenSize();
            int shiftX = cenX + dialogSize.width / 2 - crtSize.width;
            int shiftY = cenY + dialogSize.height / 2 - crtSize.height;
            int ulX = Math.min(cenX - dialogSize.width / 2, cenX - dialogSize.width / 2 - shiftX);
            int ulY = Math.min(cenY - dialogSize.height / 2, cenY - dialogSize.height / 2 - shiftY);
            this.setLocation(Math.max(0, ulX), Math.max(0, ulY));
        }
    }

    private void beginShowing() {
        this.d_status = 8;
        Dimension setSize = this.getSize();
        if (setSize.width == 0 || setSize.height == 0 || this.d_minimumSizeEnabled) {
            this.pack();
        }
        if (this.d_minimumSizeEnabled) {
            this.setMinimumSize(this.getPreferredSize());
        }
        if (setSize.width != 0 && setSize.height != 0) {
            this.setSize(setSize);
        }
        this.center();
        this.setVisible(true);
    }

    public boolean doModeless() {
        if (this.isVisible()) {
            return false;
        }
        this.setModal(false);
        this.beginShowing();
        return true;
    }

    public int doModal() {
        this.setModal(true);
        this.beginShowing();
        return this.d_status;
    }

    public void setDisposeAfterModal(boolean dispose) {
        this.d_disposeAfterModal = dispose;
    }

    public void setMinimumSizeEnabled(boolean enabled) {
        if (enabled) {
            this.enableEvents(101L);
        } else {
            this.disableEvents(101L);
        }
        this.d_minimumSizeEnabled = enabled;
    }

    @Override
    protected void processComponentEvent(ComponentEvent e) {
        super.processComponentEvent(e);
        Dimension d = this.getSize();
        Dimension minSize = this.getMinimumSize();
        if (d.width < minSize.width) {
            d.width = minSize.width;
        }
        if (d.height < minSize.height) {
            d.height = minSize.height;
        }
        this.setSize(d);
    }

    public int getStatus() {
        return this.d_status;
    }

    public boolean validateData() {
        return this.d_dialogPane.validateData();
    }

    @Override
    public boolean isModified() {
        return this.d_dialogPane.isModified();
    }

    @Override
    public void setModified(boolean modified) {
        this.d_dialogPane.setModified(modified);
    }

    public void addDlgListener(DlgListener l) {
        this.d_listeners.add(l);
    }

    public void removeDlgListener(DlgListener l) {
        this.d_listeners.remove(l);
    }

    protected void fireButtonPressed(int button) {
        block8: for (int i = 0; i < this.d_listeners.size(); ++i) {
            DlgListener l = (DlgListener)this.d_listeners.get(i);
            switch (button) {
                case 1: {
                    l.okPressed();
                    continue block8;
                }
                case 2: {
                    l.applyPressed();
                    continue block8;
                }
                case 4: {
                    l.resetPressed();
                    continue block8;
                }
                case 8: {
                    l.cancelPressed();
                    continue block8;
                }
                case 16: {
                    l.closePressed();
                    continue block8;
                }
                case 32: {
                    l.helpPressed();
                    continue block8;
                }
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible && this.d_disposeAfterModal) {
            this.dispose();
        }
    }

    protected void showMessageBox(String msg) {
        guiDialog.showInvalidEntryMessage(this, msg);
    }

    public static void showInvalidEntryMessage(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, "Invalid Entry", 2);
    }

    protected void requestFocusHack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                guiDialog.this.requestFocus();
            }
        });
    }

    private class CancelListener
    extends WindowAdapter
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.cancel();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.cancel();
        }

        private void cancel() {
            guiDialog.this.d_status = 8;
            guiDialog.this.fireButtonPressed(8);
            guiDialog.this.setVisible(false);
        }
    }

    public static class ApplyBtn
    extends JButton {
        private static final long serialVersionUID = 8450936287931651030L;
        private guiDialog d_dlg;

        public ApplyBtn(guiDialog dlg) {
            super("Apply");
            this.d_dlg = dlg;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (d_dlg.validateData()) {
                        d_dlg.d_status = 2;
                        d_dlg.fireButtonPressed(2);
                    }
                }
            });
        }
    }

    public static class OkBtn
    extends JButton {
        private static final long serialVersionUID = -1186375968506063135L;
        private guiDialog d_dlg;

        public OkBtn(guiDialog dlg) {
            super("OK");
            this.d_dlg = dlg;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (d_dlg.validateData()) {
                        d_dlg.d_status = 1;
                        d_dlg.fireButtonPressed(1);
                        d_dlg.setVisible(false);
                    }
                }
            });
        }
    }

    public static class ResetBtn
    extends JButton {
        private static final long serialVersionUID = -1747371388125153307L;
        private guiDialog d_dlg;

        public ResetBtn(guiDialog dlg) {
            super("Reset");
            this.d_dlg = dlg;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d_dlg.fireButtonPressed(4);
                }
            });
        }
    }

    public static class CancelBtn
    extends JButton {
        private static final long serialVersionUID = -2693966101802036331L;
        private guiDialog d_dlg;

        public CancelBtn(guiDialog dlg) {
            super("Cancel");
            this.d_dlg = dlg;
            this.addActionListener(this.d_dlg.d_cancelListener);
        }
    }

    public static class CloseBtn
    extends JButton {
        private static final long serialVersionUID = -5503470940940567407L;
        private guiDialog d_dlg;

        public CloseBtn(guiDialog dlg) {
            super("Close");
            this.d_dlg = dlg;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d_dlg.d_status = 16;
                    d_dlg.fireButtonPressed(16);
                    d_dlg.setVisible(false);
                }
            });
        }
    }

    public static class HelpBtn
    extends JButton {
        private static final long serialVersionUID = 208177938893573209L;
        private guiDialog d_dlg;

        public HelpBtn(guiDialog dlg) {
            super("Help");
            this.d_dlg = dlg;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d_dlg.fireButtonPressed(32);
                }
            });
        }
    }
}

