/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v17;

import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class UnitPoint3D
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public UnitDouble x;
    public UnitDouble y;
    public UnitDouble z;

    public UnitPoint3D() {
    }

    public UnitPoint3D(UnitDouble x, UnitDouble y, UnitDouble z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public UnitPoint3D(double x, double y, double z, Unit unit) {
        this(new UnitDouble(x, unit), new UnitDouble(y, unit), new UnitDouble(z, unit));
    }

    public UnitPoint3D(Tuple3d vec, Unit unit) {
        this(new UnitDouble(vec.x, unit), new UnitDouble(vec.y, unit), new UnitDouble(vec.z, unit));
    }

    public void set(double x, double y, double z, Unit unit) {
        this.x = new UnitDouble(x, unit);
        this.y = new UnitDouble(y, unit);
        this.z = new UnitDouble(z, unit);
    }

    public Point3d getPoint3dValue(Unit desiredUnit) {
        return new Point3d(this.x.getValue(desiredUnit), this.y.getValue(desiredUnit), this.z.getValue(desiredUnit));
    }

    public Vector3d getVector3dValue(Unit desiredUnit) {
        return new Vector3d(this.x.getValue(desiredUnit), this.y.getValue(desiredUnit), this.z.getValue(desiredUnit));
    }

    public Object clone() {
        return new UnitPoint3D((UnitDouble)this.x.clone(), (UnitDouble)this.y.clone(), (UnitDouble)this.z.clone());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnitPoint3D)) {
            return false;
        }
        UnitPoint3D p = (UnitPoint3D)obj;
        return this.x.equals(p.x) && this.y.equals(p.y) && this.z.equals(p.z);
    }

    public String toString() {
        return "(" + String.valueOf(this.x) + "," + String.valueOf(this.y) + "," + String.valueOf(this.z) + ")";
    }
}

