/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Map;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.Activatable;
import pyrosim.legacy_2006_2.domain.HeatActivationEvent;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.domain.HeatDetectorList;
import pyrosim.legacy_2006_2.domain.TimeActivationEvent;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class EventParser {
    public static Activatable getCorrectObject(Map objectsOfSameType, Activatable newObject) {
        Activatable existingObject;
        Activatable correctObject = newObject;
        if (objectsOfSameType.size() > 0 && (existingObject = (Activatable)objectsOfSameType.get(newObject.getPropertyHashString())) != null) {
            correctObject = existingObject;
        }
        return correctObject;
    }

    public static void parseEvents(AFDSRecordProcessor processor, Activatable object, FDSInputRecord rec, String[] activateStrings, String[] deactivateStrings, String heatActivateString, String heatDeactivateString, HeatDetectorList heatDetectors) throws FDSRecordFormatException, ClassCastException {
        String heatDeactivateID;
        HeatDetector h;
        int heatDetIndex;
        Double value;
        int m;
        Unit time = FdsSISystem.getInstance().getTimeUnit();
        for (m = 0; m < activateStrings.length; ++m) {
            value = (Double)rec.getValue(activateStrings[m]);
            if (value == null) continue;
            if (value >= 0.0) {
                object.addEvent(new TimeActivationEvent(new UnitDouble(value, time), 0));
                continue;
            }
            heatDetIndex = Math.abs(value.intValue()) - 1;
            h = heatDetectors.getAt(heatDetIndex);
            if (h == null) {
                object.setCanBeTriggeredByAnyHeatDetector(true, 0);
                continue;
            }
            object.addEvent(new HeatActivationEvent(h, 0));
        }
        for (m = 0; m < deactivateStrings.length; ++m) {
            value = (Double)rec.getValue(deactivateStrings[m]);
            if (value == null) continue;
            if (value >= 0.0) {
                object.addEvent(new TimeActivationEvent(new UnitDouble(value, time), 1));
                continue;
            }
            heatDetIndex = Math.abs(value.intValue()) - 1;
            h = heatDetectors.getAt(heatDetIndex);
            if (h == null) {
                object.setCanBeTriggeredByAnyHeatDetector(true, 1);
                continue;
            }
            object.addEvent(new HeatActivationEvent(h, 1));
        }
        String heatActivateID = (String)rec.getValue(heatActivateString);
        if (heatActivateID != null) {
            if (heatActivateID.equals("ALL")) {
                object.setCanBeTriggeredByAnyHeatDetector(true, 0);
            } else {
                HeatDetector h2 = processor.getResource(heatActivateID, HeatDetector.class);
                if (h2 == null) {
                    throw new FDSRecordFormatException(rec, "The heat detector, \"" + heatActivateID + ",\" does not exist in the model.");
                }
                object.addEvent(new HeatActivationEvent(h2, 0));
            }
        }
        if ((heatDeactivateID = (String)rec.getValue(heatDeactivateString)) != null) {
            if (heatDeactivateID.equals("ALL")) {
                object.setCanBeTriggeredByAnyHeatDetector(true, 1);
            } else {
                HeatDetector h3 = processor.getResource(heatDeactivateID, HeatDetector.class);
                if (h3 == null) {
                    throw new FDSRecordFormatException(rec, "The heat detector, \"" + heatDeactivateID + ",\" does not exist in the model.");
                }
                object.addEvent(new HeatActivationEvent(h3, 1));
            }
        }
    }
}

