/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.geom;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.nativebuffered.BoundingBox3D;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class Prism
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    boolean d_axisAligned;
    private Point3d[] d_points;
    private Material[] d_materials;
    private Color d_color;

    private Prism() {
        this.d_points = new Point3d[8];
    }

    public Prism(double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        this.d_points = new Point3d[8];
        this.d_points[0] = new Point3d(minX, minY, minZ);
        this.d_points[1] = new Point3d(maxX, minY, minZ);
        this.d_points[2] = new Point3d(maxX, maxY, minZ);
        this.d_points[3] = new Point3d(minX, maxY, minZ);
        this.d_points[4] = new Point3d(minX, minY, maxZ);
        this.d_points[5] = new Point3d(maxX, minY, maxZ);
        this.d_points[6] = new Point3d(maxX, maxY, maxZ);
        this.d_points[7] = new Point3d(minX, maxY, maxZ);
        this.d_axisAligned = true;
    }

    public Prism(Point3d[] points) {
        if (points.length != 8) {
            throw new IllegalArgumentException("Array must have 8 points.");
        }
        this.d_points = points;
        this.d_axisAligned = false;
    }

    public Prism(Point3D min, Point3D max) {
        this(min.x, max.x, min.y, max.y, min.z, max.z);
    }

    public static Prism fromLegacy(pyrosim.legacy_2006_2.legacy.v17.Prism p) {
        BoundingBox3D bb = new BoundingBox3D();
        for (int m = 0; m < 8; ++m) {
            Point3D oldPoint = p.getPoint(m);
            bb.add(new Point3d(oldPoint.x, oldPoint.y, oldPoint.z));
        }
        return new Prism(bb.getMin().x, bb.getMin().y, bb.getMin().z, bb.getMax().x, bb.getMax().y, bb.getMax().z);
    }

    public Object clone() {
        Prism clone = new Prism();
        for (int i = 0; i < 8; ++i) {
            clone.d_points[i] = new Point3d(this.d_points[i].x, this.d_points[i].y, this.d_points[i].z);
        }
        if (this.d_materials != null) {
            clone.d_materials = new Material[this.d_materials.length];
            System.arraycopy(this.d_materials, 0, clone.d_materials, 0, this.d_materials.length);
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Prism)) {
            return false;
        }
        return Arrays.equals(this.d_points, ((Prism)obj).d_points) && Arrays.equals(this.d_materials, ((Prism)obj).d_materials);
    }

    public void translate(double dx, double dy, double dz) {
        for (int i = 0; i < this.d_points.length; ++i) {
            this.d_points[i].x += dx;
            this.d_points[i].y += dy;
            this.d_points[i].z += dz;
        }
    }

    public void mirror(int plane, UnitDouble value) {
    }

    public Point3d getPoint(int index) {
        return this.d_points[index];
    }

    public Material getMaterial(int faceIndex) {
        return this.d_materials[faceIndex];
    }

    public void setMaterial(Material mat) {
        this.setMaterials(new Material[]{mat, mat, mat, mat, mat, mat});
    }

    public void setMaterials(Material[] mats) {
        if (mats.length != 6) {
            throw new IllegalArgumentException();
        }
        this.d_materials = mats;
    }

    public void setColor(Color c) {
        this.d_color = c;
    }

    public Color getColor() {
        return this.d_color;
    }

    public Quad getFace(int faceIndex) {
        PrimProps props = new PrimProps();
        if (this.d_materials != null) {
            props.setMaterial(this.d_materials[faceIndex]);
        }
        props.setColor(this.getColor());
        Vector3d normal = Prism.getNormal(this.d_axisAligned, faceIndex);
        Quad q = null;
        switch (faceIndex) {
            case 0: {
                q = new Quad(this.getPoint(3), this.getPoint(0), this.getPoint(4), this.getPoint(7), normal, props);
                break;
            }
            case 1: {
                q = new Quad(this.getPoint(1), this.getPoint(2), this.getPoint(6), this.getPoint(5), normal, props);
                break;
            }
            case 2: {
                q = new Quad(this.getPoint(0), this.getPoint(1), this.getPoint(5), this.getPoint(4), normal, props);
                break;
            }
            case 3: {
                q = new Quad(this.getPoint(2), this.getPoint(3), this.getPoint(7), this.getPoint(6), normal, props);
                break;
            }
            case 4: {
                q = new Quad(this.getPoint(3), this.getPoint(2), this.getPoint(1), this.getPoint(0), normal, props);
                break;
            }
            case 5: {
                q = new Quad(this.getPoint(4), this.getPoint(5), this.getPoint(6), this.getPoint(7), normal, props);
                break;
            }
            default: {
                return null;
            }
        }
        return q;
    }

    public static Quad getFaceForBox(Point3D min, Point3D max, int faceIndex, PrimProps props) {
        Vector3d normal = Prism.getNormal(true, faceIndex);
        Quad q = null;
        switch (faceIndex) {
            case 0: {
                q = new Quad(new Point3d(min.x, max.y, min.z), new Point3d(min.x, min.y, min.z), new Point3d(min.x, min.y, max.z), new Point3d(min.x, max.y, max.z), normal, props);
                break;
            }
            case 1: {
                q = new Quad(new Point3d(max.x, min.y, min.z), new Point3d(max.x, max.y, min.z), new Point3d(max.x, max.y, max.z), new Point3d(max.x, min.y, max.z), normal, props);
                break;
            }
            case 2: {
                q = new Quad(new Point3d(min.x, min.y, min.z), new Point3d(max.x, min.y, min.z), new Point3d(max.x, min.y, max.z), new Point3d(min.x, min.y, max.z), normal, props);
                break;
            }
            case 3: {
                q = new Quad(new Point3d(max.x, max.y, min.z), new Point3d(min.x, max.y, min.z), new Point3d(min.x, max.y, max.z), new Point3d(max.x, max.y, max.z), normal, props);
                break;
            }
            case 4: {
                q = new Quad(new Point3d(min.x, max.y, min.z), new Point3d(max.x, max.y, min.z), new Point3d(max.x, min.y, min.z), new Point3d(min.x, min.y, min.z), normal, props);
                break;
            }
            case 5: {
                q = new Quad(new Point3d(min.x, min.y, max.z), new Point3d(max.x, min.y, max.z), new Point3d(max.x, max.y, max.z), new Point3d(min.x, max.y, max.z), normal, props);
                break;
            }
            default: {
                return null;
            }
        }
        return q;
    }

    private static Vector3d getNormal(boolean aligned, int faceIndex) {
        if (!aligned) {
            return null;
        }
        switch (faceIndex) {
            case 0: {
                return Geometry.VEC3D_XNEG;
            }
            case 1: {
                return Geometry.VEC3D_XPOS;
            }
            case 2: {
                return Geometry.VEC3D_YNEG;
            }
            case 3: {
                return Geometry.VEC3D_YPOS;
            }
            case 4: {
                return Geometry.VEC3D_ZNEG;
            }
            case 5: {
                return Geometry.VEC3D_ZPOS;
            }
        }
        return null;
    }
}

